/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.harness.AccumuloITBase;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.miniclusterImpl.ZooKeeperBindException;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.test.functional.NativeMapIT;
import org.apache.accumulo.test.util.CertUtils;
import org.apache.accumulo.tserver.memory.NativeMapLoader;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="MiniClusterOnly")
public class ConfigurableMacBase
extends AccumuloITBase {
    public static final Logger log = LoggerFactory.getLogger(ConfigurableMacBase.class);
    protected MiniAccumuloClusterImpl cluster;
    protected static final String ROOT_PASSWORD = "testRootPassword1";

    protected void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
    }

    protected void beforeClusterStart(MiniAccumuloConfigImpl cfg) {
    }

    public static void configureForEnvironment(MiniAccumuloConfigImpl cfg, File folder) {
        if ("true".equals(System.getProperty("org.apache.accumulo.test.functional.useSslForIT"))) {
            ConfigurableMacBase.configureForSsl(cfg, folder);
        }
        if ("true".equals(System.getProperty("org.apache.accumulo.test.functional.useCredProviderForIT"))) {
            cfg.setUseCredentialProvider(true);
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="paths provided by test")
    protected static void configureForSsl(MiniAccumuloConfigImpl cfg, File sslDir) {
        Map siteConfig = cfg.getSiteConfig();
        if ("true".equals(siteConfig.get(Property.INSTANCE_RPC_SSL_ENABLED.getKey()))) {
            return;
        }
        Assertions.assertTrue((sslDir.mkdirs() || sslDir.isDirectory() ? 1 : 0) != 0);
        FileUtils.deleteQuietly((File)sslDir);
        Assertions.assertTrue((boolean)sslDir.mkdir());
        File rootKeystoreFile = new File(sslDir, "root-" + cfg.getInstanceName() + ".jks");
        File localKeystoreFile = new File(sslDir, "local-" + cfg.getInstanceName() + ".jks");
        File publicTruststoreFile = new File(sslDir, "public-" + cfg.getInstanceName() + ".jks");
        String rootKeystorePassword = "root_keystore_password";
        String truststorePassword = "truststore_password";
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            new CertUtils(Property.RPC_SSL_KEYSTORE_TYPE.getDefaultValue(), "o=Apache Accumulo,cn=" + hostname, "RSA", 4096, "SHA512WITHRSA").createAll(rootKeystoreFile, localKeystoreFile, publicTruststoreFile, cfg.getInstanceName(), "root_keystore_password", cfg.getRootPassword(), "truststore_password");
        }
        catch (Exception e) {
            throw new RuntimeException("error creating MAC keystore", e);
        }
        siteConfig.put(Property.INSTANCE_RPC_SSL_ENABLED.getKey(), "true");
        siteConfig.put(Property.RPC_SSL_KEYSTORE_PATH.getKey(), localKeystoreFile.getAbsolutePath());
        siteConfig.put(Property.RPC_SSL_KEYSTORE_PASSWORD.getKey(), cfg.getRootPassword());
        siteConfig.put(Property.RPC_SSL_TRUSTSTORE_PATH.getKey(), publicTruststoreFile.getAbsolutePath());
        siteConfig.put(Property.RPC_SSL_TRUSTSTORE_PASSWORD.getKey(), "truststore_password");
        cfg.setSiteConfig(siteConfig);
        Map clientProps = cfg.getClientProps();
        clientProps.put(ClientProperty.SSL_ENABLED.getKey(), "true");
        clientProps.put(ClientProperty.SSL_KEYSTORE_PATH.getKey(), localKeystoreFile.getAbsolutePath());
        clientProps.put(ClientProperty.SSL_KEYSTORE_PASSWORD.getKey(), cfg.getRootPassword());
        clientProps.put(ClientProperty.SSL_TRUSTSTORE_PATH.getKey(), publicTruststoreFile.getAbsolutePath());
        clientProps.put(ClientProperty.SSL_TRUSTSTORE_PASSWORD.getKey(), "truststore_password");
        cfg.setClientProps(clientProps);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.createMiniAccumulo();
        ZooKeeperBindException lastException = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.cluster.start();
                return;
            }
            catch (ZooKeeperBindException e) {
                lastException = e;
                log.warn("Failed to start MiniAccumuloCluster, assumably due to ZooKeeper issues", (Throwable)lastException);
                Thread.sleep(3000L);
                this.createMiniAccumulo();
                continue;
            }
        }
        throw new RuntimeException("Failed to start MiniAccumuloCluster after three attempts", lastException);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="path provided by test")
    private void createMiniAccumulo() throws Exception {
        File baseDir = ConfigurableMacBase.createTestDir(this.getClass().getName() + "_" + this.testName());
        MiniAccumuloConfigImpl cfg = new MiniAccumuloConfigImpl(baseDir, ROOT_PASSWORD);
        File nativePathInDevTree = NativeMapIT.nativeMapLocation();
        File nativePathInMapReduce = new File(System.getProperty("user.dir"));
        cfg.setNativeLibPaths(new String[]{nativePathInDevTree.getAbsolutePath(), nativePathInMapReduce.toString()});
        Configuration coreSite = new Configuration(false);
        cfg.setProperty(Property.TSERV_NATIVEMAP_ENABLED, Boolean.TRUE.toString());
        this.configure(cfg, coreSite);
        ConfigurableMacBase.configureForEnvironment(cfg, ConfigurableMacBase.getSslDir(baseDir));
        if (Boolean.parseBoolean((String)cfg.getSiteConfig().get(Property.TSERV_NATIVEMAP_ENABLED.getKey()))) {
            NativeMapLoader.loadForTest(List.of(nativePathInDevTree, nativePathInMapReduce), () -> {
                throw new IllegalStateException("Native maps were configured, but not available");
            });
        }
        this.cluster = new MiniAccumuloClusterImpl(cfg);
        if (coreSite.size() > 0) {
            File csFile = new File(this.cluster.getConfig().getConfDir(), "core-site.xml");
            if (csFile.exists()) {
                coreSite.addResource(new Path(csFile.getAbsolutePath()));
            }
            File tmp = new File(csFile.getAbsolutePath() + ".tmp");
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmp));
            coreSite.writeXml((OutputStream)out);
            ((OutputStream)out).close();
            Assertions.assertTrue((boolean)tmp.renameTo(csFile));
        }
        this.beforeClusterStart(cfg);
    }

    @AfterEach
    public void tearDown() {
        if (this.cluster != null) {
            try {
                this.cluster.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected MiniAccumuloClusterImpl getCluster() {
        return this.cluster;
    }

    protected Properties getClientProperties() {
        return this.cluster.getClientProperties();
    }

    protected ServerContext getServerContext() {
        return this.getCluster().getServerContext();
    }

    protected Process exec(Class<?> clazz, String ... args) throws IOException {
        return this.getCluster().exec(clazz, args).getProcess();
    }
}

