/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class CreateAndUseIT
extends AccumuloClusterHarness {
    private static NewTableConfiguration ntc;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(4L);
    }

    @BeforeAll
    public static void createData() {
        TreeSet<Text> splits = new TreeSet<Text>();
        for (int i = 1; i < 256; ++i) {
            splits.add(new Text(String.format("%08x", i << 8)));
        }
        ntc = new NewTableConfiguration().withSplits(splits);
    }

    @Test
    public void verifyDataIsPresent() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CreateAndUseIT.getClientProps()).build();){
            Text cf = new Text("cf1");
            Text cq = new Text("cq1");
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName, ntc);
            try (BatchWriter bw = client.createBatchWriter(tableName);){
                for (int i = 1; i < 257; ++i) {
                    Mutation m = new Mutation(new Text(String.format("%08x", (i << 8) - 16)));
                    m.put(cf, cq, new Value((CharSequence)Integer.toString(i)));
                    bw.addMutation(m);
                }
            }
            try (Scanner scanner1 = client.createScanner(tableName, Authorizations.EMPTY);){
                int ei = 1;
                for (Map.Entry entry : scanner1) {
                    Assertions.assertEquals((Object)String.format("%08x", (ei << 8) - 16), (Object)((Key)entry.getKey()).getRow().toString());
                    Assertions.assertEquals((Object)Integer.toString(ei), (Object)((Value)entry.getValue()).toString());
                    ++ei;
                }
                Assertions.assertEquals((int)257, (int)ei, (String)"Did not see expected number of rows");
            }
        }
    }

    @Test
    public void createTableAndScan() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CreateAndUseIT.getClientProps()).build();){
            String table2 = this.getUniqueNames(1)[0];
            client.tableOperations().create(table2, ntc);
            try (Scanner scanner2 = client.createScanner(table2, Authorizations.EMPTY);){
                int count = 0;
                for (Map.Entry entry : scanner2) {
                    if (entry == null) continue;
                    ++count;
                }
                if (count != 0) {
                    throw new Exception("Did not see expected number of entries, count = " + count);
                }
            }
        }
    }

    @Test
    public void createTableAndBatchScan() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CreateAndUseIT.getClientProps()).build();){
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int i = 1; i < 257; ++i) {
                ranges.add(new Range(new Text(String.format("%08x", (i << 8) - 16))));
            }
            String table3 = this.getUniqueNames(1)[0];
            client.tableOperations().create(table3, ntc);
            try (BatchScanner bs = client.createBatchScanner(table3);){
                bs.setRanges(ranges);
                Assertions.assertTrue((boolean)bs.stream().findAny().isEmpty(), (String)"Did not expect to find any entries");
            }
        }
    }
}

