/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CredentialsIT
extends AccumuloClusterHarness {
    private boolean saslEnabled;
    private String username;
    private String password;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(2L);
    }

    @BeforeEach
    public void createLocalUser() throws AccumuloException, AccumuloSecurityException {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CredentialsIT.getClientProps()).build();){
            ClusterUser user = this.getUser(0);
            this.username = user.getPrincipal();
            this.saslEnabled = CredentialsIT.saslEnabled();
            Set users = client.securityOperations().listLocalUsers();
            if (!users.contains(this.username)) {
                PasswordToken passwdToken = null;
                if (!this.saslEnabled) {
                    this.password = user.getPassword();
                    passwdToken = new PasswordToken((CharSequence)this.password);
                }
                client.securityOperations().createLocalUser(this.username, passwdToken);
            }
        }
    }

    @AfterEach
    public void deleteLocalUser() throws Exception {
        if (this.saslEnabled) {
            ClusterUser root = this.getAdminUser();
            UserGroupInformation.loginUserFromKeytab((String)root.getPrincipal(), (String)root.getKeytab().getAbsolutePath());
        }
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CredentialsIT.getClientProps()).build();){
            client.securityOperations().dropLocalUser(this.username);
        }
    }

    @Test
    public void testConnectorWithDestroyedToken() throws Exception {
        AuthenticationToken token = this.getUser(0).getToken();
        Assertions.assertFalse((boolean)token.isDestroyed());
        token.destroy();
        Assertions.assertTrue((boolean)token.isDestroyed());
        Properties props = CredentialsIT.getClientProps();
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ((AccumuloClient)Accumulo.newClient().from(props).as((CharSequence)"non_existent_user", token).build()).close());
        Assertions.assertEquals((Object)e.getMessage(), (Object)"AuthenticationToken has been destroyed");
    }

    @Test
    public void testDestroyTokenBeforeRPC() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(CredentialsIT.getClientProps()).build();){
            AuthenticationToken token = this.getUser(0).getToken();
            try (AccumuloClient userAccumuloClient = (AccumuloClient)Accumulo.newClient().from(client.properties()).as((CharSequence)this.username, token).build();
                 Scanner scanner = userAccumuloClient.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                Assertions.assertFalse((boolean)token.isDestroyed());
                token.destroy();
                Assertions.assertTrue((boolean)token.isDestroyed());
                Iterator iter = scanner.iterator();
                RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, iter::hasNext);
                Assertions.assertTrue((boolean)(e.getCause() instanceof AccumuloSecurityException));
                Assertions.assertEquals((Object)((AccumuloSecurityException)e.getCause()).getSecurityErrorCode(), (Object)SecurityErrorCode.TOKEN_EXPIRED);
            }
        }
    }
}

