/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DeleteEverythingIT
extends AccumuloClusterHarness {
    private String majcDelay;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        Map siteConfig = cfg.getSiteConfig();
        siteConfig.put(Property.TSERV_MAJC_DELAY.getKey(), "1s");
        cfg.setSiteConfig(siteConfig);
    }

    @BeforeEach
    public void updateMajcDelay() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(DeleteEverythingIT.getClientProps()).build();){
            this.majcDelay = (String)c.instanceOperations().getSystemConfiguration().get(Property.TSERV_MAJC_DELAY.getKey());
            c.instanceOperations().setProperty(Property.TSERV_MAJC_DELAY.getKey(), "1s");
            if (DeleteEverythingIT.getClusterType() == AccumuloClusterHarness.ClusterType.STANDALONE) {
                Thread.sleep(ConfigurationTypeHelper.getTimeInMillis((String)this.majcDelay));
            }
        }
    }

    @AfterEach
    public void resetMajcDelay() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(DeleteEverythingIT.getClientProps()).build();){
            c.instanceOperations().setProperty(Property.TSERV_MAJC_DELAY.getKey(), this.majcDelay);
        }
    }

    @Test
    public void run() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(DeleteEverythingIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            BatchWriter bw = c.createBatchWriter(tableName);
            Mutation m = new Mutation(new Text("foo"));
            m.put((CharSequence)"bar", (CharSequence)"1910", (CharSequence)"5");
            bw.addMutation(m);
            bw.flush();
            c.tableOperations().flush(tableName, null, null, true);
            FunctionalTestUtils.checkRFiles(c, tableName, 1, 1, 1, 1);
            m = new Mutation(new Text("foo"));
            m.putDelete(new Text("bar"), new Text("1910"));
            bw.addMutation(m);
            bw.flush();
            try (Scanner scanner = c.createScanner(tableName, Authorizations.EMPTY);){
                scanner.setRange(new Range());
                Assertions.assertTrue((boolean)scanner.stream().findAny().isEmpty());
                c.tableOperations().flush(tableName, null, null, true);
                c.tableOperations().setProperty(tableName, Property.TABLE_MAJC_RATIO.getKey(), "1.0");
                UtilWaitThread.sleepUninterruptibly((long)4L, (TimeUnit)TimeUnit.SECONDS);
                FunctionalTestUtils.checkRFiles(c, tableName, 1, 1, 0, 0);
                bw.close();
                Assertions.assertTrue((boolean)scanner.stream().findAny().isEmpty());
            }
        }
    }
}

