/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Collections;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.iteratorsImpl.system.DeletingIterator;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DeleteFailIT
extends AccumuloClusterHarness {
    @Test
    public void testFail() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(DeleteFailIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            ntc.setProperties(Collections.singletonMap(Property.TABLE_DELETE_BEHAVIOR.getKey(), DeletingIterator.Behavior.FAIL.name()));
            c.tableOperations().create(tableName, ntc);
            try (BatchWriter writer = c.createBatchWriter(tableName);){
                Mutation m = new Mutation((CharSequence)"1234");
                m.putDelete((CharSequence)"f1", (CharSequence)"q1", 2L);
                writer.addMutation(m);
            }
            try (Scanner scanner = c.createScanner(tableName, Authorizations.EMPTY);){
                Assertions.assertThrows(RuntimeException.class, () -> scanner.forEach(e -> {}), (String)"Expected scan to fail because  deletes are present.");
            }
        }
    }
}

