/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import org.apache.accumulo.cluster.AccumuloCluster;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.TestRandomDeletes;
import org.apache.accumulo.test.VerifyIngest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DeleteIT
extends AccumuloClusterHarness {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(2L);
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(DeleteIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            DeleteIT.deleteTest(c, DeleteIT.getCluster(), tableName);
        }
    }

    public static void deleteTest(AccumuloClient c, AccumuloCluster cluster, String tableName) throws Exception {
        VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(DeleteIT.getClientProps(), tableName, 1000);
        params.cols = 1;
        params.random = 56;
        TestIngest.ingest(c, params);
        Assertions.assertEquals((int)0, (int)cluster.getClusterControl().exec(TestRandomDeletes.class, new String[]{"-c", cluster.getClientPropsPath(), "--table", tableName}));
        TestIngest.ingest(c, params);
        VerifyIngest.verifyIngest(c, params);
    }
}

