/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.EnumSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.test.functional.SlowIterator;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class DeletedTablesDontFlushIT
extends SharedMiniClusterBase {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    @BeforeAll
    public static void setup() throws Exception {
        SharedMiniClusterBase.startMiniCluster();
    }

    @AfterAll
    public static void teardown() {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(DeletedTablesDontFlushIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            IteratorSetting setting = new IteratorSetting(100, SlowIterator.class);
            SlowIterator.setSleepTime(setting, 1000L);
            c.tableOperations().attachIterator(tableName, setting, EnumSet.of(IteratorUtil.IteratorScope.minc));
            UtilWaitThread.sleep((long)1000L);
            Mutation m = new Mutation((CharSequence)"xyzzy");
            for (int i = 0; i < 100; ++i) {
                m.put((CharSequence)"cf", (CharSequence)("" + i), new Value());
            }
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                bw.addMutation(m);
            }
            c.tableOperations().delete(tableName);
        }
    }
}

