/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterators;
import java.time.Duration;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.miniclusterImpl.ProcessReference;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="MiniClusterOnly")
public class DurabilityIT
extends ConfigurableMacBase {
    static final long N = 100000L;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(4L);
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setNumTservers(1);
    }

    private String[] init(AccumuloClient c) throws Exception {
        String[] tableNames = this.getUniqueNames(4);
        TableOperations tableOps = c.tableOperations();
        this.createTable(c, tableNames[0]);
        this.createTable(c, tableNames[1]);
        this.createTable(c, tableNames[2]);
        this.createTable(c, tableNames[3]);
        tableOps.setProperty(tableNames[1], Property.TABLE_DURABILITY.getKey(), "flush");
        tableOps.setProperty(tableNames[2], Property.TABLE_DURABILITY.getKey(), "log");
        tableOps.setProperty(tableNames[3], Property.TABLE_DURABILITY.getKey(), "none");
        return tableNames;
    }

    private void cleanup(AccumuloClient c, String[] tableNames) throws Exception {
        for (String tableName : tableNames) {
            c.tableOperations().delete(tableName);
        }
    }

    private void createTable(AccumuloClient c, String tableName) throws Exception {
        c.tableOperations().create(tableName);
    }

    @Test
    public void testSync() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String[] tableNames = this.init(client);
            this.writeSome(client, tableNames[0], 100000L);
            this.restartTServer();
            Assertions.assertEquals((long)100000L, (long)this.readSome(client, tableNames[0]));
            this.cleanup(client, tableNames);
        }
    }

    @Test
    public void testFlush() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String[] tableNames = this.init(client);
            this.writeSome(client, tableNames[1], 100000L);
            this.restartTServer();
            Assertions.assertEquals((long)100000L, (long)this.readSome(client, tableNames[1]));
            this.cleanup(client, tableNames);
        }
    }

    @Test
    public void testLog() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String[] tableNames = this.init(client);
            this.writeSome(client, tableNames[2], 100000L);
            this.restartTServer();
            long numResults = this.readSome(client, tableNames[2]);
            Assertions.assertTrue((numResults <= 100000L ? 1 : 0) != 0, (String)("Expected 100000 >= " + numResults));
            this.cleanup(client, tableNames);
        }
    }

    @Test
    public void testNone() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String[] tableNames = this.init(client);
            this.writeSome(client, tableNames[3], 100000L);
            this.restartTServer();
            long numResults = this.readSome(client, tableNames[3]);
            Assertions.assertTrue((numResults <= 100000L ? 1 : 0) != 0, (String)("Expected 100000 >= " + numResults));
            this.cleanup(client, tableNames);
        }
    }

    @Test
    public void testIncreaseDurability() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            c.tableOperations().setProperty(tableName, Property.TABLE_DURABILITY.getKey(), "none");
            this.writeSome(c, tableName, 100000L);
            this.restartTServer();
            long numResults = this.readSome(c, tableName);
            Assertions.assertTrue((numResults <= 100000L ? 1 : 0) != 0, (String)("Expected 100000 >= " + numResults));
            c.tableOperations().setProperty(tableName, Property.TABLE_DURABILITY.getKey(), "sync");
            this.writeSome(c, tableName, 100000L);
            this.restartTServer();
            Assertions.assertEquals((long)100000L, (long)this.readSome(c, tableName));
        }
    }

    @Test
    public void testMetaDurability() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.instanceOperations().setProperty(Property.TABLE_DURABILITY.getKey(), "none");
            Map props = c.tableOperations().getConfiguration(MetadataTable.NAME);
            Assertions.assertEquals((Object)"sync", props.get(Property.TABLE_DURABILITY.getKey()));
            c.tableOperations().create(tableName);
            props = c.tableOperations().getConfiguration(tableName);
            Assertions.assertEquals((Object)"none", props.get(Property.TABLE_DURABILITY.getKey()));
            this.restartTServer();
            Assertions.assertTrue((boolean)c.tableOperations().exists(tableName));
        }
    }

    private long readSome(AccumuloClient client, String table) throws Exception {
        return Iterators.size((Iterator)client.createScanner(table, Authorizations.EMPTY).iterator());
    }

    private void restartTServer() throws Exception {
        for (ProcessReference proc : (Collection)this.cluster.getProcesses().get(ServerType.TABLET_SERVER)) {
            this.cluster.killProcess(ServerType.TABLET_SERVER, proc);
        }
        this.cluster.start();
    }

    private void writeSome(AccumuloClient c, String table, long count) throws Exception {
        try (BatchWriter bw = c.createBatchWriter(table);){
            int i = 1;
            while ((long)i < count + 1L) {
                Mutation m = new Mutation((CharSequence)("" + i));
                m.put((CharSequence)"", (CharSequence)"", (CharSequence)"");
                bw.addMutation(m);
                if ((long)i % Math.max(1L, count / 100L) == 0L) {
                    bw.flush();
                }
                ++i;
            }
        }
    }
}

