/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;

public class ErrorThrowingIterator
extends WrappingIterator {
    public static final String TIMES = "error.throwing.iterator.times";
    private static final String MESSAGE = "Exception thrown from ErrorThrowingIterator";
    private static final RuntimeException ERROR = new RuntimeException("Exception thrown from ErrorThrowingIterator");
    private static final AtomicInteger TIMES_THROWN = new AtomicInteger(0);
    private int threshold = 0;

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        this.threshold = Integer.parseInt(options.get(TIMES));
        Preconditions.checkState((TIMES_THROWN.get() <= this.threshold ? 1 : 0) != 0, (Object)"This iterator does not support reuse within the same VM. If using in an IT, then be sure to use a different MAC instance between tests.");
    }

    private void incrementAndThrow(RuntimeException t) {
        if (TIMES_THROWN.get() < this.threshold) {
            TIMES_THROWN.incrementAndGet();
            throw t;
        }
    }

    private void incrementAndThrowIOE() throws IOException {
        if (TIMES_THROWN.get() < this.threshold) {
            TIMES_THROWN.incrementAndGet();
            throw new IOException(MESSAGE);
        }
    }

    public Key getTopKey() {
        this.incrementAndThrow(ERROR);
        return super.getTopKey();
    }

    public Value getTopValue() {
        this.incrementAndThrow(ERROR);
        return super.getTopValue();
    }

    public boolean hasTop() {
        this.incrementAndThrow(ERROR);
        return super.hasTop();
    }

    public void next() throws IOException {
        this.incrementAndThrowIOE();
        super.next();
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.incrementAndThrowIOE();
        super.seek(range, columnFamilies, inclusive);
    }
}

