/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.ArrayList;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Test;

public class FateStarvationIT
extends AccumuloClusterHarness {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(2L);
    }

    @Test
    public void run() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(FateStarvationIT.getClientProps()).build();){
            NewTableConfiguration ntc = new NewTableConfiguration().withSplits(TestIngest.getSplitPoints(0L, 100000L, 50L));
            c.tableOperations().create(tableName, ntc);
            TestIngest.IngestParams params = new TestIngest.IngestParams(FateStarvationIT.getClientProps(), tableName, 100000);
            params.random = 89;
            params.timestamp = 7L;
            params.dataSize = 50;
            params.cols = 1;
            TestIngest.ingest(c, params);
            c.tableOperations().flush(tableName, null, null, true);
            ArrayList<Text> splits = new ArrayList<Text>(TestIngest.getSplitPoints(0L, 100000L, 67L));
            for (int i = 0; i < 100; ++i) {
                int idx1 = random.nextInt(splits.size() - 1);
                int idx2 = random.nextInt(splits.size() - (idx1 + 1)) + idx1 + 1;
                c.tableOperations().compact(tableName, (Text)splits.get(idx1), (Text)splits.get(idx2), false, false);
            }
            c.tableOperations().offline(tableName);
            FunctionalTestUtils.assertNoDanglingFateLocks(FateStarvationIT.getCluster());
        }
    }
}

