/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileNormalizationIT
extends SharedMiniClusterBase {
    private static final Logger log = LoggerFactory.getLogger(FileNormalizationIT.class);

    @BeforeAll
    public static void setup() throws Exception {
        SharedMiniClusterBase.startMiniCluster();
    }

    @AfterAll
    public static void teardown() {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @Test
    public void testSplits() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(FileNormalizationIT.getClientProps()).build();){
            String table = this.getUniqueNames(1)[0];
            client.tableOperations().create(table);
            VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(FileNormalizationIT.getClientProps(), table, 100000);
            TestIngest.ingest(client, params);
            client.tableOperations().flush(table, null, null, true);
            this.misnormalizeFiles(client, table);
            TreeSet<Text> splits = TestIngest.getSplitPoints(params.startRow, params.startRow + params.rows, 2L);
            Assertions.assertEquals((int)1, (int)splits.size());
            client.tableOperations().addSplits(table, splits);
            HashSet paths = new HashSet();
            VerifyIngest.verifyIngest(client, params);
            try (Scanner scanner = this.createMetadataFileScanner(client, table);){
                scanner.forEach((k, v) -> {
                    String row = k.getRowData().toString();
                    String qual = k.getColumnQualifierData().toString();
                    String path = new Path(qual).toString();
                    String rowPath = row + "+" + path;
                    log.debug("split test, inspecting {} {} {}", new Object[]{row, qual, v});
                    Assertions.assertFalse((boolean)paths.contains(rowPath), (String)("Tablet " + row + " has duplicate normalized path " + path));
                    paths.add(rowPath);
                });
            }
            VerifyIngest.verifyIngest(client, params);
        }
    }

    @Test
    public void testCompaction() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(FileNormalizationIT.getClientProps()).build();){
            String table = this.getUniqueNames(1)[0];
            client.tableOperations().create(table);
            VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(FileNormalizationIT.getClientProps(), table, 100000);
            TestIngest.ingest(client, params);
            client.tableOperations().flush(table, null, null, true);
            this.misnormalizeFiles(client, table);
            client.tableOperations().compact(table, new CompactionConfig().setWait(true));
            try (Scanner scanner = this.createMetadataFileScanner(client, table);){
                HashSet filenames = new HashSet();
                scanner.forEach((k, v) -> {
                    Path path = new Path(k.getColumnQualifierData().toString());
                    Assertions.assertFalse((boolean)filenames.contains(path.getName()));
                    Assertions.assertTrue((boolean)path.getName().startsWith("A"));
                    filenames.add(path.getName());
                });
                Assertions.assertEquals((int)1, (int)filenames.size());
                VerifyIngest.verifyIngest(client, params);
            }
        }
    }

    @Test
    public void testMerge() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(FileNormalizationIT.getClientProps()).build();){
            String table = this.getUniqueNames(1)[0];
            Map<String, String> props = Map.of(Property.TABLE_MAJC_RATIO.getKey(), "10");
            client.tableOperations().create(table, new NewTableConfiguration().setProperties(props));
            VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(FileNormalizationIT.getClientProps(), table, 100000);
            TestIngest.ingest(client, params);
            client.tableOperations().flush(table, null, null, true);
            TreeSet<Text> splits = TestIngest.getSplitPoints(params.startRow, params.startRow + params.rows, 4L);
            Assertions.assertEquals((int)3, (int)splits.size());
            client.tableOperations().addSplits(table, splits);
            client.tableOperations().compact(table, new CompactionConfig().setWait(true));
            this.misnormalizeFiles(client, table);
            HashSet filesBeforeMerge = new HashSet();
            try (Scanner scanner = this.createMetadataFileScanner(client, table);){
                scanner.forEach((k, v) -> {
                    String qual = k.getColumnQualifierData().toString();
                    Assertions.assertTrue((boolean)qual.contains("//tables//"));
                    filesBeforeMerge.add(qual);
                });
            }
            Assertions.assertEquals((int)4, (int)filesBeforeMerge.size());
            client.tableOperations().merge(table, null, null);
            HashSet filesAfterMerge = new HashSet();
            try (Scanner scanner = this.createMetadataFileScanner(client, table);){
                scanner.forEach((k, v) -> {
                    Assertions.assertTrue((boolean)k.getRow().toString().endsWith("<"));
                    filesAfterMerge.add(k.getColumnQualifierData().toString());
                });
            }
            Assertions.assertEquals((int)0, (int)client.tableOperations().listSplits(table).size());
            Assertions.assertEquals(filesBeforeMerge, filesAfterMerge);
            VerifyIngest.verifyIngest(client, params);
        }
    }

    private Scanner createMetadataFileScanner(AccumuloClient client, String table) throws Exception {
        Scanner scanner = client.createScanner(MetadataTable.NAME);
        TableId tableId = TableId.of((String)((String)client.tableOperations().tableIdMap().get(table)));
        Range range = new KeyExtent(tableId, null, null).toMetaRange();
        scanner.setRange(range);
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
        return scanner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void misnormalizeFiles(AccumuloClient client, String table) throws Exception {
        client.tableOperations().offline(table, true);
        client.securityOperations().grantTablePermission(FileNormalizationIT.getPrincipal(), MetadataTable.NAME, TablePermission.WRITE);
        try (Scanner scanner = this.createMetadataFileScanner(client, table);
             BatchWriter writer = client.createBatchWriter(MetadataTable.NAME);){
            scanner.forEach((k, v) -> {
                Mutation m = new Mutation(k.getRow());
                String qual = k.getColumnQualifierData().toString();
                Assertions.assertTrue((boolean)qual.contains("/tables/"));
                Text newQual = new Text(qual.replace("/tables/", "//tables//"));
                m.put(k.getColumnFamily(), newQual, v);
                m.putDelete(k.getColumnFamily(), k.getColumnQualifier());
                try {
                    writer.addMutation(m);
                }
                catch (MutationsRejectedException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        finally {
            client.securityOperations().revokeTablePermission(FileNormalizationIT.getPrincipal(), MetadataTable.NAME, TablePermission.WRITE);
            client.tableOperations().online(table, true);
        }
    }
}

