/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FlushNoFileIT
extends AccumuloClusterHarness {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(FlushNoFileIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            IteratorSetting iteratorSetting = new IteratorSetting(20, NullIterator.class);
            ntc.attachIterator(iteratorSetting, EnumSet.of(IteratorUtil.IteratorScope.minc));
            ntc.withSplits(new TreeSet<Text>(Set.of(new Text("a"), new Text("s"))));
            c.tableOperations().create(tableName, ntc);
            TableId tableId = TableId.of((String)((String)c.tableOperations().tableIdMap().get(tableName)));
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                Mutation m = new Mutation(new Text("r1"));
                m.put((CharSequence)"acf", (CharSequence)tableName, (CharSequence)"1");
                bw.addMutation(m);
            }
            FunctionalTestUtils.checkRFiles(c, tableName, 3, 3, 0, 0);
            c.tableOperations().flush(tableName, null, null, true);
            FunctionalTestUtils.checkRFiles(c, tableName, 3, 3, 0, 0);
            long flushId = FunctionalTestUtils.checkFlushId((ClientContext)c, tableId, 0L);
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                Mutation m = new Mutation(new Text("r2"));
                m.put((CharSequence)"acf", (CharSequence)tableName, (CharSequence)"1");
                bw.addMutation(m);
            }
            c.tableOperations().flush(tableName, null, null, true);
            FunctionalTestUtils.checkRFiles(c, tableName, 3, 3, 0, 0);
            long secondFlushId = FunctionalTestUtils.checkFlushId((ClientContext)c, tableId, flushId);
            Assertions.assertTrue((secondFlushId > flushId ? 1 : 0) != 0, (String)"Flush ID did not change");
            try (Scanner scanner = c.createScanner(tableName);){
                Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)scanner), (String)"Expected 0 Entries in table");
            }
        }
    }

    public static class NullIterator
    implements SortedKeyValueIterator<Key, Value> {
        public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) {
        }

        public boolean hasTop() {
            return false;
        }

        public void next() throws IOException {
        }

        public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) {
        }

        public Key getTopKey() {
            return null;
        }

        public Value getTopValue() {
            return null;
        }

        public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
            return null;
        }
    }
}

