/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.cluster.AccumuloCluster;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.fate.AdminUtil;
import org.apache.accumulo.core.fate.ReadOnlyTStore;
import org.apache.accumulo.core.fate.ZooStore;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ZooReader;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.test.TestIngest;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.zookeeper.KeeperException;
import org.junit.jupiter.api.Assertions;

public class FunctionalTestUtils {
    public static int countRFiles(AccumuloClient c, String tableName) throws Exception {
        try (Scanner scanner = c.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
            TableId tableId = TableId.of((String)((String)c.tableOperations().tableIdMap().get(tableName)));
            scanner.setRange(MetadataSchema.TabletsSection.getRange((TableId)tableId));
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            int n = Iterators.size((Iterator)scanner.iterator());
            return n;
        }
    }

    public static List<String> getRFilePaths(AccumuloClient c, String tableName) throws Exception {
        ArrayList<String> files = new ArrayList<String>();
        try (Scanner scanner = c.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
            TableId tableId = TableId.of((String)((String)c.tableOperations().tableIdMap().get(tableName)));
            scanner.setRange(MetadataSchema.TabletsSection.getRange((TableId)tableId));
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            scanner.forEach(entry -> files.add(((Key)entry.getKey()).getColumnQualifier().toString()));
        }
        return files;
    }

    static void checkRFiles(AccumuloClient c, String tableName, int minTablets, int maxTablets, int minRFiles, int maxRFiles) throws Exception {
        try (Scanner scanner = c.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
            String tableId = (String)c.tableOperations().tableIdMap().get(tableName);
            scanner.setRange(new Range(new Text(tableId + ";"), true, new Text(tableId + "<"), true));
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch((ScannerBase)scanner);
            HashMap<Text, Integer> tabletFileCounts = new HashMap<Text, Integer>();
            for (Map.Entry entry : scanner) {
                Text row = ((Key)entry.getKey()).getRow();
                Integer count = (Integer)tabletFileCounts.get(row);
                if (count == null) {
                    count = 0;
                }
                if (((Key)entry.getKey()).getColumnFamily().equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) {
                    count = count + 1;
                }
                tabletFileCounts.put(row, count);
            }
            if (tabletFileCounts.size() < minTablets || tabletFileCounts.size() > maxTablets) {
                throw new Exception("Did not find expected number of tablets " + tabletFileCounts.size());
            }
            Set es = tabletFileCounts.entrySet();
            for (Map.Entry entry : es) {
                if ((Integer)entry.getValue() <= maxRFiles && (Integer)entry.getValue() >= minRFiles) continue;
                throw new Exception("tablet " + entry.getKey() + " has " + entry.getValue() + " map files");
            }
        }
    }

    public static void checkSplits(AccumuloClient c, String table, int min, int max) throws Exception {
        Collection splits = c.tableOperations().listSplits(table);
        if (splits.size() < min || splits.size() > max) {
            throw new Exception("# of table splits points out of range, #splits=" + splits.size() + " table=" + table + " min=" + min + " max=" + max);
        }
    }

    public static void createRFiles(AccumuloClient c, FileSystem fs, String path, int rows, int splits, int threads) throws Exception {
        fs.delete(new Path(path), true);
        ExecutorService threadPool = Executors.newFixedThreadPool(threads);
        AtomicBoolean fail = new AtomicBoolean(false);
        for (int i = 0; i < rows; i += rows / splits) {
            TestIngest.IngestParams params = new TestIngest.IngestParams(c.properties());
            params.outputFile = String.format("%s/mf%s", path, i);
            params.random = 56;
            params.timestamp = 1L;
            params.dataSize = 50;
            params.rows = rows / splits;
            params.startRow = i;
            params.cols = 1;
            threadPool.execute(() -> {
                try {
                    TestIngest.ingest(c, fs, params);
                }
                catch (Exception e) {
                    fail.set(true);
                }
            });
        }
        threadPool.shutdown();
        threadPool.awaitTermination(1L, TimeUnit.HOURS);
        Assertions.assertFalse((boolean)fail.get());
    }

    public static HttpResponse<String> readWebPage(URL url) throws IOException, InterruptedException, URISyntaxException {
        return HttpClient.newHttpClient().send(HttpRequest.newBuilder(url.toURI()).build(), HttpResponse.BodyHandlers.ofString());
    }

    public static String readAll(InputStream is) throws IOException {
        return IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
    }

    static Mutation nm(String row, String cf, String cq, Value value) {
        Mutation m = new Mutation(new Text(row));
        m.put(new Text(cf), new Text(cq), value);
        return m;
    }

    static Mutation nm(String row, String cf, String cq, String value) {
        return FunctionalTestUtils.nm(row, cf, cq, new Value((CharSequence)value));
    }

    public static SortedSet<Text> splits(String[] splits) {
        TreeSet<Text> result = new TreeSet<Text>();
        for (String split : splits) {
            result.add(new Text(split));
        }
        return result;
    }

    public static void assertNoDanglingFateLocks(AccumuloCluster cluster) {
        AdminUtil.FateStatus fateStatus = FunctionalTestUtils.getFateStatus(cluster);
        Assertions.assertEquals((int)0, (int)fateStatus.getDanglingHeldLocks().size(), (String)("Dangling FATE locks : " + fateStatus.getDanglingHeldLocks()));
        Assertions.assertEquals((int)0, (int)fateStatus.getDanglingWaitingLocks().size(), (String)("Dangling FATE locks : " + fateStatus.getDanglingWaitingLocks()));
    }

    private static AdminUtil.FateStatus getFateStatus(AccumuloCluster cluster) {
        try {
            AdminUtil admin = new AdminUtil(false);
            ServerContext context = cluster.getServerContext();
            ZooReaderWriter zk = context.getZooReaderWriter();
            ZooStore zs = new ZooStore(context.getZooKeeperRoot() + "/fate", zk);
            ServiceLock.ServiceLockPath lockPath = ServiceLock.path((String)(context.getZooKeeperRoot() + "/table_locks"));
            return admin.getStatus((ReadOnlyTStore)zs, (ZooReader)zk, lockPath, null, null);
        }
        catch (InterruptedException | KeeperException e) {
            throw new RuntimeException(e);
        }
    }

    static long checkFlushId(ClientContext c, TableId tableId, long prevFlushID) throws Exception {
        try (TabletsMetadata metaScan = c.getAmple().readTablets().forTable(tableId).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.FLUSH_ID}).checkConsistency().build();){
            long flushId = 0L;
            long prevTabletFlushId = 0L;
            for (TabletMetadata tabletMetadata : metaScan) {
                OptionalLong optFlushId = tabletMetadata.getFlushId();
                if (optFlushId.isPresent()) {
                    flushId = optFlushId.getAsLong();
                    if (prevTabletFlushId > 0L && prevTabletFlushId != flushId) {
                        throw new Exception("Flush ID different between tablets");
                    }
                    prevTabletFlushId = flushId;
                    continue;
                }
                throw new Exception("Missing flush ID");
            }
            if (prevFlushID >= flushId) {
                throw new Exception("Flush ID did not increase. prevFlushID: " + prevFlushID + " current: " + flushId);
            }
            long l = flushId;
            return l;
        }
    }
}

