/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterators;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.gc.GcCandidate;
import org.apache.accumulo.core.gc.ReferenceFile;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.util.ServerServices;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.gc.SimpleGarbageCollector;
import org.apache.accumulo.minicluster.MemoryUnit;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.miniclusterImpl.ProcessNotFoundException;
import org.apache.accumulo.miniclusterImpl.ProcessReference;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.apache.zookeeper.KeeperException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GarbageCollectorIT
extends ConfigurableMacBase {
    private static final String OUR_SECRET = "itsreallysecret";
    public static final Logger log = LoggerFactory.getLogger(GarbageCollectorIT.class);

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(5L);
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setProperty(Property.INSTANCE_SECRET, OUR_SECRET);
        cfg.setProperty(Property.GC_CYCLE_START, "1");
        cfg.setProperty(Property.GC_CYCLE_DELAY, "1");
        cfg.setProperty(Property.GC_PORT, "0");
        cfg.setProperty(Property.TSERV_MAXMEM, "5K");
        cfg.setProperty(Property.TSERV_MAJC_DELAY, "1");
        cfg.setProperty(Property.GC_CANDIDATE_BATCH_SIZE, "256K");
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    private void killMacGc() throws ProcessNotFoundException, InterruptedException, KeeperException {
        this.getCluster().killProcess(ServerType.GARBAGE_COLLECTOR, (ProcessReference)((Collection)this.getCluster().getProcesses().get(ServerType.GARBAGE_COLLECTOR)).iterator().next());
        ServiceLock.ServiceLockPath path = ServiceLock.path((String)(this.getServerContext().getZooKeeperRoot() + "/gc/lock"));
        ZooReaderWriter zk = this.getServerContext().getZooReaderWriter();
        try {
            ServiceLock.deleteLock((ZooReaderWriter)zk, (ServiceLock.ServiceLockPath)path);
        }
        catch (IllegalStateException e) {
            log.error("Unable to delete ZooLock for mini accumulo-gc", (Throwable)e);
        }
        Assertions.assertNull(this.getCluster().getProcesses().get(ServerType.GARBAGE_COLLECTOR));
    }

    @Test
    public void gcTest() throws Exception {
        this.killMacGc();
        String table = "test_ingest";
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            c.tableOperations().create("test_ingest");
            c.tableOperations().setProperty("test_ingest", Property.TABLE_SPLIT_THRESHOLD.getKey(), "5K");
            VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(this.getClientProperties(), "test_ingest", 10000);
            params.cols = 1;
            log.info("Ingesting files to {}", (Object)"test_ingest");
            TestIngest.ingest(c, this.cluster.getFileSystem(), params);
            log.info("Compacting the table {}", (Object)"test_ingest");
            c.tableOperations().compact("test_ingest", null, null, true, true);
            String pathString = this.cluster.getConfig().getDir() + "/accumulo/tables/1/*/*.rf";
            log.info("Counting files in path: {}", (Object)pathString);
            int before = this.countFiles(pathString);
            log.info("Counted {} files in path: {}", (Object)before, (Object)pathString);
            while (true) {
                UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                int more = this.countFiles(pathString);
                if (more <= before) break;
                before = more;
            }
            log.info("Restarting GC...");
            this.getCluster().start();
            UtilWaitThread.sleepUninterruptibly((long)15L, (TimeUnit)TimeUnit.SECONDS);
            log.info("Again Counting files in path: {}", (Object)pathString);
            int after = this.countFiles(pathString);
            log.info("Counted {} files in path: {}", (Object)after, (Object)pathString);
            VerifyIngest.verifyIngest(c, params);
            Assertions.assertTrue((after < before ? 1 : 0) != 0, (String)("After count " + after + " was not less than " + before));
        }
    }

    @Test
    public void gcLotsOfCandidatesIT() throws Exception {
        this.killMacGc();
        log.info("Filling metadata table with bogus delete flags");
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            this.addEntries(c);
            this.cluster.getConfig().setDefaultMemory(32L, MemoryUnit.MEGABYTE);
            MiniAccumuloClusterImpl.ProcessInfo gc = this.cluster.exec(SimpleGarbageCollector.class, new String[0]);
            UtilWaitThread.sleepUninterruptibly((long)20L, (TimeUnit)TimeUnit.SECONDS);
            String output = "";
            while (!output.contains("has exceeded the threshold")) {
                try {
                    output = gc.readStdOut();
                }
                catch (UncheckedIOException ex) {
                    log.error("IO error reading the IT's accumulo-gc STDOUT", (Throwable)ex);
                    break;
                }
            }
            gc.getProcess().destroy();
            Assertions.assertTrue((boolean)output.contains("has exceeded the threshold"));
        }
    }

    @Test
    public void dontGCRootLog() throws Exception {
        this.killMacGc();
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String table = this.getUniqueNames(1)[0];
            c.tableOperations().create(table);
            this.cluster.start();
            UtilWaitThread.sleepUninterruptibly((long)20L, (TimeUnit)TimeUnit.SECONDS);
            this.killMacGc();
            for (ProcessReference ref : (Collection)this.cluster.getProcesses().get(ServerType.TABLET_SERVER)) {
                this.cluster.killProcess(ServerType.TABLET_SERVER, ref);
            }
            this.cluster.start();
            try (Scanner scanner = c.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                scanner.forEach((k, v) -> {});
            }
        }
    }

    private Mutation createDelMutation(String path, String cf, String cq, String val) {
        Text row = new Text(MetadataSchema.DeletesSection.encodeRow((String)path));
        Mutation delFlag = new Mutation(row);
        delFlag.put((CharSequence)cf, (CharSequence)cq, (CharSequence)val);
        return delFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidDelete() throws Exception {
        this.killMacGc();
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String table = this.getUniqueNames(1)[0];
            c.tableOperations().create(table);
            try (BatchWriter bw = c.createBatchWriter(table);){
                Mutation m1 = new Mutation((CharSequence)"r1");
                m1.put((CharSequence)"cf1", (CharSequence)"cq1", (CharSequence)"v1");
                bw.addMutation(m1);
            }
            c.tableOperations().flush(table, null, null, true);
            c.securityOperations().grantTablePermission(c.whoami(), MetadataTable.NAME, TablePermission.WRITE);
            bw = c.createBatchWriter(MetadataTable.NAME);
            try {
                bw.addMutation(this.createDelMutation("", "", "", ""));
                bw.addMutation(this.createDelMutation("", "testDel", "test", "valueTest"));
                bw.addMutation(this.createDelMutation("/", "", "", "skewed"));
            }
            finally {
                if (bw != null) {
                    bw.close();
                }
            }
            MiniAccumuloClusterImpl.ProcessInfo gc = this.cluster.exec(SimpleGarbageCollector.class, new String[0]);
            try {
                String output = "";
                while (!output.contains("Ignoring invalid deletion candidate")) {
                    UtilWaitThread.sleepUninterruptibly((long)250L, (TimeUnit)TimeUnit.MILLISECONDS);
                    try {
                        output = gc.readStdOut();
                    }
                    catch (UncheckedIOException ioe) {
                        log.error("Could not read all from cluster.", (Throwable)ioe);
                    }
                }
            }
            finally {
                gc.getProcess().destroy();
            }
            try (Scanner scanner = c.createScanner(table, Authorizations.EMPTY);){
                Map.Entry<Key, Value> entry = this.getOnlyElement(scanner);
                Assertions.assertEquals((Object)"r1", (Object)entry.getKey().getRow().toString());
                Assertions.assertEquals((Object)"cf1", (Object)entry.getKey().getColumnFamily().toString());
                Assertions.assertEquals((Object)"cq1", (Object)entry.getKey().getColumnQualifier().toString());
                Assertions.assertEquals((Object)"v1", (Object)entry.getValue().toString());
            }
        }
    }

    @Test
    public void testUserUniqueMutationDelete() throws Exception {
        this.killMacGc();
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String table = this.getUniqueNames(1)[0];
            c.tableOperations().create(table);
            log.info("User GcCandidate Deletion test of table: {}", (Object)table);
            log.info("GcCandidates will be added/removed from table: {}", (Object)Ample.DataLevel.USER.metaTable());
            this.createAndDeleteUniqueMutation(TableId.of((String)table), Ample.GcCandidateType.INUSE);
            this.createAndDeleteUniqueMutation(TableId.of((String)table), Ample.GcCandidateType.VALID);
        }
    }

    @Test
    public void testMetadataUniqueMutationDelete() throws Exception {
        this.killMacGc();
        TableId tableId = Ample.DataLevel.USER.metaTableId();
        log.info("Metadata GcCandidate Deletion test");
        log.info("GcCandidates will be added/removed from table: {}", (Object)Ample.DataLevel.METADATA.metaTable());
        this.createAndDeleteUniqueMutation(tableId, Ample.GcCandidateType.INUSE);
        this.createAndDeleteUniqueMutation(tableId, Ample.GcCandidateType.VALID);
    }

    @Test
    public void testRootUniqueMutationDelete() throws Exception {
        GcCandidate gcC;
        GcCandidate cTemp;
        this.killMacGc();
        TableId tableId = Ample.DataLevel.METADATA.metaTableId();
        log.info("Root GcCandidate Deletion test");
        log.info("GcCandidates will be added but not removed from Zookeeper");
        Ample ample = this.cluster.getServerContext().getAmple();
        Ample.DataLevel datalevel = Ample.DataLevel.ROOT;
        Iterator cIter = ample.getGcCandidates(datalevel);
        ArrayList<GcCandidate> tempCandidates = new ArrayList<GcCandidate>();
        while (cIter.hasNext()) {
            cTemp = (GcCandidate)cIter.next();
            tempCandidates.add(cTemp);
        }
        if (tempCandidates.size() != 0) {
            ample.deleteGcCandidates(datalevel, tempCandidates, Ample.GcCandidateType.VALID);
            tempCandidates.clear();
            cIter = ample.getGcCandidates(datalevel);
            while (cIter.hasNext()) {
                cTemp = (GcCandidate)cIter.next();
                log.debug("PreExisting Candidate Found: {}", (Object)cTemp);
                tempCandidates.add(cTemp);
            }
            Assertions.assertEquals((int)0, (int)tempCandidates.size());
        }
        List<GcCandidate> candidates = List.of(new GcCandidate("hdfs://foo.com:6000/user/foo/tables/+r/t-0/F00.rf", 0L), new GcCandidate("hdfs://foo.com:6000/user/foo/tables/+r/t-0/F001.rf", 1L));
        LinkedList stfs = new LinkedList();
        candidates.stream().forEach(temp -> stfs.add(new StoredTabletFile(temp.getPath())));
        log.debug("Adding root table GcCandidates");
        ample.putGcCandidates(tableId, stfs);
        cIter = ample.getGcCandidates(datalevel);
        int counter = 0;
        while (cIter.hasNext()) {
            ample.putGcCandidates(tableId, List.of(new StoredTabletFile(((GcCandidate)cIter.next()).getPath())));
            ++counter;
        }
        Assertions.assertEquals((int)2, (int)counter);
        cIter = ample.getGcCandidates(datalevel);
        while (cIter.hasNext()) {
            ample.deleteGcCandidates(datalevel, List.of((GcCandidate)cIter.next()), Ample.GcCandidateType.INUSE);
        }
        cIter = ample.getGcCandidates(datalevel);
        counter = candidates.size();
        while (cIter.hasNext()) {
            gcC = (GcCandidate)cIter.next();
            log.debug("Candidate Found: {}", (Object)gcC);
            for (GcCandidate cand : candidates) {
                if (!gcC.getPath().equals(cand.getPath())) continue;
                Assertions.assertNotEquals((long)gcC.getUid(), (long)cand.getUid());
                --counter;
            }
        }
        Assertions.assertEquals((int)0, (int)counter);
        cIter = ample.getGcCandidates(datalevel);
        while (cIter.hasNext()) {
            ample.deleteGcCandidates(datalevel, List.of((GcCandidate)cIter.next()), Ample.GcCandidateType.VALID);
        }
        cIter = ample.getGcCandidates(datalevel);
        counter = 0;
        while (cIter.hasNext()) {
            gcC = (GcCandidate)cIter.next();
            if (gcC == null) continue;
            log.error("Candidate Found: {}", (Object)gcC);
            ++counter;
        }
        Assertions.assertEquals((int)0, (int)counter);
    }

    @Test
    public void testProperPortAdvertisement() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            ZooReaderWriter zk = this.cluster.getServerContext().getZooReaderWriter();
            ServiceLock.ServiceLockPath path = ServiceLock.path((String)(ZooUtil.getRoot((InstanceId)client.instanceOperations().getInstanceId()) + "/gc/lock"));
            for (int i = 0; i < 5; ++i) {
                List locks;
                try {
                    locks = ServiceLock.validateAndSort((ServiceLock.ServiceLockPath)path, (List)zk.getChildren(path.toString()));
                }
                catch (KeeperException.NoNodeException e) {
                    Thread.sleep(5000L);
                    continue;
                }
                if (locks != null && !locks.isEmpty()) {
                    String lockPath = path + "/" + (String)locks.get(0);
                    String gcLoc = new String(zk.getData(lockPath));
                    Assertions.assertTrue((boolean)gcLoc.startsWith(ServerServices.Service.GC_CLIENT.name()), (String)("Found unexpected data in zookeeper for GC location: " + gcLoc));
                    int loc = gcLoc.indexOf("=");
                    Assertions.assertNotEquals((int)-1, (int)loc, (String)("Could not find split point of GC location for: " + gcLoc));
                    String addr = gcLoc.substring(loc + 1);
                    int addrSplit = addr.indexOf(58);
                    Assertions.assertNotEquals((int)-1, (int)addrSplit, (String)("Could not find split of GC host:port for: " + addr));
                    String host = addr.substring(0, addrSplit);
                    String port = addr.substring(addrSplit + 1);
                    Assertions.assertNotEquals((Object)"0.0.0.0", (Object)host);
                    Assertions.assertNotEquals((int)0, (int)Integer.parseInt(port));
                    return;
                }
                Thread.sleep(5000L);
            }
            Assertions.fail((String)"Could not find advertised GC address");
        }
    }

    private int countFiles(String pathStr) throws Exception {
        Path path = new Path(pathStr);
        return Iterators.size(Arrays.asList(this.cluster.getFileSystem().globStatus(path)).iterator());
    }

    private void addEntries(AccumuloClient client) throws Exception {
        Ample ample = this.getServerContext().getAmple();
        client.securityOperations().grantTablePermission(client.whoami(), MetadataTable.NAME, TablePermission.WRITE);
        try (BatchWriter bw = client.createBatchWriter(MetadataTable.NAME);){
            for (int i = 0; i < 100000; ++i) {
                String longpath = "aaaaaaaaaabbbbbbbbbbccccccccccddddddddddeeeeeeeeeeffffffffffgggggggggghhhhhhhhhhiiiiiiiiiijjjjjjjjjj";
                String path = String.format("file:/%020d/%s", i, longpath);
                Mutation delFlag = ample.createDeleteMutation(ReferenceFile.forFile((TableId)TableId.of((String)"1"), (String)path));
                bw.addMutation(delFlag);
            }
        }
    }

    private void createAndDeleteUniqueMutation(TableId tableId, Ample.GcCandidateType type) {
        int totalCandidates = 2;
        boolean inUseDelete = true;
        if (type == Ample.GcCandidateType.VALID) {
            totalCandidates = 1;
            inUseDelete = false;
        }
        Ample ample = this.cluster.getServerContext().getAmple();
        Ample.DataLevel datalevel = Ample.DataLevel.of((TableId)tableId);
        ArrayList<GcCandidate> candidates = new ArrayList<GcCandidate>();
        Iterator candidate = ample.getGcCandidates(datalevel);
        while (candidate.hasNext()) {
            GcCandidate cTemp = (GcCandidate)candidate.next();
            log.debug("PreExisting Candidate Found: {}", (Object)cTemp);
            candidates.add(cTemp);
        }
        Assertions.assertEquals((int)0, (int)candidates.size());
        List stfs = Stream.of(new StoredTabletFile("hdfs://foo.com:6000/user/foo/tables/a/t-0/F00.rf"), new StoredTabletFile("hdfs://foo.com:6000/user/foo/tables/b/t-0/F00.rf")).collect(Collectors.toList());
        log.debug("Adding candidates to table {}", (Object)tableId);
        ample.putGcCandidates(tableId, stfs);
        candidate = ample.getGcCandidates(datalevel);
        while (candidate.hasNext()) {
            GcCandidate cTemp = (GcCandidate)candidate.next();
            log.debug("Candidate Found: {}", (Object)cTemp);
            candidates.add(cTemp);
        }
        Assertions.assertEquals((int)2, (int)candidates.size());
        GcCandidate deleteCandidate = (GcCandidate)candidates.get(0);
        Assertions.assertNotNull((Object)deleteCandidate);
        ample.putGcCandidates(tableId, List.of(new StoredTabletFile(deleteCandidate.getPath())));
        log.debug("Deleting Candidate {}", (Object)deleteCandidate);
        ample.deleteGcCandidates(datalevel, List.of(deleteCandidate), type);
        candidate = ample.getGcCandidates(datalevel);
        int counter = 0;
        boolean foundNewCandidate = false;
        while (candidate.hasNext()) {
            GcCandidate gcC = (GcCandidate)candidate.next();
            log.debug("Candidate Found: {}", (Object)gcC);
            if (gcC.getPath().equals(deleteCandidate.getPath())) {
                Assertions.assertNotEquals((long)gcC.getUid(), (long)deleteCandidate.getUid());
                foundNewCandidate = true;
            }
            ++counter;
        }
        Assertions.assertEquals((int)totalCandidates, (int)counter);
        Assertions.assertEquals((Object)inUseDelete, (Object)foundNewCandidate);
        ample.deleteGcCandidates(datalevel, candidates, Ample.GcCandidateType.VALID);
    }
}

