/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.functional.ReadWriteIT;
import org.apache.accumulo.test.util.Wait;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GarbageCollectorTrashBase
extends ConfigurableMacBase {
    private static final Logger LOG = LoggerFactory.getLogger(GarbageCollectorTrashBase.class);

    protected ArrayList<StoredTabletFile> getFilesForTable(ServerContext ctx, AccumuloClient client, String tableName) {
        String tid = (String)client.tableOperations().tableIdMap().get(tableName);
        TabletsMetadata tms = ctx.getAmple().readTablets().forTable(TableId.of((String)tid)).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.FILES}).build();
        ArrayList<StoredTabletFile> files = new ArrayList<StoredTabletFile>();
        tms.forEach(tm -> files.addAll(tm.getFiles()));
        LOG.debug("Tablet files: {}", files);
        return files;
    }

    protected ArrayList<StoredTabletFile> loadData(ServerContext ctx, AccumuloClient client, String tableName) throws Exception {
        for (int i = 0; i < 5; ++i) {
            ReadWriteIT.ingest(client, 10, 10, 10, 0, tableName);
            client.tableOperations().flush(tableName, null, null, true);
        }
        return this.getFilesForTable(ctx, client, tableName);
    }

    protected boolean userTrashDirExists(FileSystem fs) {
        return !fs.getTrashRoots(false).isEmpty();
    }

    protected void makeTrashDir(FileSystem fs) throws IOException {
        if (!this.userTrashDirExists(fs)) {
            Path homeDir = fs.getHomeDirectory();
            Path trashDir = new Path(homeDir, ".Trash");
            Assertions.assertTrue((boolean)fs.mkdirs(trashDir));
        }
        Assertions.assertTrue((boolean)this.userTrashDirExists(fs));
    }

    protected void waitForFilesToBeGCd(ArrayList<StoredTabletFile> files) throws Exception {
        Wait.waitFor(() -> files.stream().noneMatch(stf -> {
            try {
                return super.getCluster().getMiniDfs().getFileSystem().exists(stf.getPath());
            }
            catch (IOException e) {
                throw new UncheckedIOException("error", e);
            }
        }));
    }

    protected long countFilesInTrash(FileSystem fs, TableId tid) throws FileNotFoundException, IOException {
        Collection dirs = fs.getTrashRoots(true);
        if (dirs.isEmpty()) {
            return -1L;
        }
        long count = 0L;
        for (FileStatus stat : dirs) {
            LOG.debug("Trash root: {}", (Object)stat.getPath());
            RemoteIterator riter = fs.listFiles(stat.getPath(), true);
            while (riter.hasNext()) {
                LocatedFileStatus lfs = (LocatedFileStatus)riter.next();
                if (lfs.isDirectory()) continue;
                TabletFile tf = new TabletFile(lfs.getPath());
                LOG.debug("File in trash: {}, tableId: {}", (Object)lfs.getPath(), (Object)tf.getTableId());
                if (!tid.equals((Object)tf.getTableId())) continue;
                ++count;
            }
        }
        return count;
    }
}

