/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.GarbageCollectorTrashBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GarbageCollectorTrashDisabledIT
extends GarbageCollectorTrashBase {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(5L);
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        HashMap<String, String> hadoopOverrides = new HashMap<String, String>();
        hadoopOverrides.put("fs.trash.interval", "5");
        cfg.setHadoopConfOverrides(hadoopOverrides);
        cfg.useMiniDFS(true);
        cfg.setProperty(Property.GC_CYCLE_START, "1");
        cfg.setProperty(Property.GC_CYCLE_DELAY, "1");
        Property p = Property.GC_TRASH_IGNORE;
        cfg.setProperty(p, "true");
        cfg.setProperty(Property.GC_PORT, "0");
        cfg.setProperty(Property.TSERV_MAXMEM, "5K");
        cfg.setProperty(Property.TABLE_MAJC_RATIO, "5.0");
        cfg.setProperty(Property.TSERV_MAJC_DELAY, "180s");
    }

    @Test
    public void testTrashHadoopEnabledAccumuloDisabled() throws Exception {
        String table = this.getUniqueNames(1)[0];
        FileSystem fs = super.getCluster().getFileSystem();
        super.makeTrashDir(fs);
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            ArrayList<StoredTabletFile> files = super.loadData(super.getServerContext(), c, table);
            Assertions.assertFalse((boolean)files.isEmpty());
            c.tableOperations().compact(table, new CompactionConfig());
            TableId tid = TableId.of((String)((String)c.tableOperations().tableIdMap().get(table)));
            super.waitForFilesToBeGCd(files);
            Assertions.assertEquals((long)0L, (long)super.countFilesInTrash(fs, tid));
        }
    }
}

