/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.GarbageCollectorTrashBase;
import org.apache.accumulo.test.functional.ReadWriteIT;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.TrashPolicyDefault;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GarbageCollectorTrashEnabledCustomPolicyIT
extends GarbageCollectorTrashBase {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(5L);
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        HashMap<String, String> hadoopOverrides = new HashMap<String, String>();
        hadoopOverrides.put("fs.trash.interval", "5");
        hadoopOverrides.put("fs.trash.classname", NoFlushFilesInTrashPolicy.class.getName());
        cfg.setHadoopConfOverrides(hadoopOverrides);
        cfg.useMiniDFS(true);
        cfg.setProperty(Property.GC_CYCLE_START, "1");
        cfg.setProperty(Property.GC_CYCLE_DELAY, "1");
        Property p = Property.GC_TRASH_IGNORE;
        cfg.setProperty(p, "false");
        cfg.setProperty(Property.GC_PORT, "0");
        cfg.setProperty(Property.TSERV_MAXMEM, "5K");
        cfg.setProperty(Property.TABLE_MAJC_RATIO, "5.0");
        cfg.setProperty(Property.TSERV_MAJC_DELAY, "180s");
    }

    @Test
    public void testTrashHadoopEnabledAccumuloEnabled() throws Exception {
        String table = this.getUniqueNames(1)[0];
        FileSystem fs = super.getCluster().getFileSystem();
        super.makeTrashDir(fs);
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            ReadWriteIT.ingest(c, 10, 10, 10, 0, table);
            c.tableOperations().flush(table, null, null, true);
            ArrayList<StoredTabletFile> files1 = this.getFilesForTable(super.getServerContext(), c, table);
            Assertions.assertFalse((boolean)files1.isEmpty());
            Assertions.assertTrue((boolean)files1.stream().allMatch(stf -> stf.getPath().getName().startsWith("F")));
            c.tableOperations().compact(table, new CompactionConfig());
            super.waitForFilesToBeGCd(files1);
            ArrayList<StoredTabletFile> files2 = this.getFilesForTable(super.getServerContext(), c, table);
            Assertions.assertFalse((boolean)files2.isEmpty());
            Assertions.assertTrue((boolean)files2.stream().noneMatch(stf -> stf.getPath().getName().startsWith("F")));
            Assertions.assertTrue((boolean)files2.stream().allMatch(stf -> stf.getPath().getName().startsWith("A")));
            c.tableOperations().compact(table, new CompactionConfig());
            super.waitForFilesToBeGCd(files2);
            ArrayList<StoredTabletFile> files3 = this.getFilesForTable(super.getServerContext(), c, table);
            Assertions.assertTrue((boolean)files3.stream().allMatch(stf -> stf.getPath().getName().startsWith("A")));
            Assertions.assertEquals((int)1, (int)files3.size());
            TableId tid = TableId.of((String)((String)c.tableOperations().tableIdMap().get(table)));
            Assertions.assertEquals((long)1L, (long)super.countFilesInTrash(fs, tid));
        }
    }

    public static class NoFlushFilesInTrashPolicy
    extends TrashPolicyDefault {
        public boolean moveToTrash(Path path) throws IOException {
            if (!path.getName().startsWith("F")) {
                return super.moveToTrash(path);
            }
            return false;
        }
    }
}

