/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.File;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.spi.fs.DelegatingChooser;
import org.apache.accumulo.core.spi.fs.PreferredVolumeChooser;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.accumulo.test.functional.HalfClosedTabletIT;
import org.apache.accumulo.test.util.Wait;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class HalfClosedTablet2IT
extends SharedMiniClusterBase {
    @BeforeAll
    public static void startup() throws Exception {
        SharedMiniClusterBase.startMiniClusterWithConfig(new HalfClosedTablet2ITConfiguration());
    }

    @AfterAll
    public static void shutdown() throws Exception {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @Test
    public void testInvalidContextCausesVolumeChooserFailure() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(HalfClosedTablet2IT.getClientProps()).build();){
            TableOperations tops = client.tableOperations();
            tops.create(tableName);
            TableId tableId = TableId.of((String)((String)tops.tableIdMap().get(tableName)));
            try (BatchWriter bw = client.createBatchWriter(tableName);){
                Mutation m1 = new Mutation((CharSequence)"a");
                Mutation m2 = new Mutation((CharSequence)"b");
                m1.put(new Text("cf"), new Text(), new Value());
                m2.put(new Text("cf"), new Text(), new Value());
                bw.addMutation(m1);
                bw.addMutation(m2);
            }
            HalfClosedTabletIT.setInvalidClassLoaderContextPropertyWithoutValidation(HalfClosedTablet2IT.getCluster().getServerContext(), tableId);
            Thread.sleep(3000L);
            tops.flush(tableName);
            FunctionalTestUtils.checkRFiles(client, tableName, 1, 1, 0, 0);
            HalfClosedTabletIT.removeInvalidClassLoaderContextProperty(client, tableName);
            Wait.waitFor(() -> HalfClosedTabletIT.tabletHasExpectedRFiles(client, tableName, 1, 1, 1, 1), 340000L);
            tops.offline(tableName);
            Wait.waitFor(() -> HalfClosedTabletIT.countHostedTablets(client, tableId) == 0L, 340000L);
        }
    }

    public static class HalfClosedTablet2ITConfiguration
    implements MiniClusterConfigurationCallback {
        @Override
        public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
            cfg.setNumTservers(1);
            cfg.setProperty(Property.GENERAL_VOLUME_CHOOSER, DelegatingChooser.class.getName());
            cfg.setProperty("general.custom.volume.chooser.default", PreferredVolumeChooser.class.getName());
            cfg.setProperty("general.custom.volume.preferred.default", new File(cfg.getDir().getAbsolutePath(), "/accumulo").toURI().toString());
        }
    }
}

