/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.store.PropStoreKey;
import org.apache.accumulo.server.conf.store.TablePropKey;
import org.apache.accumulo.test.functional.BadIterator;
import org.apache.accumulo.test.functional.ErrorThrowingIterator;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.accumulo.test.util.Wait;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class HalfClosedTabletIT
extends SharedMiniClusterBase {
    @BeforeAll
    public static void startup() throws Exception {
        SharedMiniClusterBase.startMiniClusterWithConfig(new HalfClosedTabletITConfiguration());
    }

    @AfterAll
    public static void shutdown() throws Exception {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @Test
    public void testSplitWithInvalidContext() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(HalfClosedTabletIT.getClientProps()).build();){
            TableOperations tops = client.tableOperations();
            tops.create(tableName);
            TableId tableId = TableId.of((String)((String)tops.tableIdMap().get(tableName)));
            try (BatchWriter bw = client.createBatchWriter(tableName);){
                Mutation m1 = new Mutation((CharSequence)"a");
                Mutation m2 = new Mutation((CharSequence)"b");
                m1.put(new Text("cf"), new Text(), new Value());
                m2.put(new Text("cf"), new Text(), new Value());
                bw.addMutation(m1);
                bw.addMutation(m2);
            }
            HalfClosedTabletIT.setInvalidClassLoaderContextPropertyWithoutValidation(HalfClosedTabletIT.getCluster().getServerContext(), tableId);
            Thread.sleep(3000L);
            Thread configFixer = new Thread(() -> {
                UtilWaitThread.sleep((long)3000L);
                HalfClosedTabletIT.removeInvalidClassLoaderContextProperty(client, tableName);
            });
            long t1 = System.nanoTime();
            configFixer.start();
            tops.addSplits(tableName, (SortedSet)Sets.newTreeSet(List.of(new Text("b"))));
            long t2 = System.nanoTime();
            Assertions.assertTrue((TimeUnit.NANOSECONDS.toMillis(t2 - t1) >= 3000L ? 1 : 0) != 0);
            tops.offline(tableName);
            Wait.waitFor(() -> HalfClosedTabletIT.countHostedTablets(client, tableId) == 0L, 340000L);
        }
    }

    @Test
    public void testIteratorThrowingTransientError() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(HalfClosedTabletIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            TableOperations tops = c.tableOperations();
            tops.create(tableName);
            TableId tid = TableId.of((String)((String)tops.tableIdMap().get(tableName)));
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                Mutation m = new Mutation(new Text("r1"));
                m.put((CharSequence)"acf", (CharSequence)tableName, (CharSequence)"1");
                bw.addMutation(m);
            }
            IteratorSetting setting = new IteratorSetting(50, "error", ErrorThrowingIterator.class);
            setting.addOption("error.throwing.iterator.times", "3");
            c.tableOperations().attachIterator(tableName, setting, EnumSet.of(IteratorUtil.IteratorScope.minc));
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(true).setFlush(true));
            tops.offline(tableName);
            Wait.waitFor(() -> HalfClosedTabletIT.tabletHasExpectedRFiles(c, tableName, 1, 1, 1, 1), 340000L);
            Wait.waitFor(() -> HalfClosedTabletIT.countHostedTablets(c, tid) == 0L, 340000L);
        }
    }

    @Test
    public void testBadIteratorOnStack() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(HalfClosedTabletIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            TableOperations tops = c.tableOperations();
            tops.create(tableName);
            TableId tid = TableId.of((String)((String)tops.tableIdMap().get(tableName)));
            IteratorSetting is = new IteratorSetting(30, BadIterator.class);
            c.tableOperations().attachIterator(tableName, is, EnumSet.of(IteratorUtil.IteratorScope.minc));
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                Mutation m = new Mutation(new Text("r1"));
                m.put((CharSequence)"acf", (CharSequence)tableName, (CharSequence)"1");
                bw.addMutation(m);
            }
            c.tableOperations().flush(tableName, null, null, false);
            UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
            FunctionalTestUtils.checkRFiles(c, tableName, 1, 1, 0, 0);
            tops.offline(tableName);
            UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
            Assertions.assertTrue((HalfClosedTabletIT.countHostedTablets(c, tid) > 0L ? 1 : 0) != 0);
            FunctionalTestUtils.checkRFiles(c, tableName, 1, 1, 0, 0);
            c.tableOperations().removeIterator(tableName, BadIterator.class.getSimpleName(), EnumSet.of(IteratorUtil.IteratorScope.minc));
            Wait.waitFor(() -> HalfClosedTabletIT.tabletHasExpectedRFiles(c, tableName, 1, 1, 1, 1), 340000L);
            Wait.waitFor(() -> HalfClosedTabletIT.countHostedTablets(c, tid) == 0L, 340000L);
        }
    }

    public static void setInvalidClassLoaderContextPropertyWithoutValidation(ServerContext context, TableId tableId) {
        TablePropKey key = TablePropKey.of((ServerContext)context, (TableId)tableId);
        context.getPropStore().putAll((PropStoreKey)key, Map.of(Property.TABLE_CLASSLOADER_CONTEXT.getKey(), "invalid"));
    }

    public static void removeInvalidClassLoaderContextProperty(AccumuloClient client, String tableName) {
        try {
            client.tableOperations().removeProperty(tableName, Property.TABLE_CLASSLOADER_CONTEXT.getKey());
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean tabletHasExpectedRFiles(AccumuloClient c, String tableName, int minTablets, int maxTablets, int minRFiles, int maxRFiles) {
        try {
            FunctionalTestUtils.checkRFiles(c, tableName, minTablets, maxTablets, minRFiles, maxRFiles);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static long countHostedTablets(AccumuloClient c, TableId tid) {
        try (TabletsMetadata tm = ((ClientContext)c).getAmple().readTablets().forTable(tid).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.LOCATION}).build();){
            long l = tm.stream().count();
            return l;
        }
    }

    public static class HalfClosedTabletITConfiguration
    implements MiniClusterConfigurationCallback {
        @Override
        public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
            cfg.setNumTservers(1);
        }
    }
}

