/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.miniclusterImpl.ProcessReference;
import org.apache.accumulo.start.Main;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class HalfDeadTServerIT
extends ConfigurableMacBase {
    private static final AtomicBoolean sharedLibBuilt = new AtomicBoolean(false);

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(4L);
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(1);
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setProperty(Property.GENERAL_RPC_TIMEOUT, "5s");
        cfg.setProperty(Property.TSERV_NATIVEMAP_ENABLED, Boolean.FALSE.toString());
    }

    @BeforeAll
    @SuppressFBWarnings(value={"COMMAND_INJECTION"}, justification="command executed is not from user input")
    public static void buildSharedLib() throws IOException, InterruptedException {
        String root = System.getProperty("user.dir");
        String source = root + "/src/test/c/fake_disk_failure.c";
        String lib = root + "/target/fake_disk_failure.so";
        String platform = System.getProperty("os.name");
        String[] cmd = platform.equals("Darwin") ? new String[]{"gcc", "-arch", "x86_64", "-arch", "i386", "-dynamiclib", "-O3", "-fPIC", source, "-o", lib} : new String[]{"gcc", "-D_GNU_SOURCE", "-Wall", "-fPIC", source, "-shared", "-o", lib, "-ldl"};
        Process gcc = new ProcessBuilder(cmd).inheritIO().start();
        sharedLibBuilt.set(gcc.waitFor() == 0);
    }

    @Test
    public void testRecover() throws Exception {
        this.test(10, false);
    }

    @Test
    public void testTimeout() throws Exception {
        String results = this.test(20, true);
        if (results != null && !results.contains("Session expired")) {
            log.info("Failed to find 'Session expired' in output, but TServer did die which is expected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "COMMAND_INJECTION"}, justification="path provided by test; command args provided by test")
    public String test(int seconds, boolean expectTserverDied) throws Exception {
        Assumptions.assumeTrue((boolean)sharedLibBuilt.get(), (String)"Shared library did not build");
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String string;
            DumpOutput stdoutCollector;
            DumpOutput stderrCollector;
            Process tserver;
            block32: {
                while (client.instanceOperations().getTabletServers().isEmpty()) {
                    Thread.sleep(50L);
                }
                String javaHome = System.getProperty("java.home");
                String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
                Object classpath = System.getProperty("java.class.path");
                classpath = new File(this.cluster.getConfig().getDir(), "conf") + File.pathSeparator + (String)classpath;
                String className = TabletServer.class.getName();
                ProcessBuilder builder = new ProcessBuilder(javaBin, Main.class.getName(), className);
                Map<String, String> env = builder.environment();
                env.put("CLASSPATH", (String)classpath);
                env.put("ACCUMULO_HOME", this.cluster.getConfig().getDir().getAbsolutePath());
                env.put("ACCUMULO_LOG_DIR", this.cluster.getConfig().getLogDir().getAbsolutePath());
                String trickFilename = this.cluster.getConfig().getLogDir().getAbsolutePath() + "/TRICK_FILE";
                env.put("TRICK_FILE", trickFilename);
                String libPath = System.getProperty("user.dir") + "/target/fake_disk_failure.so";
                env.put("LD_PRELOAD", libPath);
                env.put("DYLD_INSERT_LIBRARIES", libPath);
                env.put("DYLD_FORCE_FLAT_NAMESPACE", "true");
                Process ingest = null;
                tserver = builder.start();
                stderrCollector = new DumpOutput(tserver.getErrorStream(), System.err, "stderr");
                stdoutCollector = new DumpOutput(tserver.getInputStream(), System.out, "stdout");
                try {
                    stderrCollector.start();
                    stdoutCollector.start();
                    UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                    this.cluster.killProcess(ServerType.TABLET_SERVER, (ProcessReference)((Collection)this.cluster.getProcesses().get(ServerType.TABLET_SERVER)).iterator().next());
                    UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                    client.tableOperations().create("test_ingest");
                    Assertions.assertEquals((int)1, (int)client.instanceOperations().getTabletServers().size());
                    int rows = 100000;
                    ingest = this.cluster.exec(TestIngest.class, new String[]{"-c", this.cluster.getClientPropsPath(), "--rows", "" + rows}).getProcess();
                    UtilWaitThread.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
                    File trickFile = new File(trickFilename);
                    try {
                        Assertions.assertTrue((boolean)trickFile.createNewFile());
                        UtilWaitThread.sleepUninterruptibly((long)seconds, (TimeUnit)TimeUnit.SECONDS);
                    }
                    finally {
                        if (!trickFile.delete()) {
                            log.error("Couldn't delete {}", (Object)trickFile);
                        }
                    }
                    if (seconds <= 10) {
                        Assertions.assertEquals((int)0, (int)ingest.waitFor());
                        VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(this.getClientProperties());
                        params.rows = rows;
                        VerifyIngest.verifyIngest(client, params);
                    } else {
                        UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
                        tserver.waitFor();
                        stderrCollector.join();
                        stdoutCollector.join();
                        tserver = null;
                    }
                    String results = stdoutCollector.getCaptured();
                    Assertions.assertTrue((boolean)results.contains("sleeping\nsleeping\nsleeping\n"));
                    string = results;
                    if (ingest == null) break block32;
                    ingest.destroy();
                }
                catch (Throwable throwable) {
                    if (ingest != null) {
                        ingest.destroy();
                        ingest.waitFor();
                    }
                    if (tserver != null) {
                        try {
                            if (expectTserverDied) {
                                try {
                                    tserver.exitValue();
                                }
                                catch (IllegalThreadStateException e) {
                                    Assertions.fail((String)"Expected TServer to kill itself, but it is still running");
                                }
                            }
                        }
                        finally {
                            tserver.destroy();
                            tserver.waitFor();
                            stderrCollector.join();
                            stdoutCollector.join();
                        }
                    }
                    throw throwable;
                }
                ingest.waitFor();
            }
            if (tserver != null) {
                try {
                    if (expectTserverDied) {
                        try {
                            tserver.exitValue();
                        }
                        catch (IllegalThreadStateException e) {
                            Assertions.fail((String)"Expected TServer to kill itself, but it is still running");
                        }
                    }
                }
                finally {
                    tserver.destroy();
                    tserver.waitFor();
                    stderrCollector.join();
                    stdoutCollector.join();
                }
            }
            return string;
        }
    }

    private static class DumpOutput
    extends Thread {
        private final Scanner lineScanner;
        private final StringBuilder capturedOutput;
        private final PrintStream printer;
        private final String printerName;

        DumpOutput(InputStream is, PrintStream out, String name) {
            this.lineScanner = new Scanner(is);
            this.capturedOutput = new StringBuilder();
            this.printer = out;
            this.printerName = name;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (this.lineScanner.hasNextLine()) {
                String line = this.lineScanner.nextLine();
                this.capturedOutput.append(line);
                this.capturedOutput.append("\n");
                this.printer.printf("%s(%s):%s%n", this.getClass().getSimpleName(), this.printerName, line);
            }
        }

        public String getCaptured() {
            return this.capturedOutput.toString();
        }
    }
}

