/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Test;

public class IteratorMincClassCastBugIT
extends AccumuloClusterHarness {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.TSERV_NATIVEMAP_ENABLED, "false");
        cfg.setNumTservers(1);
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(IteratorMincClassCastBugIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            HashMap<String, Set<Text>> groups = new HashMap<String, Set<Text>>();
            groups.put("g1", Set.of(new Text("even")));
            groups.put("g2", Set.of(new Text("odd")));
            ntc.setLocalityGroups(groups);
            IteratorSetting iteratorSetting = new IteratorSetting(20, ClasCastIterator.class);
            ntc.attachIterator(iteratorSetting, EnumSet.of(IteratorUtil.IteratorScope.minc));
            c.tableOperations().create(tableName, ntc);
            try (BatchWriter bw = c.createBatchWriter(tableName, new BatchWriterConfig());){
                Mutation m1 = new Mutation(new Text("r1"));
                m1.put(new Text("odd"), new Text(), new Value((CharSequence)"1"));
                bw.addMutation(m1);
                Mutation m2 = new Mutation(new Text("r2"));
                m2.put(new Text("even"), new Text(), new Value((CharSequence)"2"));
                bw.addMutation(m2);
            }
            c.tableOperations().flush(tableName, null, null, true);
        }
    }

    public static class ClasCastIterator
    implements SortedKeyValueIterator<Key, Value> {
        SortedKeyValueIterator<Key, Value> ref;

        public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
            this.ref = source.deepCopy(env);
        }

        public boolean hasTop() {
            return this.ref.hasTop();
        }

        public void next() throws IOException {
            this.ref.next();
        }

        public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
            this.ref.seek(range, columnFamilies, inclusive);
        }

        public Key getTopKey() {
            return (Key)this.ref.getTopKey();
        }

        public Value getTopValue() {
            return (Value)this.ref.getTopValue();
        }

        public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
            throw new UnsupportedOperationException();
        }
    }
}

