/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.lang.reflect.UndeclaredThrowableException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.DelegationTokenConfig;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.DelegationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.clientImpl.AuthenticationTokenIdentifier;
import org.apache.accumulo.core.clientImpl.DelegationTokenImpl;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.harness.AccumuloITBase;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.MiniClusterHarness;
import org.apache.accumulo.harness.TestingKdc;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="MiniClusterOnly")
public class KerberosIT
extends AccumuloITBase {
    private static final Logger log = LoggerFactory.getLogger(KerberosIT.class);
    private static TestingKdc kdc;
    private static String krbEnabledForITs;
    private static ClusterUser rootUser;
    private MiniAccumuloClusterImpl mac;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(5L);
    }

    @BeforeAll
    public static void startKdc() throws Exception {
        kdc = new TestingKdc();
        kdc.start();
        krbEnabledForITs = System.getProperty("org.apache.accumulo.test.functional.useKrbForIT");
        if (krbEnabledForITs == null || !Boolean.parseBoolean(krbEnabledForITs)) {
            System.setProperty("org.apache.accumulo.test.functional.useKrbForIT", "true");
        }
        rootUser = kdc.getRootUser();
    }

    @AfterAll
    public static void stopKdc() {
        if (kdc != null) {
            kdc.stop();
        }
        if (krbEnabledForITs != null) {
            System.setProperty("org.apache.accumulo.test.functional.useKrbForIT", krbEnabledForITs);
        }
        UserGroupInformation.setConfiguration((Configuration)new Configuration(false));
    }

    @BeforeEach
    public void startMac() throws Exception {
        MiniClusterHarness harness = new MiniClusterHarness();
        this.mac = harness.create(this, (AuthenticationToken)new PasswordToken((CharSequence)"unused"), kdc, new MiniClusterConfigurationCallback(){

            @Override
            public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
                Map site = cfg.getSiteConfig();
                site.put(Property.INSTANCE_ZK_TIMEOUT.getKey(), "15s");
                cfg.setSiteConfig(site);
            }
        });
        this.mac.getConfig().setNumTservers(1);
        this.mac.start();
        Configuration conf = new Configuration(false);
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
    }

    @AfterEach
    public void stopMac() throws Exception {
        if (this.mac != null) {
            this.mac.stop();
        }
    }

    @Test
    public void testAdminUser() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
        ugi.doAs(() -> {
            AccumuloClient client = this.mac.createAccumuloClient(rootUser.getPrincipal(), (AuthenticationToken)new KerberosToken());
            for (SystemPermission perm : SystemPermission.values()) {
                Assertions.assertTrue((boolean)client.securityOperations().hasSystemPermission(client.whoami(), perm), (String)("Expected user to have permission: " + perm));
            }
            for (String table : Arrays.asList(RootTable.NAME, MetadataTable.NAME)) {
                Assertions.assertTrue((boolean)client.securityOperations().hasTablePermission(client.whoami(), table, TablePermission.ALTER_TABLE));
            }
            return null;
        });
    }

    @Test
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="path provided by test")
    public void testNewUser() throws Exception {
        String newUser = this.testName();
        File newUserKeytab = new File(kdc.getKeytabDir(), newUser + ".keytab");
        if (newUserKeytab.exists() && !newUserKeytab.delete()) {
            log.warn("Unable to delete {}", (Object)newUserKeytab);
        }
        kdc.createPrincipal(newUserKeytab, newUser);
        String newQualifiedUser = kdc.qualifyUser(newUser);
        HashSet users = Sets.newHashSet((Object[])new String[]{rootUser.getPrincipal()});
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
        log.info("Logged in as {}", (Object)rootUser.getPrincipal());
        ugi.doAs(() -> {
            AccumuloClient client = this.mac.createAccumuloClient(rootUser.getPrincipal(), (AuthenticationToken)new KerberosToken());
            log.info("Created client as {}", (Object)rootUser.getPrincipal());
            Assertions.assertEquals((Object)rootUser.getPrincipal(), (Object)client.whoami());
            this.createTableWithDataAndCompact(client);
            Assertions.assertEquals((Object)users, (Object)client.securityOperations().listLocalUsers());
            return null;
        });
        ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)newQualifiedUser, (String)newUserKeytab.getAbsolutePath());
        log.info("Logged in as {}", (Object)newQualifiedUser);
        ugi.doAs(() -> {
            AccumuloClient client = this.mac.createAccumuloClient(newQualifiedUser, (AuthenticationToken)new KerberosToken());
            log.info("Created client as {}", (Object)newQualifiedUser);
            Assertions.assertEquals((Object)newQualifiedUser, (Object)client.whoami());
            for (SystemPermission perm : SystemPermission.values()) {
                Assertions.assertFalse((boolean)client.securityOperations().hasSystemPermission(newQualifiedUser, perm));
            }
            users.add(newQualifiedUser);
            Assertions.assertEquals((Object)users, (Object)client.securityOperations().listLocalUsers());
            return null;
        });
    }

    @Test
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="path provided by test")
    public void testUserPrivilegesThroughGrant() throws Exception {
        String user1 = this.testName();
        File user1Keytab = new File(kdc.getKeytabDir(), user1 + ".keytab");
        if (user1Keytab.exists() && !user1Keytab.delete()) {
            log.warn("Unable to delete {}", (Object)user1Keytab);
        }
        kdc.createPrincipal(user1Keytab, user1);
        String qualifiedUser1 = kdc.qualifyUser(user1);
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)user1, (String)user1Keytab.getAbsolutePath());
        log.info("Logged in as {}", (Object)user1);
        ugi.doAs(() -> {
            AccumuloClient client = this.mac.createAccumuloClient(qualifiedUser1, (AuthenticationToken)new KerberosToken());
            log.info("Created client as {}", (Object)qualifiedUser1);
            for (SystemPermission perm : SystemPermission.values()) {
                Assertions.assertFalse((boolean)client.securityOperations().hasSystemPermission(qualifiedUser1, perm));
            }
            return null;
        });
        ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
        ugi.doAs(() -> {
            AccumuloClient client = this.mac.createAccumuloClient(rootUser.getPrincipal(), (AuthenticationToken)new KerberosToken());
            client.securityOperations().grantSystemPermission(qualifiedUser1, SystemPermission.CREATE_TABLE);
            return null;
        });
        ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)user1, (String)user1Keytab.getAbsolutePath());
        ugi.doAs(() -> {
            AccumuloClient client = this.mac.createAccumuloClient(qualifiedUser1, (AuthenticationToken)new KerberosToken());
            String table = this.testName() + "_user_table";
            client.tableOperations().create(table);
            try (BatchWriter bw = client.createBatchWriter(table);){
                Mutation m = new Mutation((CharSequence)"a");
                m.put((CharSequence)"b", (CharSequence)"c", (CharSequence)"d");
                bw.addMutation(m);
            }
            client.tableOperations().compact(table, new CompactionConfig().setWait(true).setFlush(true));
            return null;
        });
    }

    @Test
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="path provided by test")
    public void testUserPrivilegesForTable() throws Exception {
        String user1 = this.testName();
        File user1Keytab = new File(kdc.getKeytabDir(), user1 + ".keytab");
        if (user1Keytab.exists() && !user1Keytab.delete()) {
            log.warn("Unable to delete {}", (Object)user1Keytab);
        }
        kdc.createPrincipal(user1Keytab, user1);
        String qualifiedUser1 = kdc.qualifyUser(user1);
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)qualifiedUser1, (String)user1Keytab.getAbsolutePath());
        log.info("Logged in as {}", (Object)user1);
        ugi.doAs(() -> {
            AccumuloClient client = this.mac.createAccumuloClient(qualifiedUser1, (AuthenticationToken)new KerberosToken());
            log.info("Created client as {}", (Object)qualifiedUser1);
            for (SystemPermission perm : SystemPermission.values()) {
                Assertions.assertFalse((boolean)client.securityOperations().hasSystemPermission(qualifiedUser1, perm));
            }
            return null;
        });
        String table = this.testName() + "_user_table";
        String viz = "viz";
        ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
        ugi.doAs(() -> {
            AccumuloClient client = this.mac.createAccumuloClient(rootUser.getPrincipal(), (AuthenticationToken)new KerberosToken());
            client.tableOperations().create(table);
            client.securityOperations().grantTablePermission(qualifiedUser1, table, TablePermission.READ);
            client.securityOperations().grantTablePermission(qualifiedUser1, table, TablePermission.WRITE);
            client.securityOperations().grantTablePermission(qualifiedUser1, table, TablePermission.ALTER_TABLE);
            client.securityOperations().grantTablePermission(qualifiedUser1, table, TablePermission.DROP_TABLE);
            client.securityOperations().changeUserAuthorizations(qualifiedUser1, new Authorizations(new String[]{"viz"}));
            return null;
        });
        ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)qualifiedUser1, (String)user1Keytab.getAbsolutePath());
        ugi.doAs(() -> {
            AccumuloClient client = this.mac.createAccumuloClient(qualifiedUser1, (AuthenticationToken)new KerberosToken());
            long ts = 1000L;
            try (BatchWriter bw = client.createBatchWriter(table);){
                Mutation m = new Mutation((CharSequence)"a");
                m.put((CharSequence)"b", (CharSequence)"c", new ColumnVisibility("viz".getBytes()), 1000L, (CharSequence)"d");
                bw.addMutation(m);
            }
            client.tableOperations().compact(table, new CompactionConfig().setWait(true).setFlush(true));
            client.tableOperations().setProperty(table, Property.TABLE_BLOOM_ENABLED.getKey(), "true");
            try (Scanner s = client.createScanner(table, new Authorizations(new String[]{"viz"}));){
                Map.Entry<Key, Value> entry = this.getOnlyElement(s);
                Assertions.assertEquals((Object)new Key((CharSequence)"a", (CharSequence)"b", (CharSequence)"c", (CharSequence)"viz", 1000L), (Object)entry.getKey());
                Assertions.assertEquals((Object)new Value((CharSequence)"d"), (Object)entry.getValue());
                Void void_ = null;
                return void_;
            }
        });
    }

    @Test
    public void testDelegationToken() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        UserGroupInformation root = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
        log.info("Logged in as {}", (Object)rootUser.getPrincipal());
        int numRows = 100;
        int numColumns = 10;
        AuthenticationToken delegationToken = (AuthenticationToken)root.doAs(() -> {
            AccumuloClient client = this.mac.createAccumuloClient(rootUser.getPrincipal(), (AuthenticationToken)new KerberosToken());
            log.info("Created client as {}", (Object)rootUser.getPrincipal());
            Assertions.assertEquals((Object)rootUser.getPrincipal(), (Object)client.whoami());
            client.tableOperations().create(tableName);
            try (BatchWriter bw = client.createBatchWriter(tableName);){
                for (int r = 0; r < 100; ++r) {
                    Mutation m = new Mutation((CharSequence)Integer.toString(r));
                    for (int c = 0; c < 10; ++c) {
                        String col = Integer.toString(c);
                        m.put((CharSequence)col, (CharSequence)col, (CharSequence)col);
                    }
                    bw.addMutation(m);
                }
            }
            return client.securityOperations().getDelegationToken(new DelegationTokenConfig());
        });
        UserGroupInformation userWithoutPrivs = UserGroupInformation.createUserForTesting((String)"fake_user", (String[])new String[0]);
        int recordsSeen = (Integer)userWithoutPrivs.doAs(() -> {
            AccumuloClient client = this.mac.createAccumuloClient(rootUser.getPrincipal(), delegationToken);
            try (BatchScanner bs = client.createBatchScanner(tableName);){
                bs.setRanges(Collections.singleton(new Range()));
                Integer n = Iterables.size((Iterable)bs);
                return n;
            }
        });
        Assertions.assertEquals((int)1000, (int)recordsSeen);
    }

    @Test
    public void testDelegationTokenAsDifferentUser() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
        log.info("Logged in as {}", (Object)rootUser.getPrincipal());
        AuthenticationToken delegationToken = (AuthenticationToken)ugi.doAs(() -> {
            AccumuloClient client = this.mac.createAccumuloClient(rootUser.getPrincipal(), (AuthenticationToken)new KerberosToken());
            log.info("Created client as {}", (Object)rootUser.getPrincipal());
            Assertions.assertEquals((Object)rootUser.getPrincipal(), (Object)client.whoami());
            return client.securityOperations().getDelegationToken(new DelegationTokenConfig());
        });
        UserGroupInformation userWithoutPrivs = UserGroupInformation.createUserForTesting((String)"fake_user", (String[])new String[0]);
        UndeclaredThrowableException e = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, () -> userWithoutPrivs.doAs(() -> {
            AccumuloClient client = this.mac.createAccumuloClient("some_other_user", delegationToken);
            client.securityOperations().authenticateUser("some_other_user", delegationToken);
            return null;
        }), (String)"Using a delegation token as a different user should throw an exception");
        Throwable cause = e.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertTrue((boolean)(cause instanceof AccumuloSecurityException), (String)("Expected cause to be AccumuloSecurityException, but was " + cause.getClass()));
    }

    @Test
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="path provided by test")
    public void testGetDelegationTokenDenied() throws Exception {
        String newUser = this.testName();
        File newUserKeytab = new File(kdc.getKeytabDir(), newUser + ".keytab");
        if (newUserKeytab.exists() && !newUserKeytab.delete()) {
            log.warn("Unable to delete {}", (Object)newUserKeytab);
        }
        kdc.createPrincipal(newUserKeytab, newUser);
        String qualifiedNewUser = kdc.qualifyUser(newUser);
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)qualifiedNewUser, (String)newUserKeytab.getAbsolutePath());
        try {
            ugi.doAs(() -> {
                AccumuloClient client = this.mac.createAccumuloClient(qualifiedNewUser, (AuthenticationToken)new KerberosToken());
                log.info("Created client as {}", (Object)qualifiedNewUser);
                Assertions.assertEquals((Object)qualifiedNewUser, (Object)client.whoami());
                client.securityOperations().getDelegationToken(new DelegationTokenConfig());
                return null;
            });
        }
        catch (UndeclaredThrowableException ex) {
            Assertions.assertTrue((boolean)(ex.getCause() instanceof AccumuloSecurityException));
        }
    }

    @Test
    public void testRestartedManagerReusesSecretKey() throws Exception {
        UserGroupInformation root = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
        log.info("Logged in as {}", (Object)rootUser.getPrincipal());
        AuthenticationToken delegationToken1 = (AuthenticationToken)root.doAs(() -> {
            AccumuloClient client = this.mac.createAccumuloClient(rootUser.getPrincipal(), (AuthenticationToken)new KerberosToken());
            log.info("Created client as {}", (Object)rootUser.getPrincipal());
            Assertions.assertEquals((Object)rootUser.getPrincipal(), (Object)client.whoami());
            DelegationToken token = client.securityOperations().getDelegationToken(new DelegationTokenConfig());
            Assertions.assertTrue((!this.mac.createAccumuloClient(rootUser.getPrincipal(), (AuthenticationToken)token).tableOperations().list().isEmpty() ? 1 : 0) != 0, (String)"Could not get tables with delegation token");
            return token;
        });
        log.info("Stopping manager");
        this.mac.getClusterControl().stop(ServerType.MANAGER);
        Thread.sleep(5000L);
        log.info("Restarting manager");
        this.mac.getClusterControl().start(ServerType.MANAGER);
        root.doAs(() -> {
            AccumuloClient client = this.mac.createAccumuloClient(rootUser.getPrincipal(), delegationToken1);
            Assertions.assertTrue((!client.tableOperations().list().isEmpty() ? 1 : 0) != 0, (String)"Could not get tables with delegation token");
            return null;
        });
        AuthenticationToken delegationToken2 = (AuthenticationToken)root.doAs(() -> {
            AccumuloClient client = this.mac.createAccumuloClient(rootUser.getPrincipal(), (AuthenticationToken)new KerberosToken());
            log.info("Created client as {}", (Object)rootUser.getPrincipal());
            Assertions.assertEquals((Object)rootUser.getPrincipal(), (Object)client.whoami());
            DelegationToken token = client.securityOperations().getDelegationToken(new DelegationTokenConfig());
            Assertions.assertTrue((!this.mac.createAccumuloClient(rootUser.getPrincipal(), (AuthenticationToken)token).tableOperations().list().isEmpty() ? 1 : 0) != 0, (String)"Could not get tables with delegation token");
            return token;
        });
        DelegationTokenImpl dt1 = (DelegationTokenImpl)delegationToken1;
        DelegationTokenImpl dt2 = (DelegationTokenImpl)delegationToken2;
        Assertions.assertEquals((int)dt1.getIdentifier().getKeyId(), (int)dt2.getIdentifier().getKeyId());
    }

    @Test
    public void testDelegationTokenWithInvalidLifetime() throws Throwable {
        UserGroupInformation root = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
        log.info("Logged in as {}", (Object)rootUser.getPrincipal());
        UndeclaredThrowableException e = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, () -> root.doAs(() -> {
            try (AccumuloClient client = this.mac.createAccumuloClient(rootUser.getPrincipal(), (AuthenticationToken)new KerberosToken());){
                log.info("Created client as {}", (Object)rootUser.getPrincipal());
                Assertions.assertEquals((Object)rootUser.getPrincipal(), (Object)client.whoami());
                DelegationToken delegationToken = client.securityOperations().getDelegationToken(new DelegationTokenConfig().setTokenLifetime(Long.MAX_VALUE, TimeUnit.MILLISECONDS));
                return delegationToken;
            }
        }));
        Assertions.assertEquals(AccumuloException.class, e.getCause().getClass());
    }

    @Test
    public void testDelegationTokenWithReducedLifetime() throws Throwable {
        UserGroupInformation root = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
        log.info("Logged in as {}", (Object)rootUser.getPrincipal());
        AuthenticationToken dt = (AuthenticationToken)root.doAs(() -> {
            try (AccumuloClient client = this.mac.createAccumuloClient(rootUser.getPrincipal(), (AuthenticationToken)new KerberosToken());){
                log.info("Created client as {}", (Object)rootUser.getPrincipal());
                Assertions.assertEquals((Object)rootUser.getPrincipal(), (Object)client.whoami());
                DelegationToken delegationToken = client.securityOperations().getDelegationToken(new DelegationTokenConfig().setTokenLifetime(5L, TimeUnit.MINUTES));
                return delegationToken;
            }
        });
        AuthenticationTokenIdentifier identifier = ((DelegationTokenImpl)dt).getIdentifier();
        Assertions.assertTrue((identifier.getExpirationDate() - identifier.getIssueDate() <= TimeUnit.MINUTES.toMillis(5L) ? 1 : 0) != 0, (String)("Expected identifier to expire in no more than 5 minutes: " + identifier));
    }

    @Test
    public void testRootUserHasIrrevocablePermissions() throws Exception {
        UserGroupInformation.loginUserFromKeytab((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
        try (AccumuloClient client = this.mac.createAccumuloClient(rootUser.getPrincipal(), (AuthenticationToken)new KerberosToken());){
            Assertions.assertThrows(AccumuloSecurityException.class, () -> client.securityOperations().revokeSystemPermission(rootUser.getPrincipal(), SystemPermission.GRANT));
        }
    }

    private void createTableWithDataAndCompact(AccumuloClient client) throws TableNotFoundException, AccumuloSecurityException, AccumuloException, TableExistsException {
        String table = this.testName() + "_table";
        client.tableOperations().create(table);
        try (BatchWriter bw = client.createBatchWriter(table);){
            Mutation m = new Mutation((CharSequence)"a");
            m.put((CharSequence)"b", (CharSequence)"c", (CharSequence)"d");
            bw.addMutation(m);
        }
        client.tableOperations().compact(table, new CompactionConfig().setFlush(true).setWait(true));
    }

    static {
        krbEnabledForITs = null;
    }
}

