/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloITBase;
import org.apache.accumulo.harness.MiniClusterHarness;
import org.apache.accumulo.harness.TestingKdc;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.accumulo.test.util.Wait;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="MiniClusterOnly")
public class KerberosRenewalIT
extends AccumuloITBase {
    private static final Logger log = LoggerFactory.getLogger(KerberosRenewalIT.class);
    private static TestingKdc kdc;
    private static String krbEnabledForITs;
    private static ClusterUser rootUser;
    private static final long TICKET_LIFETIME;
    private static final long TICKET_TEST_LIFETIME;
    public static final int TEST_DURATION_MINUTES = 9;
    private MiniAccumuloClusterImpl mac;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(9L);
    }

    @BeforeAll
    public static void startKdc() throws Exception {
        kdc = new TestingKdc(TestingKdc.computeKdcDir(), TestingKdc.computeKeytabDir(), TICKET_LIFETIME);
        kdc.start();
        krbEnabledForITs = System.getProperty("org.apache.accumulo.test.functional.useKrbForIT");
        if (!Boolean.parseBoolean(krbEnabledForITs)) {
            System.setProperty("org.apache.accumulo.test.functional.useKrbForIT", "true");
        }
        rootUser = kdc.getRootUser();
    }

    @AfterAll
    public static void stopKdc() {
        if (kdc != null) {
            kdc.stop();
        }
        if (krbEnabledForITs != null) {
            System.setProperty("org.apache.accumulo.test.functional.useKrbForIT", krbEnabledForITs);
        }
    }

    @BeforeEach
    public void startMac() throws Exception {
        MiniClusterHarness harness = new MiniClusterHarness();
        this.mac = harness.create(this, (AuthenticationToken)new PasswordToken((CharSequence)"unused"), kdc, (cfg, coreSite) -> {
            Map site = cfg.getSiteConfig();
            site.put(Property.INSTANCE_ZK_TIMEOUT.getKey(), "15s");
            site.put(Property.GENERAL_KERBEROS_RENEWAL_PERIOD.getKey(), "5s");
            cfg.setSiteConfig(site);
            cfg.setClientProperty(ClientProperty.INSTANCE_ZOOKEEPERS_TIMEOUT, "15s");
        });
        this.mac.getConfig().setNumTservers(1);
        this.mac.start();
        Configuration conf = new Configuration(false);
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
    }

    @AfterEach
    public void stopMac() throws Exception {
        if (this.mac != null) {
            this.mac.stop();
        }
    }

    @Test
    @Timeout(value=9L, unit=TimeUnit.MINUTES)
    public void testReadAndWriteThroughTicketLifetime() throws Exception {
        UserGroupInformation.loginUserFromKeytab((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
        log.info("Logged in as {}", (Object)rootUser.getPrincipal());
        try (AccumuloClient client = this.mac.createAccumuloClient(rootUser.getPrincipal(), (AuthenticationToken)new KerberosToken());){
            log.info("Created client as {}", (Object)rootUser.getPrincipal());
            Assertions.assertEquals((Object)rootUser.getPrincipal(), (Object)client.whoami());
            String tableName = this.getUniqueNames(1)[0] + "_table";
            long endTime = System.currentTimeMillis() + TICKET_TEST_LIFETIME;
            while (System.currentTimeMillis() < endTime) {
                this.createReadWriteDrop(client, tableName);
                Thread.sleep(5000L);
            }
        }
    }

    private void createReadWriteDrop(AccumuloClient client, String tableName) throws Exception {
        client.tableOperations().create(tableName);
        try (BatchWriter bw = client.createBatchWriter(tableName);){
            Mutation m = new Mutation((CharSequence)"a");
            m.put((CharSequence)"b", (CharSequence)"c", (CharSequence)"d");
            bw.addMutation(m);
        }
        client.tableOperations().compact(tableName, new CompactionConfig().setFlush(true).setWait(true));
        try (Scanner s = client.createScanner(tableName, Authorizations.EMPTY);){
            Map.Entry<Key, Value> entry = this.getOnlyElement(s);
            Assertions.assertEquals((int)0, (int)new Key((CharSequence)"a", (CharSequence)"b", (CharSequence)"c").compareTo(entry.getKey(), PartialKey.ROW_COLFAM_COLQUAL), (String)"Did not find the expected key");
            Assertions.assertEquals((Object)"d", (Object)entry.getValue().toString());
        }
        client.tableOperations().delete(tableName);
        Wait.waitFor(() -> !client.tableOperations().exists(tableName), 20000L, 200L);
    }

    static {
        krbEnabledForITs = null;
        TICKET_LIFETIME = TimeUnit.MINUTES.toMillis(6L);
        TICKET_TEST_LIFETIME = TimeUnit.MINUTES.toMillis(8L);
    }
}

