/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.MemoryUnit;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.accumulo.test.util.Wait;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LargeRowIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(LargeRowIT.class);
    private static final int SEED = 42;
    private static final int NUM_ROWS = 100;
    private static final int ROW_SIZE = 131072;
    private static final int NUM_PRE_SPLITS = 9;
    private static final int SPLIT_THRESH = 1456355;
    private String REG_TABLE_NAME;
    private String PRE_SPLIT_TABLE_NAME;
    private int timeoutFactor = 1;
    private String tservMajcDelay;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(4L);
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setMemory(ServerType.TABLET_SERVER, cfg.getMemory(ServerType.TABLET_SERVER) * 2L, MemoryUnit.BYTE);
        Map siteConfig = cfg.getSiteConfig();
        siteConfig.put(Property.TSERV_MAJC_DELAY.getKey(), "10ms");
        cfg.setSiteConfig(siteConfig);
    }

    @BeforeEach
    public void getTimeoutFactor() throws Exception {
        this.timeoutFactor = Wait.getTimeoutFactor(e -> 1);
        String[] names = this.getUniqueNames(2);
        this.REG_TABLE_NAME = names[0];
        this.PRE_SPLIT_TABLE_NAME = names[1];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(LargeRowIT.getClientProps()).build();){
            this.tservMajcDelay = (String)c.instanceOperations().getSystemConfiguration().get(Property.TSERV_MAJC_DELAY.getKey());
            c.instanceOperations().setProperty(Property.TSERV_MAJC_DELAY.getKey(), "10ms");
        }
    }

    @AfterEach
    public void resetMajcDelay() throws Exception {
        if (this.tservMajcDelay != null) {
            try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(LargeRowIT.getClientProps()).build();){
                client.instanceOperations().setProperty(Property.TSERV_MAJC_DELAY.getKey(), this.tservMajcDelay);
            }
        }
    }

    @Test
    @SuppressFBWarnings(value={"PREDICTABLE_RANDOM", "DMI_RANDOM_USED_ONLY_ONCE"}, justification="predictable random with specific seed is intended for this test")
    public void run() throws Exception {
        Random random = new Random(43L);
        byte[] rowData = new byte[131072];
        TreeSet<Text> splitPoints = new TreeSet<Text>();
        for (int i = 0; i < 9; ++i) {
            random.nextBytes(rowData);
            TestIngest.toPrintableChars(rowData);
            splitPoints.add(new Text(rowData));
        }
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(LargeRowIT.getClientProps()).build();){
            c.tableOperations().create(this.REG_TABLE_NAME);
            c.tableOperations().create(this.PRE_SPLIT_TABLE_NAME, new NewTableConfiguration().setProperties(Collections.singletonMap(Property.TABLE_MAX_END_ROW_SIZE.getKey(), "256K")).withSplits(splitPoints));
            UtilWaitThread.sleepUninterruptibly((long)3L, (TimeUnit)TimeUnit.SECONDS);
            this.test1(c);
            this.test2(c);
        }
    }

    private void test1(AccumuloClient c) throws Exception {
        this.basicTest(c, this.REG_TABLE_NAME, 0);
        c.tableOperations().setProperty(this.REG_TABLE_NAME, Property.TABLE_SPLIT_THRESHOLD.getKey(), "1456355");
        UtilWaitThread.sleepUninterruptibly((long)(this.timeoutFactor * 12), (TimeUnit)TimeUnit.SECONDS);
        log.info("checking splits");
        FunctionalTestUtils.checkSplits(c, this.REG_TABLE_NAME, 4, 36);
        this.verify(c, this.REG_TABLE_NAME);
    }

    private void test2(AccumuloClient c) throws Exception {
        this.basicTest(c, this.PRE_SPLIT_TABLE_NAME, 9);
    }

    @SuppressFBWarnings(value={"PREDICTABLE_RANDOM", "DMI_RANDOM_USED_ONLY_ONCE"}, justification="predictable random with specific seed is intended for this test")
    private void basicTest(AccumuloClient c, String table, int expectedSplits) throws Exception {
        try (BatchWriter bw = c.createBatchWriter(table);){
            Random random = new Random(42L);
            byte[] rowData = new byte[131072];
            for (int i = 0; i < 100; ++i) {
                random.nextBytes(rowData);
                TestIngest.toPrintableChars(rowData);
                Mutation mut = new Mutation(new Text(rowData));
                mut.put((CharSequence)"", (CharSequence)"", (CharSequence)Integer.toString(i));
                bw.addMutation(mut);
            }
        }
        FunctionalTestUtils.checkSplits(c, table, expectedSplits, expectedSplits);
        this.verify(c, table);
        FunctionalTestUtils.checkSplits(c, table, expectedSplits, expectedSplits);
        c.tableOperations().flush(table, null, null, false);
        this.verify(c, table);
        c.tableOperations().flush(table, null, null, true);
        FunctionalTestUtils.checkSplits(c, table, expectedSplits, expectedSplits);
        this.verify(c, table);
        FunctionalTestUtils.checkSplits(c, table, expectedSplits, expectedSplits);
    }

    @SuppressFBWarnings(value={"PREDICTABLE_RANDOM", "DMI_RANDOM_USED_ONLY_ONCE"}, justification="predictable random with specific seed is intended for this test")
    private void verify(AccumuloClient c, String table) throws Exception {
        Random random = new Random(42L);
        byte[] rowData = new byte[131072];
        try (Scanner scanner = c.createScanner(table, Authorizations.EMPTY);){
            for (int i = 0; i < 100; ++i) {
                random.nextBytes(rowData);
                TestIngest.toPrintableChars(rowData);
                scanner.setRange(new Range(new Text(rowData)));
                int count = 0;
                for (Map.Entry entry : scanner) {
                    if (!((Key)entry.getKey()).getRow().equals((Object)new Text(rowData))) {
                        throw new Exception("verification failed, unexpected row i =" + i);
                    }
                    if (!((Value)entry.getValue()).equals((Object)new Value((CharSequence)Integer.toString(i)))) {
                        throw new Exception("verification failed, unexpected value i =" + i + " value = " + entry.getValue());
                    }
                    ++count;
                }
                if (count == true) continue;
                throw new Exception("verification failed, unexpected count i =" + i + " count=" + count);
            }
        }
    }
}

