/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.admin.SecurityOperations;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Credentials;
import org.apache.accumulo.core.clientImpl.thrift.TVersionedProperties;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.manager.thrift.ManagerClientService;
import org.apache.accumulo.core.manager.thrift.ManagerGoalState;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.singletons.SingletonManager;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;

@TestMethodOrder(value=MethodOrderer.MethodName.class)
public class ManagerApiIT
extends SharedMiniClusterBase {
    private static Credentials rootUser;
    private static Credentials regularUser;
    private static Credentials privilegedUser;
    private static InstanceId instanceId;
    private ThriftClientTypes.Exec<Void, ManagerClientService.Client> op;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    @BeforeAll
    public static void setup() throws Exception {
        SingletonManager.setMode((SingletonManager.Mode)SingletonManager.Mode.SERVER);
        SharedMiniClusterBase.startMiniCluster();
        rootUser = new Credentials(ManagerApiIT.getPrincipal(), ManagerApiIT.getToken());
        regularUser = new Credentials("regularUser", (AuthenticationToken)new PasswordToken((CharSequence)"regularUser"));
        privilegedUser = new Credentials("privilegedUser", (AuthenticationToken)new PasswordToken((CharSequence)"privilegedUser"));
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ManagerApiIT.getClientProps()).build();){
            instanceId = client.instanceOperations().getInstanceId();
            SecurityOperations rootSecOps = client.securityOperations();
            for (Credentials user : Arrays.asList(regularUser, privilegedUser)) {
                rootSecOps.createLocalUser(user.getPrincipal(), (PasswordToken)user.getToken());
            }
            rootSecOps.grantSystemPermission(privilegedUser.getPrincipal(), SystemPermission.SYSTEM);
        }
    }

    @AfterAll
    public static void teardown() throws Exception {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @Test
    public void testPermissions_setManagerGoalState() throws Exception {
        this.op = client -> {
            client.setManagerGoalState(TraceUtil.traceInfo(), regularUser.toThrift(instanceId), ManagerGoalState.NORMAL);
            return null;
        };
        ManagerApiIT.expectPermissionDenied(this.op, regularUser);
        this.op = client -> {
            client.setManagerGoalState(TraceUtil.traceInfo(), rootUser.toThrift(instanceId), ManagerGoalState.NORMAL);
            return null;
        };
        ManagerApiIT.expectPermissionSuccess(this.op, rootUser);
        this.op = client -> {
            client.setManagerGoalState(TraceUtil.traceInfo(), privilegedUser.toThrift(instanceId), ManagerGoalState.NORMAL);
            return null;
        };
        ManagerApiIT.expectPermissionSuccess(this.op, privilegedUser);
    }

    @Test
    public void testPermissions_initiateFlush() throws Exception {
        String tableId;
        String[] uniqNames = this.getUniqueNames(3);
        String tableName = uniqNames[0];
        Credentials regUserWithWrite = new Credentials(uniqNames[1], (AuthenticationToken)new PasswordToken((CharSequence)uniqNames[1]));
        Credentials regUserWithAlter = new Credentials(uniqNames[2], (AuthenticationToken)new PasswordToken((CharSequence)uniqNames[2]));
        try (AccumuloClient client2 = (AccumuloClient)Accumulo.newClient().from(ManagerApiIT.getClientProps()).build();){
            SecurityOperations rootSecOps = client2.securityOperations();
            rootSecOps.createLocalUser(regUserWithWrite.getPrincipal(), (PasswordToken)regUserWithWrite.getToken());
            rootSecOps.createLocalUser(regUserWithAlter.getPrincipal(), (PasswordToken)regUserWithAlter.getToken());
            client2.tableOperations().create(tableName);
            rootSecOps.grantTablePermission(regUserWithWrite.getPrincipal(), tableName, TablePermission.WRITE);
            rootSecOps.grantTablePermission(regUserWithAlter.getPrincipal(), tableName, TablePermission.ALTER_TABLE);
            tableId = (String)client2.tableOperations().tableIdMap().get(tableName);
        }
        this.op = client -> {
            client.initiateFlush(TraceUtil.traceInfo(), regularUser.toThrift(instanceId), tableId);
            return null;
        };
        ManagerApiIT.expectPermissionDenied(this.op, regularUser);
        this.op = client -> {
            client.initiateFlush(TraceUtil.traceInfo(), privilegedUser.toThrift(instanceId), tableId);
            return null;
        };
        ManagerApiIT.expectPermissionDenied(this.op, privilegedUser);
        this.op = client -> {
            client.initiateFlush(TraceUtil.traceInfo(), regUserWithWrite.toThrift(instanceId), tableId);
            return null;
        };
        ManagerApiIT.expectPermissionSuccess(this.op, regUserWithWrite);
        this.op = client -> {
            client.initiateFlush(TraceUtil.traceInfo(), regUserWithAlter.toThrift(instanceId), tableId);
            return null;
        };
        ManagerApiIT.expectPermissionSuccess(this.op, regUserWithAlter);
        this.op = client -> {
            client.initiateFlush(TraceUtil.traceInfo(), rootUser.toThrift(instanceId), tableId);
            return null;
        };
        ManagerApiIT.expectPermissionSuccess(this.op, rootUser);
    }

    @Test
    public void testPermissions_waitForFlush() throws Exception {
        String tableId;
        String[] uniqNames = this.getUniqueNames(3);
        String tableName = uniqNames[0];
        Credentials regUserWithWrite = new Credentials(uniqNames[1], (AuthenticationToken)new PasswordToken((CharSequence)uniqNames[1]));
        Credentials regUserWithAlter = new Credentials(uniqNames[2], (AuthenticationToken)new PasswordToken((CharSequence)uniqNames[2]));
        try (AccumuloClient client2 = (AccumuloClient)Accumulo.newClient().from(ManagerApiIT.getClientProps()).build();){
            SecurityOperations rootSecOps = client2.securityOperations();
            rootSecOps.createLocalUser(regUserWithWrite.getPrincipal(), (PasswordToken)regUserWithWrite.getToken());
            rootSecOps.createLocalUser(regUserWithAlter.getPrincipal(), (PasswordToken)regUserWithAlter.getToken());
            client2.tableOperations().create(tableName);
            rootSecOps.grantTablePermission(regUserWithWrite.getPrincipal(), tableName, TablePermission.WRITE);
            rootSecOps.grantTablePermission(regUserWithAlter.getPrincipal(), tableName, TablePermission.ALTER_TABLE);
            tableId = (String)client2.tableOperations().tableIdMap().get(tableName);
        }
        AtomicLong flushId = new AtomicLong();
        this.op = client -> {
            flushId.set(client.initiateFlush(TraceUtil.traceInfo(), rootUser.toThrift(instanceId), tableId));
            return null;
        };
        ManagerApiIT.expectPermissionSuccess(this.op, rootUser);
        this.op = client -> {
            client.waitForFlush(TraceUtil.traceInfo(), regularUser.toThrift(instanceId), tableId, TextUtil.getByteBuffer((Text)new Text("myrow")), TextUtil.getByteBuffer((Text)new Text("myrow~")), flushId.get(), 1L);
            return null;
        };
        ManagerApiIT.expectPermissionDenied(this.op, regularUser);
        this.op = client -> {
            client.waitForFlush(TraceUtil.traceInfo(), privilegedUser.toThrift(instanceId), tableId, TextUtil.getByteBuffer((Text)new Text("myrow")), TextUtil.getByteBuffer((Text)new Text("myrow~")), flushId.get(), 1L);
            return null;
        };
        ManagerApiIT.expectPermissionDenied(this.op, privilegedUser);
        this.op = client -> {
            client.waitForFlush(TraceUtil.traceInfo(), regUserWithWrite.toThrift(instanceId), tableId, TextUtil.getByteBuffer((Text)new Text("myrow")), TextUtil.getByteBuffer((Text)new Text("myrow~")), flushId.get(), 1L);
            return null;
        };
        ManagerApiIT.expectPermissionSuccess(this.op, regUserWithWrite);
        this.op = client -> {
            client.waitForFlush(TraceUtil.traceInfo(), regUserWithAlter.toThrift(instanceId), tableId, TextUtil.getByteBuffer((Text)new Text("myrow")), TextUtil.getByteBuffer((Text)new Text("myrow~")), flushId.get(), 1L);
            return null;
        };
        ManagerApiIT.expectPermissionSuccess(this.op, regUserWithAlter);
        this.op = client -> {
            client.waitForFlush(TraceUtil.traceInfo(), rootUser.toThrift(instanceId), tableId, TextUtil.getByteBuffer((Text)new Text("myrow")), TextUtil.getByteBuffer((Text)new Text("myrow~")), flushId.get(), 1L);
            return null;
        };
        ManagerApiIT.expectPermissionSuccess(this.op, rootUser);
    }

    @Test
    public void testPermissions_modifySystemProperties() throws Exception {
        String propKey = Property.TSERV_TOTAL_MUTATION_QUEUE_MAX.getKey();
        this.op = client -> {
            client.modifySystemProperties(TraceUtil.traceInfo(), regularUser.toThrift(instanceId), new TVersionedProperties(0L, Map.of(propKey, "10000")));
            return null;
        };
        ManagerApiIT.expectPermissionDenied(this.op, regularUser);
        this.op = client -> {
            client.modifySystemProperties(TraceUtil.traceInfo(), rootUser.toThrift(instanceId), new TVersionedProperties(0L, Map.of(propKey, "10000")));
            return null;
        };
        ManagerApiIT.expectPermissionSuccess(this.op, rootUser);
        this.op = client -> {
            client.modifySystemProperties(TraceUtil.traceInfo(), privilegedUser.toThrift(instanceId), new TVersionedProperties(1L, Map.of(propKey, "10000")));
            return null;
        };
        ManagerApiIT.expectPermissionSuccess(this.op, privilegedUser);
        try (AccumuloClient client2 = (AccumuloClient)Accumulo.newClient().from(ManagerApiIT.getClientProps()).build();){
            client2.instanceOperations().removeProperty(propKey);
        }
    }

    @Test
    public void testPermissions_removeSystemProperty() throws Exception {
        String propKey1 = Property.GC_CYCLE_DELAY.getKey();
        String propKey2 = Property.GC_CYCLE_START.getKey();
        try (AccumuloClient client2 = (AccumuloClient)Accumulo.newClient().from(ManagerApiIT.getClientProps()).build();){
            client2.instanceOperations().setProperty(propKey1, "10000");
            client2.instanceOperations().setProperty(propKey2, "10000");
        }
        this.op = client -> {
            client.removeSystemProperty(TraceUtil.traceInfo(), regularUser.toThrift(instanceId), propKey1);
            return null;
        };
        ManagerApiIT.expectPermissionDenied(this.op, regularUser);
        this.op = client -> {
            client.removeSystemProperty(TraceUtil.traceInfo(), rootUser.toThrift(instanceId), propKey1);
            return null;
        };
        ManagerApiIT.expectPermissionSuccess(this.op, rootUser);
        this.op = client -> {
            client.removeSystemProperty(TraceUtil.traceInfo(), privilegedUser.toThrift(instanceId), propKey2);
            return null;
        };
        ManagerApiIT.expectPermissionSuccess(this.op, privilegedUser);
    }

    @Test
    public void testPermissions_setSystemProperty() throws Exception {
        String propKey = Property.TSERV_TOTAL_MUTATION_QUEUE_MAX.getKey();
        this.op = client -> {
            client.setSystemProperty(TraceUtil.traceInfo(), regularUser.toThrift(instanceId), propKey, "10000");
            return null;
        };
        ManagerApiIT.expectPermissionDenied(this.op, regularUser);
        this.op = client -> {
            client.setSystemProperty(TraceUtil.traceInfo(), rootUser.toThrift(instanceId), propKey, "10000");
            return null;
        };
        ManagerApiIT.expectPermissionSuccess(this.op, rootUser);
        this.op = client -> {
            client.setSystemProperty(TraceUtil.traceInfo(), privilegedUser.toThrift(instanceId), propKey, "10000");
            return null;
        };
        ManagerApiIT.expectPermissionSuccess(this.op, privilegedUser);
        try (AccumuloClient client2 = (AccumuloClient)Accumulo.newClient().from(ManagerApiIT.getClientProps()).build();){
            client2.instanceOperations().removeProperty(propKey);
        }
    }

    @Test
    public void testPermissions_shutdownTabletServer() throws Exception {
        String fakeHostAndPort = this.getUniqueNames(1)[0] + ":0";
        this.op = client -> {
            client.shutdownTabletServer(TraceUtil.traceInfo(), regularUser.toThrift(instanceId), fakeHostAndPort, false);
            return null;
        };
        ManagerApiIT.expectPermissionDenied(this.op, regularUser);
        this.op = client -> {
            client.shutdownTabletServer(TraceUtil.traceInfo(), rootUser.toThrift(instanceId), fakeHostAndPort, false);
            return null;
        };
        ManagerApiIT.expectPermissionSuccess(this.op, rootUser);
        this.op = client -> {
            client.shutdownTabletServer(TraceUtil.traceInfo(), privilegedUser.toThrift(instanceId), fakeHostAndPort, false);
            return null;
        };
        ManagerApiIT.expectPermissionSuccess(this.op, privilegedUser);
    }

    @Test
    public void shutdownTabletServer() throws Exception {
        this.op = client -> {
            client.shutdownTabletServer(TraceUtil.traceInfo(), rootUser.toThrift(instanceId), "fakeTabletServer:9997", true);
            return null;
        };
        try (AccumuloClient client2 = (AccumuloClient)Accumulo.newClient().from(ManagerApiIT.getClientProps()).as((CharSequence)rootUser.getPrincipal(), rootUser.getToken()).build();){
            ClientContext context = (ClientContext)client2;
            ThriftClientTypes.MANAGER.execute(context, this.op);
        }
    }

    @Test
    public void z99_testPermissions_shutdown() throws Exception {
        AccumuloClient.ConnectionOptions rootUserBuilder = Accumulo.newClient().from(ManagerApiIT.getClientProps()).as((CharSequence)rootUser.getPrincipal(), rootUser.getToken());
        AccumuloClient.ConnectionOptions privUserBuilder = Accumulo.newClient().from(ManagerApiIT.getClientProps()).as((CharSequence)privilegedUser.getPrincipal(), privilegedUser.getToken());
        try (AccumuloClient rootClient = (AccumuloClient)rootUserBuilder.build();
             AccumuloClient privClient = (AccumuloClient)privUserBuilder.build();){
            this.op = client -> {
                client.shutdown(TraceUtil.traceInfo(), regularUser.toThrift(instanceId), false);
                return null;
            };
            ManagerApiIT.expectPermissionDenied(this.op, regularUser);
            this.op = client -> {
                client.shutdown(TraceUtil.traceInfo(), rootUser.toThrift(instanceId), false);
                return null;
            };
            ManagerApiIT.expectPermissionSuccess(this.op, (ClientContext)rootClient);
            this.op = client -> {
                client.shutdown(TraceUtil.traceInfo(), privilegedUser.toThrift(instanceId), false);
                return null;
            };
            ManagerApiIT.expectPermissionSuccess(this.op, (ClientContext)privClient);
        }
    }

    private static void expectPermissionSuccess(ThriftClientTypes.Exec<Void, ManagerClientService.Client> op, Credentials user) throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ManagerApiIT.getClientProps()).as((CharSequence)user.getPrincipal(), user.getToken()).build();){
            ClientContext context = (ClientContext)client;
            ThriftClientTypes.MANAGER.execute(context, op);
        }
    }

    private static void expectPermissionSuccess(ThriftClientTypes.Exec<Void, ManagerClientService.Client> op, ClientContext context) throws Exception {
        ThriftClientTypes.MANAGER.execute(context, op);
    }

    private static void expectPermissionDenied(ThriftClientTypes.Exec<Void, ManagerClientService.Client> op, Credentials user) {
        AccumuloSecurityException e = (AccumuloSecurityException)Assertions.assertThrows(AccumuloSecurityException.class, () -> ManagerApiIT.expectPermissionSuccess(op, user));
        Assertions.assertSame((Object)SecurityErrorCode.PERMISSION_DENIED, (Object)e.getSecurityErrorCode());
    }
}

