/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.admin.Locations;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.TabletLocationState;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterControl;
import org.apache.accumulo.server.manager.state.MetaDataTableScanner;
import org.apache.accumulo.test.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ManagerAssignmentIT
extends AccumuloClusterHarness {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(2L);
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(ManagerAssignmentIT.getClientProps()).build();){
            TabletLocationState newTablet;
            String tableName = super.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            String tableId = (String)c.tableOperations().tableIdMap().get(tableName);
            do {
                UtilWaitThread.sleep((long)250L);
                newTablet = this.getTabletLocationState(c, tableId);
            } while (newTablet.current == null);
            Assertions.assertNull((Object)newTablet.last);
            Assertions.assertNull((Object)newTablet.future);
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                Mutation m = new Mutation((CharSequence)"a");
                m.put((CharSequence)"b", (CharSequence)"c", (CharSequence)"d");
                bw.addMutation(m);
            }
            c.tableOperations().flush(tableName, null, null, true);
            TabletLocationState flushed = this.getTabletLocationState(c, tableId);
            Assertions.assertEquals((Object)newTablet.current, (Object)flushed.current);
            Assertions.assertEquals((Object)flushed.getCurrentServer(), (Object)flushed.getLastServer());
            Assertions.assertNull((Object)newTablet.future);
            c.tableOperations().offline(tableName, true);
            TabletLocationState offline = this.getTabletLocationState(c, tableId);
            Assertions.assertNull((Object)offline.future);
            Assertions.assertNull((Object)offline.current);
            Assertions.assertEquals((Object)flushed.getCurrentServer(), (Object)offline.getLastServer());
            c.tableOperations().online(tableName, true);
            TabletLocationState online = this.getTabletLocationState(c, tableId);
            Assertions.assertNull((Object)online.future);
            Assertions.assertNotNull((Object)online.current);
            Assertions.assertEquals((Object)online.getCurrentServer(), (Object)online.getLastServer());
        }
    }

    @Test
    public void testShutdownOnlyTServerWithUserTable() throws Exception {
        ManagerAssignmentIT.getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
        ((MiniAccumuloClusterControl)ManagerAssignmentIT.getClusterControl()).start(ServerType.TABLET_SERVER, Collections.emptyMap(), 1);
        String tableName = this.getUniqueNames(1)[0];
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ManagerAssignmentIT.getClientProps()).build();){
            Wait.waitFor(() -> client.instanceOperations().getTabletServers().size() == 1);
            client.tableOperations().create(tableName);
            client.instanceOperations().waitForBalance();
            try (BatchWriter writer = client.createBatchWriter(tableName);){
                for (int i = 0; i < 1000000; ++i) {
                    Mutation m = new Mutation((CharSequence)String.format("%08d", i));
                    m.put((CharSequence)"", (CharSequence)"", (CharSequence)"");
                    writer.addMutation(m);
                }
            }
            client.tableOperations().flush(tableName, null, null, true);
            CountDownLatch latch = new CountDownLatch(10);
            Runnable task = () -> ManagerAssignmentIT.lambda$testShutdownOnlyTServerWithUserTable$2(client, tableName, latch);
            ExecutorService service = Executors.newFixedThreadPool(10);
            for (int i = 0; i < 10; ++i) {
                service.execute(task);
            }
            latch.await();
            Locations locs = client.tableOperations().locate(tableName, Collections.singletonList(MetadataSchema.TabletsSection.getRange()));
            locs.groupByTablet().keySet().stream().map(tid -> locs.getTabletLocation(tid)).forEach(location -> {
                HostAndPort address = HostAndPort.fromString((String)location);
                Object addressWithSession = address.toString();
                ServiceLock.ServiceLockPath zLockPath = ServiceLock.path((String)(ManagerAssignmentIT.getCluster().getServerContext().getZooKeeperRoot() + "/tservers/" + address.toString()));
                long sessionId = ServiceLock.getSessionId((ZooCache)ManagerAssignmentIT.getCluster().getServerContext().getZooCache(), (ServiceLock.ServiceLockPath)zLockPath);
                if (sessionId != 0L) {
                    addressWithSession = address.toString() + "[" + Long.toHexString(sessionId) + "]";
                }
                String finalAddress = addressWithSession;
                System.out.println("Attempting to shutdown TabletServer at: " + address.toString());
                try {
                    ThriftClientTypes.MANAGER.executeVoid((ClientContext)client, c -> c.shutdownTabletServer(TraceUtil.traceInfo(), ManagerAssignmentIT.getCluster().getServerContext().rpcCreds(), finalAddress, false));
                }
                catch (AccumuloException | AccumuloSecurityException e) {
                    Assertions.fail((String)"Error shutting down TabletServer", (Throwable)e);
                }
            });
            Wait.waitFor(() -> client.instanceOperations().getTabletServers().size() == 0);
        }
    }

    @Test
    public void testShutdownOnlyTServerWithoutUserTable() throws Exception {
        ManagerAssignmentIT.getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
        ((MiniAccumuloClusterControl)ManagerAssignmentIT.getClusterControl()).start(ServerType.TABLET_SERVER, Collections.emptyMap(), 1);
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ManagerAssignmentIT.getClientProps()).build();){
            Wait.waitFor(() -> client.instanceOperations().getTabletServers().size() == 1, 60000L);
            client.instanceOperations().waitForBalance();
            Locations locs = client.tableOperations().locate(RootTable.NAME, Collections.singletonList(MetadataSchema.TabletsSection.getRange()));
            locs.groupByTablet().keySet().stream().map(tid -> locs.getTabletLocation(tid)).forEach(location -> {
                HostAndPort address = HostAndPort.fromString((String)location);
                Object addressWithSession = address.toString();
                ServiceLock.ServiceLockPath zLockPath = ServiceLock.path((String)(ManagerAssignmentIT.getCluster().getServerContext().getZooKeeperRoot() + "/tservers/" + address.toString()));
                long sessionId = ServiceLock.getSessionId((ZooCache)ManagerAssignmentIT.getCluster().getServerContext().getZooCache(), (ServiceLock.ServiceLockPath)zLockPath);
                if (sessionId != 0L) {
                    addressWithSession = address.toString() + "[" + Long.toHexString(sessionId) + "]";
                }
                String finalAddress = addressWithSession;
                System.out.println("Attempting to shutdown TabletServer at: " + address.toString());
                try {
                    ThriftClientTypes.MANAGER.executeVoid((ClientContext)client, c -> c.shutdownTabletServer(TraceUtil.traceInfo(), ManagerAssignmentIT.getCluster().getServerContext().rpcCreds(), finalAddress, false));
                }
                catch (AccumuloException | AccumuloSecurityException e) {
                    Assertions.fail((String)"Error shutting down TabletServer", (Throwable)e);
                }
            });
            Wait.waitFor(() -> client.instanceOperations().getTabletServers().size() == 0);
        }
    }

    private TabletLocationState getTabletLocationState(AccumuloClient c, String tableId) {
        try (MetaDataTableScanner s = new MetaDataTableScanner((ClientContext)c, new Range(MetadataSchema.TabletsSection.encodeRow((TableId)TableId.of((String)tableId), null)), MetadataTable.NAME);){
            TabletLocationState tabletLocationState = s.next();
            return tabletLocationState;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ void lambda$testShutdownOnlyTServerWithUserTable$2(AccumuloClient client, String tableName, CountDownLatch latch) {
        try {
            while (true) lbl-1000:
            // 3 sources

            {
                scanner = new IsolatedScanner(client.createScanner(tableName));
                try {
                    count = new AtomicInteger(0);
                    scanner.forEach((Consumer<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$testShutdownOnlyTServerWithUserTable$1(java.util.concurrent.atomic.AtomicInteger java.util.concurrent.CountDownLatch java.util.Map$Entry ), (Ljava/util/Map$Entry;)V)((AtomicInteger)count, (CountDownLatch)latch));
                }
                finally {
                    scanner.close();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        ** GOTO lbl-1000
    }

    private static /* synthetic */ void lambda$testShutdownOnlyTServerWithUserTable$1(AtomicInteger count, CountDownLatch latch, Map.Entry e) {
        if (count.incrementAndGet() == 1000) {
            latch.countDown();
        }
    }
}

