/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Base64;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.log.WalStateManager;
import org.apache.accumulo.test.functional.WALSunnyDayIT;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManyWriteAheadLogsIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(ManyWriteAheadLogsIT.class);
    private String majcDelay;
    private String walSize;

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.TSERV_WAL_MAX_SIZE, "1M");
        cfg.setProperty(Property.GC_CYCLE_DELAY, "1");
        cfg.setProperty(Property.GC_CYCLE_START, "1");
        cfg.setProperty(Property.MANAGER_RECOVERY_DELAY, "1s");
        cfg.setProperty(Property.TSERV_MAJC_DELAY, "1");
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setProperty(Property.TABLE_MINC_COMPACT_IDLETIME, "1h");
        cfg.setNumTservers(1);
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @BeforeEach
    public void alterConfig() throws Exception {
        if (ManyWriteAheadLogsIT.getClusterType() == AccumuloClusterHarness.ClusterType.MINI) {
            return;
        }
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ManyWriteAheadLogsIT.getClientProps()).build();){
            InstanceOperations iops = client.instanceOperations();
            Map conf = iops.getSystemConfiguration();
            this.majcDelay = (String)conf.get(Property.TSERV_MAJC_DELAY.getKey());
            this.walSize = (String)conf.get(Property.TSERV_WAL_MAX_SIZE.getKey());
            iops.setProperty(Property.TSERV_MAJC_DELAY.getKey(), "1");
            iops.setProperty(Property.TSERV_WAL_MAX_SIZE.getKey(), "1M");
            ManyWriteAheadLogsIT.getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
            ManyWriteAheadLogsIT.getClusterControl().startAllServers(ServerType.TABLET_SERVER);
        }
    }

    @AfterEach
    public void resetConfig() throws Exception {
        if (this.majcDelay != null) {
            try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ManyWriteAheadLogsIT.getClientProps()).build();){
                InstanceOperations iops = client.instanceOperations();
                iops.setProperty(Property.TSERV_MAJC_DELAY.getKey(), this.majcDelay);
                iops.setProperty(Property.TSERV_WAL_MAX_SIZE.getKey(), this.walSize);
            }
            ManyWriteAheadLogsIT.getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
            ManyWriteAheadLogsIT.getClusterControl().startAllServers(ServerType.TABLET_SERVER);
        }
    }

    @Test
    public void testMany() throws Exception {
        TreeSet<Text> splits = new TreeSet<Text>();
        for (int i = 1; i < 100; ++i) {
            splits.add(new Text(String.format("%05x", i * 100)));
        }
        ServerContext context = ManyWriteAheadLogsIT.getServerContext();
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(ManyWriteAheadLogsIT.getClientProps()).build();){
            String[] tableNames = this.getUniqueNames(2);
            String manyWALsTable = tableNames[0];
            String rollWALsTable = tableNames[1];
            NewTableConfiguration ntc = new NewTableConfiguration().withSplits(splits);
            c.tableOperations().create(manyWALsTable, ntc);
            c.tableOperations().create(rollWALsTable);
            HashSet<String> allWalsSeen = new HashSet<String>();
            this.addOpenWals(context, allWalsSeen);
            try (BatchWriter manyWALsWriter = c.createBatchWriter(manyWALsTable);
                 BatchWriter rollWALsWriter = c.createBatchWriter(rollWALsTable);){
                byte[] val = new byte[768];
                for (int i = 0; i < 100; ++i) {
                    int j;
                    int startRow = i * 100;
                    for (j = 0; j < 10; ++j) {
                        int row = startRow + j;
                        Mutation m = new Mutation((CharSequence)String.format("%05x", row));
                        random.nextBytes(val);
                        m.put((CharSequence)"f", (CharSequence)"q", (CharSequence)"v");
                        manyWALsWriter.addMutation(m);
                    }
                    manyWALsWriter.flush();
                    for (j = 0; j < 1000; ++j) {
                        Mutation m = new Mutation((CharSequence)String.format("%03d", j));
                        random.nextBytes(val);
                        m.put((CharSequence)"f", (CharSequence)"q", (CharSequence)Base64.getEncoder().encodeToString(val));
                        rollWALsWriter.addMutation(m);
                    }
                    rollWALsWriter.flush();
                    this.addOpenWals(context, allWalsSeen);
                }
            }
            Assertions.assertTrue((allWalsSeen.size() >= 50 ? 1 : 0) != 0, (String)("Number of WALs seen was less than expected " + allWalsSeen.size()));
            int closedLogs = this.countClosedWals(context);
            while (closedLogs > 3) {
                log.debug("Waiting for wals to shrink " + closedLogs);
                Thread.sleep(250L);
                closedLogs = this.countClosedWals(context);
            }
        }
    }

    private void addOpenWals(ServerContext c, Set<String> allWalsSeen) throws Exception {
        int open = 0;
        int attempts = 0;
        boolean foundWal = false;
        while (open == 0) {
            ++attempts;
            Map<String, WalStateManager.WalState> wals = WALSunnyDayIT._getWals(c);
            Set<Map.Entry<String, WalStateManager.WalState>> es = wals.entrySet();
            for (Map.Entry<String, WalStateManager.WalState> entry : es) {
                if (entry.getValue() == WalStateManager.WalState.OPEN) {
                    ++open;
                    allWalsSeen.add(entry.getKey());
                    foundWal = true;
                    continue;
                }
                log.debug("The WalState for {} is {}", (Object)entry.getKey(), (Object)entry.getValue());
            }
            if (foundWal) continue;
            Thread.sleep(50L);
            if (attempts % 50 != 0) continue;
            log.debug("No open WALs found in {} attempts.", (Object)attempts);
        }
        log.debug("It took {} attempt(s) to find {} open WALs", (Object)attempts, (Object)open);
        Assertions.assertTrue((open > 0 && open < 4 ? 1 : 0) != 0, (String)("Open WALs not in expected range " + open));
    }

    private int countClosedWals(ServerContext c) throws Exception {
        int count = 0;
        Map<String, WalStateManager.WalState> wals = WALSunnyDayIT._getWals(c);
        for (WalStateManager.WalState ws : wals.values()) {
            if (ws != WalStateManager.WalState.CLOSED) continue;
            ++count;
        }
        return count;
    }
}

