/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MaxOpenIT
extends AccumuloClusterHarness {
    private String scanMaxOpenFiles;
    private String majcConcurrent;
    private String majcThreadMaxOpen;
    private static final int NUM_TABLETS = 16;
    private static final int NUM_TO_INGEST = 10000;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(3L);
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        Map conf = cfg.getSiteConfig();
        conf.put(Property.TSERV_SCAN_MAX_OPENFILES.getKey(), "4");
        conf.put(Property.TSERV_MAJC_MAXCONCURRENT.getKey(), "1");
        conf.put(Property.TSERV_MAJC_THREAD_MAXOPEN.getKey(), "2");
        cfg.setSiteConfig(conf);
    }

    @BeforeEach
    public void alterConfig() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(MaxOpenIT.getClientProps()).build();){
            InstanceOperations iops = client.instanceOperations();
            Map sysConfig = iops.getSystemConfiguration();
            this.scanMaxOpenFiles = (String)sysConfig.get(Property.TSERV_SCAN_MAX_OPENFILES.getKey());
            this.majcConcurrent = (String)sysConfig.get(Property.TSERV_MAJC_MAXCONCURRENT.getKey());
            this.majcThreadMaxOpen = (String)sysConfig.get(Property.TSERV_MAJC_THREAD_MAXOPEN.getKey());
        }
    }

    @AfterEach
    public void restoreConfig() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(MaxOpenIT.getClientProps()).build();){
            InstanceOperations iops = client.instanceOperations();
            if (this.scanMaxOpenFiles != null) {
                iops.setProperty(Property.TSERV_SCAN_MAX_OPENFILES.getKey(), this.scanMaxOpenFiles);
            }
            if (this.majcConcurrent != null) {
                iops.setProperty(Property.TSERV_MAJC_MAXCONCURRENT.getKey(), this.majcConcurrent);
            }
            if (this.majcThreadMaxOpen != null) {
                iops.setProperty(Property.TSERV_MAJC_THREAD_MAXOPEN.getKey(), this.majcThreadMaxOpen);
            }
        }
    }

    @Test
    public void run() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(MaxOpenIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(Property.TABLE_MAJC_RATIO.getKey(), "10");
            NewTableConfiguration ntc = new NewTableConfiguration().setProperties(props).withSplits(TestIngest.getSplitPoints(0L, 10000L, 16L));
            c.tableOperations().create(tableName, ntc);
            for (int i = 0; i < 3; ++i) {
                TestIngest.IngestParams params = new TestIngest.IngestParams(MaxOpenIT.getClientProps(), tableName, 10000);
                params.timestamp = i;
                params.dataSize = 50;
                params.rows = 10000;
                params.cols = 1;
                params.random = i;
                TestIngest.ingest(c, params);
                c.tableOperations().flush(tableName, null, null, true);
                FunctionalTestUtils.checkRFiles(c, tableName, 16, 16, i + 1, i + 1);
            }
            ArrayList<Range> ranges = new ArrayList<Range>(10000);
            for (int i = 0; i < 10000; ++i) {
                ranges.add(new Range(TestIngest.generateRow(i, 0)));
            }
            long time1 = this.batchScan(c, tableName, ranges, 1);
            time1 = this.batchScan(c, tableName, ranges, 1);
            long time2 = this.batchScan(c, tableName, ranges, 16);
            System.out.printf("Single thread scan time   %6.2f %n", (double)time1 / 1000.0);
            System.out.printf("Multiple thread scan time %6.2f %n", (double)time2 / 1000.0);
        }
    }

    private long batchScan(AccumuloClient c, String tableName, List<Range> ranges, int threads) throws Exception {
        try (BatchScanner bs = c.createBatchScanner(tableName, TestIngest.AUTHS, threads);){
            bs.setRanges(ranges);
            int count = 0;
            long t1 = System.currentTimeMillis();
            byte[] rval = new byte[50];
            for (Map.Entry entry : bs) {
                ++count;
                int row = VerifyIngest.getRow((Key)entry.getKey());
                int col = VerifyIngest.getCol((Key)entry.getKey());
                if (row < 0 || row >= 10000) {
                    throw new Exception("unexpected row " + row);
                }
                rval = TestIngest.genRandomValue(rval, 2, row, col);
                if (((Value)entry.getValue()).compareTo(rval) == 0) continue;
                throw new Exception("unexpected value row=" + row + " col=" + col);
            }
            long t2 = System.currentTimeMillis();
            if (count != 10000) {
                throw new Exception("Batch Scan did not return expected number of values " + count);
            }
            long l = t2 - t1;
            return l;
        }
    }
}

