/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionMetadata;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.spi.compaction.CompactionExecutorId;
import org.apache.accumulo.core.spi.compaction.CompactionKind;
import org.apache.accumulo.core.util.Merge;
import org.apache.accumulo.core.util.compaction.CompactionExecutorIdImpl;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MergeIT
extends AccumuloClusterHarness {
    SortedSet<Text> splits(String[] points) {
        TreeSet<Text> result = new TreeSet<Text>();
        for (String point : points) {
            result.add(new Text(point));
        }
        return result;
    }

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(8L);
    }

    @Test
    public void merge() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(MergeIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            NewTableConfiguration ntc = new NewTableConfiguration().withSplits(this.splits("a b c d e f g h i j k".split(" ")));
            c.tableOperations().create(tableName, ntc);
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                for (String row : "a b c d e f g h i j k".split(" ")) {
                    Mutation m = new Mutation((CharSequence)row);
                    m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
                    bw.addMutation(m);
                }
            }
            c.tableOperations().flush(tableName, null, null, true);
            c.tableOperations().merge(tableName, new Text("c1"), new Text("f1"));
            Assertions.assertEquals((int)8, (int)c.tableOperations().listSplits(tableName).size());
        }
    }

    @Test
    public void mergeSize() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(MergeIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            NewTableConfiguration ntc = new NewTableConfiguration().withSplits(this.splits("a b c d e f g h i j k l m n o p q r s t u v w x y z".split(" ")));
            c.tableOperations().create(tableName, ntc);
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                for (String row : "c e f y".split(" ")) {
                    Mutation m = new Mutation((CharSequence)row);
                    m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"mersydotesanddozeydotesanlittolamsiedives");
                    bw.addMutation(m);
                }
            }
            c.tableOperations().flush(tableName, null, null, true);
            Merge merge = new Merge();
            merge.mergomatic(c, tableName, null, null, 100L, false);
            Assertions.assertArrayEquals((Object[])"b c d e f x y".split(" "), (Object[])this.toStrings(c.tableOperations().listSplits(tableName)));
            merge.mergomatic(c, tableName, null, null, 100L, true);
            Assertions.assertArrayEquals((Object[])"c e f y".split(" "), (Object[])this.toStrings(c.tableOperations().listSplits(tableName)));
        }
    }

    private String[] toStrings(Collection<Text> listSplits) {
        String[] result = new String[listSplits.size()];
        int i = 0;
        for (Text t : listSplits) {
            result[i++] = t.toString();
        }
        return result;
    }

    private String[] ns(String ... strings) {
        return strings;
    }

    @Test
    public void mergeTest() throws Exception {
        int tc = 0;
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(MergeIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            this.runMergeTest(c, tableName + tc++, this.ns(new String[0]), this.ns(new String[0]), this.ns("l", "m", "n"), this.ns(null, "l"), this.ns(null, "n"));
            this.runMergeTest(c, tableName + tc++, this.ns("m"), this.ns(new String[0]), this.ns("l", "m", "n"), this.ns(null, "l"), this.ns(null, "n"));
            this.runMergeTest(c, tableName + tc++, this.ns("m"), this.ns("m"), this.ns("l", "m", "n"), this.ns("m", "n"), this.ns(null, "z"));
            this.runMergeTest(c, tableName + tc++, this.ns("m"), this.ns("m"), this.ns("l", "m", "n"), this.ns(null, "b"), this.ns("l", "m"));
            this.runMergeTest(c, tableName + tc++, this.ns("b", "m", "r"), this.ns(new String[0]), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns(null, "a"), this.ns(null, "s"));
            this.runMergeTest(c, tableName + tc++, this.ns("b", "m", "r"), this.ns("m", "r"), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns(null, "a"), this.ns("c", "m"));
            this.runMergeTest(c, tableName + tc++, this.ns("b", "m", "r"), this.ns("r"), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns(null, "a"), this.ns("n", "r"));
            this.runMergeTest(c, tableName + tc++, this.ns("b", "m", "r"), this.ns("b"), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns("b", "c"), this.ns(null, "s"));
            this.runMergeTest(c, tableName + tc++, this.ns("b", "m", "r"), this.ns("b", "m"), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns("m", "n"), this.ns(null, "s"));
            this.runMergeTest(c, tableName + tc++, this.ns("b", "m", "r"), this.ns("b", "r"), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns("b", "c"), this.ns("q", "r"));
            this.runMergeTest(c, tableName + tc++, this.ns("b", "m", "r"), this.ns("b", "m", "r"), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns(null, "a"), this.ns("aa", "b"));
            this.runMergeTest(c, tableName + tc++, this.ns("b", "m", "r"), this.ns("b", "m", "r"), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns("r", "s"), this.ns(null, "z"));
            this.runMergeTest(c, tableName + tc++, this.ns("b", "m", "r"), this.ns("b", "m", "r"), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns("b", "c"), this.ns("l", "m"));
            this.runMergeTest(c, tableName + tc++, this.ns("b", "m", "r"), this.ns("b", "m", "r"), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns("m", "n"), this.ns("q", "r"));
        }
    }

    private void runMergeTest(AccumuloClient c, String table, String[] splits, String[] expectedSplits, String[] inserts, String[] start, String[] end) throws Exception {
        int count = 0;
        for (String s : start) {
            for (String e : end) {
                this.runMergeTest(c, table + "_" + count++, splits, expectedSplits, inserts, s, e);
            }
        }
    }

    private void runMergeTest(AccumuloClient client, String table, String[] splits, String[] expectedSplits, String[] inserts, String start, String end) throws Exception {
        System.out.println("Running merge test " + table + " " + Arrays.asList(splits) + " " + start + " " + end);
        SortedSet<Text> splitSet = this.splits(splits);
        NewTableConfiguration ntc = new NewTableConfiguration().setTimeType(TimeType.LOGICAL);
        if (!splitSet.isEmpty()) {
            ntc = ntc.withSplits(splitSet);
        }
        client.tableOperations().create(table, ntc);
        HashSet<String> expected = new HashSet<String>();
        try (BatchWriter bw = client.createBatchWriter(table);){
            for (String row : inserts) {
                Mutation m = new Mutation((CharSequence)row);
                m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)row);
                bw.addMutation(m);
                expected.add(row);
            }
        }
        client.tableOperations().merge(table, start == null ? null : new Text(start), end == null ? null : new Text(end));
        try (Scanner scanner = client.createScanner(table, Authorizations.EMPTY);){
            HashSet<String> observed = new HashSet<String>();
            for (Map.Entry entry : scanner) {
                String row;
                row = ((Key)entry.getKey()).getRowData().toString();
                if (observed.add(row)) continue;
                throw new Exception("Saw data twice " + table + " " + row);
            }
            if (!observed.equals(expected)) {
                throw new Exception("data inconsistency " + table + " " + observed + " != " + expected);
            }
            HashSet currentSplits = new HashSet(client.tableOperations().listSplits(table));
            HashSet<Text> ess = new HashSet<Text>();
            for (String es : expectedSplits) {
                ess.add(new Text(es));
            }
            if (!currentSplits.equals(ess)) {
                throw new Exception("split inconsistency " + table + " " + currentSplits + " != " + ess);
            }
        }
    }

    @Test
    public void testCompactionMetadata() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(MergeIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            Text split = new Text("m");
            c.tableOperations().addSplits(tableName, new TreeSet<Text>(List.of(split)));
            TableId tableId = MergeIT.getServerContext().getTableId(tableName);
            try (Ample.TabletsMutator tabletsMutator = MergeIT.getServerContext().getAmple().mutateTablets();){
                for (KeyExtent extent : List.of(new KeyExtent(tableId, split, null), new KeyExtent(tableId, null, split))) {
                    Ample.TabletMutator tablet = tabletsMutator.mutateTablet(extent);
                    ExternalCompactionId ecid = ExternalCompactionId.generate((UUID)UUID.randomUUID());
                    TabletFile tmpFile = new TabletFile(new Path("file:///accumulo/tables/t-0/b-0/c1.rf"));
                    CompactionExecutorId ceid = CompactionExecutorIdImpl.externalId((String)"G1");
                    Set<StoredTabletFile> jobFiles = Set.of(new StoredTabletFile("file:///accumulo/tables/t-0/b-0/b2.rf"));
                    ExternalCompactionMetadata ecMeta = new ExternalCompactionMetadata(jobFiles, jobFiles, tmpFile, "localhost:4444", CompactionKind.SYSTEM, 2, ceid, false, false, Long.valueOf(44L));
                    tablet.putExternalCompaction(ecid, ecMeta);
                    tablet.mutate();
                }
            }
            try (TabletsMetadata tablets = MergeIT.getServerContext().getAmple().readTablets().forTable(tableId).build();){
                for (TabletMetadata tablet : tablets) {
                    Assertions.assertFalse((boolean)tablet.getExternalCompactions().isEmpty());
                }
            }
            c.tableOperations().merge(tableName, null, null);
            tablets = MergeIT.getServerContext().getAmple().readTablets().forTable(tableId).build();
            try {
                for (TabletMetadata tablet : tablets) {
                    Assertions.assertTrue((boolean)tablet.getExternalCompactions().isEmpty());
                }
            }
            finally {
                if (tablets != null) {
                    tablets.close();
                }
            }
        }
    }
}

