/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.iterators.user.VersioningIterator;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.spi.compaction.SimpleCompactionDispatcher;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.iterators.MetadataBulkLoadFilter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MetadataIT
extends AccumuloClusterHarness {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(2L);
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(1);
    }

    @Test
    public void testFlushAndCompact() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(MetadataIT.getClientProps()).build();){
            String[] tableNames = this.getUniqueNames(2);
            c.tableOperations().create(tableNames[0]);
            try (Scanner rootScanner = c.createScanner(RootTable.NAME, Authorizations.EMPTY);){
                rootScanner.setRange(MetadataSchema.TabletsSection.getRange());
                rootScanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                HashSet<String> files1 = new HashSet<String>();
                for (Object entry : rootScanner) {
                    files1.add(((Key)entry.getKey()).getColumnQualifier().toString());
                }
                c.tableOperations().create(tableNames[1]);
                c.tableOperations().flush(MetadataTable.NAME, null, null, true);
                HashSet<String> files2 = new HashSet<String>();
                for (Map.Entry entry : rootScanner) {
                    files2.add(((Key)entry.getKey()).getColumnQualifier().toString());
                }
                Assertions.assertTrue((!files2.isEmpty() ? 1 : 0) != 0);
                Assertions.assertNotEquals(files1, files2);
                c.tableOperations().compact(MetadataTable.NAME, null, null, false, true);
                HashSet<String> files3 = new HashSet<String>();
                for (Map.Entry entry : rootScanner) {
                    files3.add(((Key)entry.getKey()).getColumnQualifier().toString());
                }
                Assertions.assertNotEquals(files2, files3);
            }
        }
    }

    @Test
    public void mergeMeta() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(MetadataIT.getClientProps()).build();){
            String[] names = this.getUniqueNames(5);
            TreeSet<Text> splits = new TreeSet<Text>();
            for (String id : "1 2 3 4 5".split(" ")) {
                splits.add(new Text(id));
            }
            c.tableOperations().addSplits(MetadataTable.NAME, splits);
            for (String tableName : names) {
                c.tableOperations().create(tableName);
            }
            c.tableOperations().merge(MetadataTable.NAME, null, null);
            try (Scanner s = c.createScanner(RootTable.NAME, Authorizations.EMPTY);){
                s.setRange(MetadataSchema.DeletesSection.getRange());
                while (s.stream().findAny().isEmpty()) {
                    UtilWaitThread.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                }
                Assertions.assertEquals((int)0, (int)c.tableOperations().listSplits(MetadataTable.NAME).size());
            }
        }
    }

    @Test
    public void batchScanTest() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(MetadataIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            try (BatchScanner s = c.createBatchScanner(MetadataTable.NAME);){
                s.setRanges(Collections.singleton(new Range()));
                Assertions.assertTrue((boolean)s.stream().anyMatch(Objects::nonNull));
            }
            s = c.createBatchScanner(RootTable.NAME);
            try {
                s.setRanges(Collections.singleton(new Range()));
                Assertions.assertTrue((boolean)s.stream().anyMatch(Objects::nonNull));
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
    }

    @Test
    public void testAmpleReadTablets() throws Exception {
        try (ClientContext cc = (ClientContext)Accumulo.newClient().from(MetadataIT.getClientProps()).build();){
            cc.securityOperations().grantTablePermission(cc.whoami(), MetadataTable.NAME, TablePermission.WRITE);
            TreeSet<Text> partitionKeys = new TreeSet<Text>();
            partitionKeys.add(new Text("a"));
            partitionKeys.add(new Text("e"));
            partitionKeys.add(new Text("j"));
            cc.tableOperations().create("t");
            cc.tableOperations().addSplits("t", partitionKeys);
            Text startRow = new Text("a");
            Text endRow = new Text("z");
            TabletsMetadata tablets = cc.getAmple().readTablets().forTable(TableId.of((String)"1")).overlapping(startRow, endRow).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.FILES, TabletMetadata.ColumnType.LOCATION, TabletMetadata.ColumnType.LAST, TabletMetadata.ColumnType.PREV_ROW}).build();
            TabletMetadata tabletMetadata0 = (TabletMetadata)tablets.stream().findFirst().orElseThrow();
            TabletMetadata tabletMetadata1 = (TabletMetadata)tablets.stream().skip(1L).findFirst().orElseThrow();
            String infoTabletId0 = tabletMetadata0.getTableId().toString();
            String infoExtent0 = tabletMetadata0.getExtent().toString();
            String infoPrevEndRow0 = tabletMetadata0.getPrevEndRow().toString();
            String infoEndRow0 = tabletMetadata0.getEndRow().toString();
            String infoTabletId1 = tabletMetadata1.getTableId().toString();
            String infoExtent1 = tabletMetadata1.getExtent().toString();
            String infoPrevEndRow1 = tabletMetadata1.getPrevEndRow().toString();
            String infoEndRow1 = tabletMetadata1.getEndRow().toString();
            String testInfoTableId = "1";
            String testInfoKeyExtent0 = "1;e;a";
            String testInfoKeyExtent1 = "1;j;e";
            String testInfoPrevEndRow0 = "a";
            String testInfoPrevEndRow1 = "e";
            String testInfoEndRow0 = "e";
            String testInfoEndRow1 = "j";
            Assertions.assertEquals((Object)infoTabletId0, (Object)testInfoTableId);
            Assertions.assertEquals((Object)infoTabletId1, (Object)testInfoTableId);
            Assertions.assertEquals((Object)infoExtent0, (Object)testInfoKeyExtent0);
            Assertions.assertEquals((Object)infoExtent1, (Object)testInfoKeyExtent1);
            Assertions.assertEquals((Object)infoPrevEndRow0, (Object)testInfoPrevEndRow0);
            Assertions.assertEquals((Object)infoPrevEndRow1, (Object)testInfoPrevEndRow1);
            Assertions.assertEquals((Object)infoEndRow0, (Object)testInfoEndRow0);
            Assertions.assertEquals((Object)infoEndRow1, (Object)testInfoEndRow1);
        }
    }

    @Test
    public void testSystemTablesInitialConfigCorrectness() throws Exception {
        try (ClientContext client = (ClientContext)Accumulo.newClient().from(MetadataIT.getClientProps()).build();){
            Map rootTableProps = client.tableOperations().getTableProperties(RootTable.NAME);
            Map metadataTableProps = client.tableOperations().getTableProperties(MetadataTable.NAME);
            this.testCommonSystemTableConfig(rootTableProps);
            Assertions.assertEquals((Object)"root", rootTableProps.get(Property.TABLE_COMPACTION_DISPATCHER_OPTS.getKey() + "service"));
            this.testCommonSystemTableConfig(metadataTableProps);
            Assertions.assertEquals((Object)"meta", metadataTableProps.get(Property.TABLE_COMPACTION_DISPATCHER_OPTS.getKey() + "service"));
        }
    }

    private void testCommonSystemTableConfig(Map<String, String> tableProps) {
        Assertions.assertTrue((boolean)tableProps.keySet().stream().allMatch(key -> key.startsWith("table.")));
        Assertions.assertEquals((Object)"5", (Object)tableProps.get(Property.TABLE_FILE_REPLICATION.getKey()));
        Assertions.assertEquals((Object)"sync", (Object)tableProps.get(Property.TABLE_DURABILITY.getKey()));
        Assertions.assertEquals((Object)"false", (Object)tableProps.get(Property.TABLE_FAILURES_IGNORE.getKey()));
        Assertions.assertEquals((Object)"", (Object)tableProps.get(Property.TABLE_DEFAULT_SCANTIME_VISIBILITY.getKey()));
        Assertions.assertEquals((Object)"tablet,server", (Object)tableProps.get(Property.TABLE_LOCALITY_GROUPS.getKey()));
        Assertions.assertEquals((Object)String.format("%s,%s", MetadataSchema.TabletsSection.TabletColumnFamily.NAME, MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME), (Object)tableProps.get(Property.TABLE_LOCALITY_GROUP_PREFIX.getKey() + "tablet"));
        Assertions.assertEquals((Object)String.format("%s,%s,%s,%s", MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, MetadataSchema.TabletsSection.LogColumnFamily.NAME, MetadataSchema.TabletsSection.ServerColumnFamily.NAME, MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME), (Object)tableProps.get(Property.TABLE_LOCALITY_GROUP_PREFIX.getKey() + "server"));
        Assertions.assertEquals((Object)("20," + MetadataBulkLoadFilter.class.getName()), (Object)tableProps.get(Property.TABLE_ITERATOR_PREFIX.getKey() + "majc.bulkLoadFilter"));
        Assertions.assertEquals((Object)SimpleCompactionDispatcher.class.getName(), (Object)tableProps.get(Property.TABLE_COMPACTION_DISPATCHER.getKey()));
        String iterClass = "10," + VersioningIterator.class.getName();
        String maxVersions = "1";
        Assertions.assertEquals((Object)iterClass, (Object)tableProps.get(Property.TABLE_ITERATOR_PREFIX.getKey() + "scan.vers"));
        Assertions.assertEquals((Object)maxVersions, (Object)tableProps.get(Property.TABLE_ITERATOR_PREFIX.getKey() + "scan.vers.opt.maxVersions"));
        Assertions.assertEquals((Object)iterClass, (Object)tableProps.get(Property.TABLE_ITERATOR_PREFIX.getKey() + "minc.vers"));
        Assertions.assertEquals((Object)maxVersions, (Object)tableProps.get(Property.TABLE_ITERATOR_PREFIX.getKey() + "minc.vers.opt.maxVersions"));
        Assertions.assertEquals((Object)iterClass, (Object)tableProps.get(Property.TABLE_ITERATOR_PREFIX.getKey() + "majc.vers"));
        Assertions.assertEquals((Object)maxVersions, (Object)tableProps.get(Property.TABLE_ITERATOR_PREFIX.getKey() + "majc.vers.opt.maxVersions"));
    }
}

