/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.manager.thrift.ManagerMonitorInfo;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Test;

public class MetadataMaxFilesIT
extends ConfigurableMacBase {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(5L);
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.TSERV_MAJC_DELAY, "1");
        cfg.setProperty(Property.TSERV_SCAN_MAX_OPENFILES, "10");
        cfg.setProperty(Property.TSERV_ASSIGNMENT_MAXCONCURRENT, "100");
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            int i;
            TreeSet<Text> splits = new TreeSet<Text>();
            for (i = 0; i < 1000; ++i) {
                splits.add(new Text(String.format("%03d", i)));
            }
            c.tableOperations().setProperty(MetadataTable.NAME, Property.TABLE_SPLIT_THRESHOLD.getKey(), "10000");
            UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
            for (i = 0; i < 2; ++i) {
                String tableName = "table" + i;
                log.info("Creating {} with splits", (Object)tableName);
                NewTableConfiguration ntc = new NewTableConfiguration().withSplits(splits);
                c.tableOperations().create(tableName, ntc);
                log.info("flushing");
                c.tableOperations().flush(MetadataTable.NAME, null, null, true);
                c.tableOperations().flush(RootTable.NAME, null, null, true);
            }
            while (true) {
                ClientContext context = (ClientContext)c;
                ManagerMonitorInfo stats = (ManagerMonitorInfo)ThriftClientTypes.MANAGER.execute(context, client -> client.getManagerStats(TraceUtil.traceInfo(), context.rpcCreds()));
                int tablets = 0;
                for (TabletServerStatus tserver : stats.tServerInfo) {
                    for (Map.Entry entry : tserver.tableMap.entrySet()) {
                        if (((String)entry.getKey()).startsWith("!") || ((String)entry.getKey()).startsWith("+")) continue;
                        tablets += ((TableInfo)entry.getValue()).onlineTablets;
                    }
                }
                log.info("Online tablets " + tablets);
                if (tablets == 2002) {
                    break;
                }
                UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
        }
    }
}

