/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MetadataSplitIT
extends ConfigurableMacBase {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(2L);
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setSiteConfig(Collections.singletonMap(Property.TSERV_MAJC_DELAY.getKey(), "100ms"));
    }

    @Test
    public void test() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            Assertions.assertEquals((int)1, (int)c.tableOperations().listSplits(MetadataTable.NAME).size());
            c.tableOperations().setProperty(MetadataTable.NAME, Property.TABLE_SPLIT_THRESHOLD.getKey(), "500");
            for (int i = 0; i < 10; ++i) {
                c.tableOperations().create("table" + i);
                c.tableOperations().flush(MetadataTable.NAME, null, null, true);
            }
            UtilWaitThread.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
            Assertions.assertTrue((c.tableOperations().listSplits(MetadataTable.NAME).size() > 2 ? 1 : 0) != 0);
        }
    }
}

