/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.harness.AccumuloITBase;
import org.apache.accumulo.tserver.NativeMap;
import org.apache.accumulo.tserver.memory.NativeMapLoader;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="SunnyDay")
public class NativeMapIT {
    private Key newKey(int r) {
        return new Key(new Text(String.format("r%09d", r)));
    }

    private Key newKey(int r, int cf, int cq, int cv, int ts, boolean deleted) {
        Key k = new Key(new Text(String.format("r%09d", r)), new Text(String.format("cf%09d", cf)), new Text(String.format("cq%09d", cq)), new Text(String.format("cv%09d", cv)), (long)ts);
        k.setDeleted(deleted);
        return k;
    }

    private Value newValue(int v) {
        return new Value((CharSequence)String.format("r%09d", v));
    }

    public static File nativeMapLocation() {
        File projectDir = new File(System.getProperty("user.dir")).getParentFile();
        return new File(projectDir, "server/native/target/accumulo-native-2.1.3/accumulo-native-2.1.3");
    }

    @BeforeAll
    public static void setUp() {
        NativeMapLoader.loadForTest(List.of(NativeMapIT.nativeMapLocation()), () -> Assertions.fail((String)"Can't load native maps"));
    }

    private void verifyIterator(int start, int end, int valueOffset, Iterator<Map.Entry<Key, Value>> iter) {
        for (int i = start; i <= end; ++i) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Map.Entry<Key, Value> entry = iter.next();
            Assertions.assertEquals((Object)this.newKey(i), (Object)entry.getKey());
            Assertions.assertEquals((Object)this.newValue(i + valueOffset), (Object)entry.getValue());
        }
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    private void insertAndVerify(NativeMap nm, int start, int end, int valueOffset) {
        int i;
        for (i = start; i <= end; ++i) {
            nm.put(this.newKey(i), this.newValue(i + valueOffset));
        }
        for (i = start; i <= end; ++i) {
            Value v = nm.get(this.newKey(i));
            Assertions.assertNotNull((Object)v);
            Assertions.assertEquals((Object)this.newValue(i + valueOffset), (Object)v);
            Iterator iter2 = nm.iterator(this.newKey(i));
            Assertions.assertTrue((boolean)iter2.hasNext());
            Map.Entry entry = (Map.Entry)iter2.next();
            Assertions.assertEquals((Object)this.newKey(i), entry.getKey());
            Assertions.assertEquals((Object)this.newValue(i + valueOffset), entry.getValue());
        }
        Assertions.assertNull((Object)nm.get(this.newKey(start - 1)));
        Assertions.assertNull((Object)nm.get(this.newKey(end + 1)));
        Iterator iter = nm.iterator();
        this.verifyIterator(start, end, valueOffset, iter);
        for (int i2 = start; i2 <= end; ++i2) {
            iter = nm.iterator(this.newKey(i2));
            this.verifyIterator(i2, end, valueOffset, iter);
            iter = nm.iterator(this.newKey(i2, 1, 1, 1, 1, false));
            this.verifyIterator(i2 + 1, end, valueOffset, iter);
        }
        Assertions.assertEquals((int)(end - start + 1), (int)nm.size());
    }

    private void insertAndVerifyExhaustive(NativeMap nm, int num, int run) {
        Value value;
        Key key;
        int l;
        int k;
        int j;
        int i;
        for (int i2 = 0; i2 < num; ++i2) {
            for (int j2 = 0; j2 < num; ++j2) {
                for (int k2 = 0; k2 < num; ++k2) {
                    for (int l2 = 0; l2 < num; ++l2) {
                        for (int ts = 0; ts < num; ++ts) {
                            Key key2 = this.newKey(i2, j2, k2, l2, ts, true);
                            Value value2 = new Value((i2 + "_" + j2 + "_" + k2 + "_" + l2 + "_" + ts + "_true_" + run).getBytes(StandardCharsets.UTF_8));
                            nm.put(key2, value2);
                            key2 = this.newKey(i2, j2, k2, l2, ts, false);
                            value2 = new Value((i2 + "_" + j2 + "_" + k2 + "_" + l2 + "_" + ts + "_false_" + run).getBytes(StandardCharsets.UTF_8));
                            nm.put(key2, value2);
                        }
                    }
                }
            }
        }
        Iterator iter = nm.iterator();
        for (i = 0; i < num; ++i) {
            for (j = 0; j < num; ++j) {
                for (k = 0; k < num; ++k) {
                    for (l = 0; l < num; ++l) {
                        for (int ts = num - 1; ts >= 0; --ts) {
                            key = this.newKey(i, j, k, l, ts, true);
                            value = new Value((i + "_" + j + "_" + k + "_" + l + "_" + ts + "_true_" + run).getBytes(StandardCharsets.UTF_8));
                            Assertions.assertTrue((boolean)iter.hasNext());
                            Map.Entry entry = (Map.Entry)iter.next();
                            Assertions.assertEquals((Object)key, entry.getKey());
                            Assertions.assertEquals((Object)value, entry.getValue());
                            key = this.newKey(i, j, k, l, ts, false);
                            value = new Value((i + "_" + j + "_" + k + "_" + l + "_" + ts + "_false_" + run).getBytes(StandardCharsets.UTF_8));
                            Assertions.assertTrue((boolean)iter.hasNext());
                            entry = (Map.Entry)iter.next();
                            Assertions.assertEquals((Object)key, entry.getKey());
                            Assertions.assertEquals((Object)value, entry.getValue());
                        }
                    }
                }
            }
        }
        Assertions.assertFalse((boolean)iter.hasNext());
        for (i = 0; i < num; ++i) {
            for (j = 0; j < num; ++j) {
                for (k = 0; k < num; ++k) {
                    for (l = 0; l < num; ++l) {
                        for (int ts = 0; ts < num; ++ts) {
                            key = this.newKey(i, j, k, l, ts, true);
                            value = new Value((i + "_" + j + "_" + k + "_" + l + "_" + ts + "_true_" + run).getBytes(StandardCharsets.UTF_8));
                            Assertions.assertEquals((Object)value, (Object)nm.get(key));
                            Iterator iter2 = nm.iterator(key);
                            Assertions.assertTrue((boolean)iter2.hasNext());
                            Map.Entry entry = (Map.Entry)iter2.next();
                            Assertions.assertEquals((Object)key, entry.getKey());
                            Assertions.assertEquals((Object)value, entry.getValue());
                            key = this.newKey(i, j, k, l, ts, false);
                            value = new Value((i + "_" + j + "_" + k + "_" + l + "_" + ts + "_false_" + run).getBytes(StandardCharsets.UTF_8));
                            Assertions.assertEquals((Object)value, (Object)nm.get(key));
                            Iterator iter3 = nm.iterator(key);
                            Assertions.assertTrue((boolean)iter3.hasNext());
                            Map.Entry entry2 = (Map.Entry)iter3.next();
                            Assertions.assertEquals((Object)key, entry2.getKey());
                            Assertions.assertEquals((Object)value, entry2.getValue());
                        }
                    }
                }
            }
        }
        Assertions.assertEquals((int)(num * num * num * num * num * 2), (int)nm.size());
    }

    @Test
    public void test1() {
        NativeMap nm = new NativeMap();
        Iterator iter = nm.iterator();
        Assertions.assertFalse((boolean)iter.hasNext());
        nm.delete();
    }

    @Test
    public void test2() {
        NativeMap nm = new NativeMap();
        this.insertAndVerify(nm, 1, 10, 0);
        this.insertAndVerify(nm, 1, 10, 1);
        this.insertAndVerify(nm, 1, 10, 2);
        nm.delete();
    }

    @Test
    public void test4() {
        NativeMap nm = new NativeMap();
        this.insertAndVerifyExhaustive(nm, 3, 0);
        this.insertAndVerifyExhaustive(nm, 3, 1);
        nm.delete();
    }

    @Test
    public void test5() {
        NativeMap nm = new NativeMap();
        this.insertAndVerify(nm, 1, 10, 0);
        Iterator iter = nm.iterator();
        iter.next();
        nm.delete();
        Key key1 = this.newKey(1);
        Value value1 = this.newValue(1);
        Assertions.assertThrows(IllegalStateException.class, () -> nm.put(key1, value1));
        Assertions.assertThrows(IllegalStateException.class, () -> nm.get(key1));
        Assertions.assertThrows(IllegalStateException.class, () -> nm.iterator(key1));
        Assertions.assertThrows(IllegalStateException.class, () -> ((NativeMap)nm).iterator());
        Assertions.assertThrows(IllegalStateException.class, () -> ((NativeMap)nm).size());
        Assertions.assertThrows(IllegalStateException.class, iter::next);
    }

    @Test
    public void test7() {
        NativeMap nm = new NativeMap();
        this.insertAndVerify(nm, 1, 10, 0);
        nm.delete();
        Assertions.assertThrows(IllegalStateException.class, () -> ((NativeMap)nm).delete());
    }

    @Test
    public void test8() {
        NativeMap nm = new NativeMap();
        TreeMap<Key, Value> tm = new TreeMap<Key, Value>();
        tm.put(new Key(new Text("fo")), new Value(new byte[]{48}));
        tm.put(new Key(new Text("foo")), new Value(new byte[]{49}));
        tm.put(new Key(new Text("foo1")), new Value(new byte[]{50}));
        tm.put(new Key(new Text("foo2")), new Value(new byte[]{51}));
        for (Map.Entry entry : tm.entrySet()) {
            nm.put((Key)entry.getKey(), (Value)entry.getValue());
        }
        Iterator iter = nm.iterator();
        for (Map.Entry entry : tm.entrySet()) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Map.Entry entry2 = (Map.Entry)iter.next();
            Assertions.assertEquals(entry.getKey(), entry2.getKey());
            Assertions.assertEquals(entry.getValue(), entry2.getValue());
        }
        Assertions.assertFalse((boolean)iter.hasNext());
        nm.delete();
    }

    @Test
    public void test9() {
        NativeMap nm = new NativeMap();
        Iterator iter = nm.iterator();
        Assertions.assertThrows(NoSuchElementException.class, iter::next);
        this.insertAndVerify(nm, 1, 1, 0);
        iter = nm.iterator();
        iter.next();
        Assertions.assertThrows(NoSuchElementException.class, iter::next);
        nm.delete();
    }

    @Test
    public void test10() {
        int start = 1;
        int end = 10000;
        NativeMap nm = new NativeMap();
        for (int i = start; i <= end; ++i) {
            nm.put(this.newKey(i), this.newValue(i));
        }
        long mem1 = nm.getMemoryUsed();
        for (int i = start; i <= end; ++i) {
            nm.put(this.newKey(i), this.newValue(i));
        }
        long mem2 = nm.getMemoryUsed();
        if (mem1 != mem2) {
            throw new RuntimeException("Memory changed after inserting duplicate data " + mem1 + " " + mem2);
        }
        for (int i = start; i <= end; ++i) {
            nm.put(this.newKey(i), this.newValue(i));
        }
        long mem3 = nm.getMemoryUsed();
        if (mem1 != mem3) {
            throw new RuntimeException("Memory changed after inserting duplicate data " + mem1 + " " + mem3);
        }
        byte[] bigrow = new byte[1000000];
        byte[] bigvalue = new byte[bigrow.length];
        for (int i = 0; i < bigrow.length; ++i) {
            bigrow[i] = (byte)(0xFF & i % 256);
            bigvalue[i] = bigrow[i];
        }
        nm.put(new Key(new Text(bigrow)), new Value(bigvalue));
        long mem4 = nm.getMemoryUsed();
        Value val = nm.get(new Key(new Text(bigrow)));
        if (val == null || !val.equals((Object)new Value(bigvalue))) {
            throw new RuntimeException("Did not get expected big value");
        }
        nm.put(new Key(new Text(bigrow)), new Value(bigvalue));
        long mem5 = nm.getMemoryUsed();
        if (mem4 != mem5) {
            throw new RuntimeException("Memory changed after inserting duplicate data " + mem4 + " " + mem5);
        }
        val = nm.get(new Key(new Text(bigrow)));
        if (val == null || !val.equals((Object)new Value(bigvalue))) {
            throw new RuntimeException("Did not get expected big value");
        }
        nm.delete();
    }

    private static byte[] getRandomBytes(int maxLen) {
        int len = AccumuloITBase.random.nextInt(maxLen);
        byte[] f = new byte[len];
        AccumuloITBase.random.nextBytes(f);
        return f;
    }

    @Test
    public void test11() {
        NativeMap nm = new NativeMap();
        ArrayList<Pair> testData = new ArrayList<Pair>();
        for (int i = 0; i < 100000; ++i) {
            Key k = new Key(NativeMapIT.getRandomBytes(97), NativeMapIT.getRandomBytes(13), NativeMapIT.getRandomBytes(31), NativeMapIT.getRandomBytes(11), AccumuloITBase.random.nextLong() & Long.MAX_VALUE, false, false);
            Value v = new Value(NativeMapIT.getRandomBytes(511));
            testData.add(new Pair((Object)k, (Object)v));
        }
        for (Pair pair : testData) {
            nm.put((Key)pair.getFirst(), (Value)pair.getSecond());
        }
        for (int i = 0; i < 2; ++i) {
            testData.sort(Comparator.comparing(Pair::getFirst));
            Iterator iter1 = nm.iterator();
            Iterator iter2 = testData.iterator();
            while (iter1.hasNext() && iter2.hasNext()) {
                Map.Entry e = (Map.Entry)iter1.next();
                Pair p = (Pair)iter2.next();
                if (!((Key)e.getKey()).equals(p.getFirst())) {
                    throw new RuntimeException("Keys not equal");
                }
                if (((Value)e.getValue()).equals(p.getSecond())) continue;
                throw new RuntimeException("Values not equal");
            }
            if (iter1.hasNext()) {
                throw new RuntimeException("Not all of native map consumed");
            }
            if (iter2.hasNext()) {
                throw new RuntimeException("Not all of test data consumed");
            }
            System.out.println("test 11 nm mem " + nm.getMemoryUsed());
            Collections.shuffle(testData, AccumuloITBase.random);
            for (Pair pair : testData) {
                ((Value)pair.getSecond()).set(NativeMapIT.getRandomBytes(511));
                nm.put((Key)pair.getFirst(), (Value)pair.getSecond());
            }
        }
        nm.delete();
    }

    @Test
    public void testBinary() {
        Value v;
        Key k;
        byte[] data;
        byte[] row;
        int i;
        NativeMap nm = new NativeMap();
        byte[] emptyBytes = new byte[]{};
        for (int i2 = 0; i2 < 256; ++i2) {
            for (int j = 0; j < 256; ++j) {
                byte[] row2 = new byte[]{114, (byte)(0xFF & i2), (byte)(0xFF & j)};
                byte[] data2 = new byte[]{118, (byte)(0xFF & i2), (byte)(0xFF & j)};
                Key k2 = new Key(row2, emptyBytes, emptyBytes, emptyBytes, 1L);
                Value v2 = new Value(data2);
                nm.put(k2, v2);
            }
        }
        Iterator iter = nm.iterator();
        for (i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                row = new byte[]{114, (byte)(0xFF & i), (byte)(0xFF & j)};
                data = new byte[]{118, (byte)(0xFF & i), (byte)(0xFF & j)};
                k = new Key(row, emptyBytes, emptyBytes, emptyBytes, 1L);
                v = new Value(data);
                Assertions.assertTrue((boolean)iter.hasNext());
                Map.Entry entry = (Map.Entry)iter.next();
                Assertions.assertEquals((Object)k, entry.getKey());
                Assertions.assertEquals((Object)v, entry.getValue());
            }
        }
        Assertions.assertFalse((boolean)iter.hasNext());
        for (i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                row = new byte[]{114, (byte)(0xFF & i), (byte)(0xFF & j)};
                data = new byte[]{118, (byte)(0xFF & i), (byte)(0xFF & j)};
                k = new Key(row, emptyBytes, emptyBytes, emptyBytes, 1L);
                v = new Value(data);
                Value v2 = nm.get(k);
                Assertions.assertEquals((Object)v, (Object)v2);
            }
        }
        nm.delete();
    }

    @Test
    public void testEmpty() {
        NativeMap nm = new NativeMap();
        Assertions.assertEquals((int)0, (int)nm.size());
        Assertions.assertEquals((long)0L, (long)nm.getMemoryUsed());
        nm.delete();
    }

    @Test
    public void testConcurrentIter() throws IOException {
        NativeMap nm = new NativeMap();
        nm.put(this.newKey(0), this.newValue(0));
        nm.put(this.newKey(1), this.newValue(1));
        nm.put(this.newKey(3), this.newValue(3));
        SortedKeyValueIterator iter = nm.skvIterator();
        nm.put(this.newKey(2), this.newValue(2));
        Assertions.assertTrue((boolean)iter.hasTop());
        Assertions.assertEquals((Object)iter.getTopKey(), (Object)this.newKey(0));
        iter.next();
        Assertions.assertTrue((boolean)iter.hasTop());
        Assertions.assertEquals((Object)iter.getTopKey(), (Object)this.newKey(1));
        iter.next();
        Assertions.assertTrue((boolean)iter.hasTop());
        Assertions.assertEquals((Object)iter.getTopKey(), (Object)this.newKey(2));
        iter.next();
        Assertions.assertTrue((boolean)iter.hasTop());
        Assertions.assertEquals((Object)iter.getTopKey(), (Object)this.newKey(3));
        iter.next();
        Assertions.assertFalse((boolean)iter.hasTop());
        nm.delete();
    }
}

