/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.accumulo.cluster.standalone.StandaloneAccumuloCluster;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.admin.CloneConfiguration;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.OfflineScanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.file.rfile.PrintInfo;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.spi.crypto.AESCryptoService;
import org.apache.accumulo.core.spi.crypto.GenericCryptoServiceFactory;
import org.apache.accumulo.core.spi.crypto.PerTableCryptoServiceFactory;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.log.WalStateManager;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.accumulo.test.functional.WALSunnyDayIT;
import org.apache.accumulo.tserver.logger.LogReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerTableCryptoIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(PerTableCryptoIT.class);
    private final String NO_ENCRYPT_STRING = "No on disk encryption detected";
    private final String ENCRYPTED_STRING = "Encrypted with Params:";

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        String keyPath = System.getProperty("user.dir") + "/target/mini-tests/PerTableCrypto-testkeyfile";
        cfg.setProperty(Property.INSTANCE_CRYPTO_FACTORY, PerTableCryptoServiceFactory.class.getName());
        cfg.setProperty(PerTableCryptoServiceFactory.WAL_NAME_PROP, AESCryptoService.class.getName());
        cfg.setProperty(GenericCryptoServiceFactory.GENERAL_SERVICE_NAME_PROP, AESCryptoService.class.getName());
        cfg.setProperty(PerTableCryptoServiceFactory.RECOVERY_NAME_PROP, AESCryptoService.class.getName());
        cfg.setProperty("general.custom.crypto.key.uri", keyPath);
        try {
            Path keyFile = new Path(keyPath);
            LocalFileSystem fs = FileSystem.getLocal((Configuration)new Configuration());
            fs.delete(keyFile, true);
            if (fs.createNewFile(keyFile)) {
                log.info("Created keyfile at {}", (Object)keyPath);
            } else {
                log.error("Failed to create key file at {}", (Object)keyPath);
            }
            try (FSDataOutputStream out = fs.create(keyFile);){
                out.writeUTF("sixteenbytekey");
            }
        }
        catch (Exception e) {
            log.error("Exception during configure", (Throwable)e);
        }
    }

    @Test
    public void testMultipleTablesAndWALs() throws Exception {
        TableId tableId2;
        TableId tableId1;
        String[] tables = this.getUniqueNames(3);
        HashMap<String, String> props = new HashMap<String, String>();
        NewTableConfiguration tableConfig = new NewTableConfiguration();
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(PerTableCryptoIT.getClientProps()).build();){
            c.tableOperations().create(tables[0]);
            TableId tableId0 = TableId.of((String)((String)c.tableOperations().tableIdMap().get(tables[0])));
            VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(PerTableCryptoIT.getClientProps(), tables[0]);
            TestIngest.ingest(c, params);
            this.checkWALEncryption();
            VerifyIngest.verifyIngest(c, params);
            this.checkTableEncryption(tableId0, false);
            props.put(PerTableCryptoServiceFactory.TABLE_SERVICE_NAME_PROP, AESCryptoService.class.getName());
            tableConfig.setProperties(props);
            c.tableOperations().create(tables[1], tableConfig);
            params = new VerifyIngest.VerifyParams(PerTableCryptoIT.getClientProps(), tables[1]);
            TestIngest.ingest(c, params);
            VerifyIngest.verifyIngest(c, params);
            CloneConfiguration cloneConfig = CloneConfiguration.builder().setFlush(true).build();
            c.tableOperations().clone(tables[1], tables[2], cloneConfig);
            c.tableOperations().compact(tables[2], new CompactionConfig());
            params = new VerifyIngest.VerifyParams(PerTableCryptoIT.getClientProps(), tables[2]);
            VerifyIngest.verifyIngest(c, params);
            tableId1 = TableId.of((String)((String)c.tableOperations().tableIdMap().get(tables[1])));
            tableId2 = TableId.of((String)((String)c.tableOperations().tableIdMap().get(tables[2])));
        }
        this.checkTableEncryption(tableId1, true);
        this.checkTableEncryption(tableId2, true);
    }

    @Test
    public void testOfflineIterator() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(PerTableCryptoIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            HashMap<String, String> props = new HashMap<String, String>();
            NewTableConfiguration tableConfig = new NewTableConfiguration();
            props.put(PerTableCryptoServiceFactory.TABLE_SERVICE_NAME_PROP, AESCryptoService.class.getName());
            tableConfig.setProperties(props);
            c.tableOperations().create(tableName, tableConfig);
            VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(PerTableCryptoIT.getClientProps(), tableName);
            TestIngest.ingest(c, params);
            VerifyIngest.verifyIngest(c, params);
            TableId tableId = TableId.of((String)((String)c.tableOperations().tableIdMap().get(tableName)));
            c.tableOperations().offline(tableName, true);
            try (OfflineScanner oScanner = new OfflineScanner((ClientContext)c, tableId, Authorizations.EMPTY);){
                long count = oScanner.stream().count();
                Assertions.assertEquals((long)count, (long)100000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTableEncryption(TableId tableId, boolean expectEncrypt) throws Exception {
        try (TabletsMetadata tm = PerTableCryptoIT.getServerContext().getAmple().readTablets().forTable(tableId).build();){
            for (TabletMetadata tabletMetadata : tm) {
                for (StoredTabletFile f : tabletMetadata.getFiles()) {
                    if (!PerTableCryptoIT.getFileSystem().exists(f.getPath())) continue;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    PrintStream oldOut = System.out;
                    try (PrintStream newOut = new PrintStream(baos);){
                        System.setOut(newOut);
                        ArrayList<Object> args = new ArrayList<Object>();
                        args.add(f.getPathStr());
                        args.add("--props");
                        args.add(PerTableCryptoIT.getCluster().getAccumuloPropertiesPath());
                        if (PerTableCryptoIT.getClusterType() == AccumuloClusterHarness.ClusterType.STANDALONE && PerTableCryptoIT.saslEnabled()) {
                            args.add("--config");
                            StandaloneAccumuloCluster sac = (StandaloneAccumuloCluster)cluster;
                            String hadoopConfDir = sac.getHadoopConfDir();
                            args.add(new Path(hadoopConfDir, "core-site.xml").toString());
                            args.add(new Path(hadoopConfDir, "hdfs-site.xml").toString());
                        }
                        args.add("-o");
                        args.add(PerTableCryptoServiceFactory.TABLE_SERVICE_NAME_PROP + "=" + AESCryptoService.class.getName());
                        args.add("-o");
                        args.add(Property.INSTANCE_CRYPTO_FACTORY + "=" + GenericCryptoServiceFactory.class.getName());
                        log.info("Invoking PrintInfo with {}", args);
                        PrintInfo.main((String[])args.toArray(new String[0]));
                        newOut.flush();
                        String stdout = baos.toString();
                        if (expectEncrypt) {
                            Assertions.assertTrue((boolean)stdout.contains("Encrypted with Params:"));
                            continue;
                        }
                        Assertions.assertTrue((boolean)stdout.contains("No on disk encryption detected"));
                    }
                    finally {
                        System.setOut(oldOut);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkWALEncryption() throws Exception {
        HashSet<String> walsSeen = new HashSet<String>();
        int open = 0;
        int attempts = 0;
        boolean foundWal = false;
        while (open == 0) {
            ++attempts;
            Map<String, WalStateManager.WalState> wals = WALSunnyDayIT._getWals(PerTableCryptoIT.getServerContext());
            for (Map.Entry<String, WalStateManager.WalState> entry : wals.entrySet()) {
                if (entry.getValue() == WalStateManager.WalState.OPEN) {
                    ++open;
                    walsSeen.add(entry.getKey());
                    foundWal = true;
                    continue;
                }
                log.debug("The WalState for {} is {}", (Object)entry.getKey(), (Object)entry.getValue());
            }
            if (foundWal) continue;
            Thread.sleep(50L);
            if (attempts % 50 != 0) continue;
            log.debug("No open WALs found in {} attempts.", (Object)attempts);
        }
        Assertions.assertFalse((boolean)walsSeen.isEmpty(), (String)"Did not see any WALs");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream oldOut = System.out;
        try (PrintStream newOut = new PrintStream(baos);){
            System.setOut(newOut);
            ArrayList<String> args = new ArrayList<String>(walsSeen);
            args.add("-p");
            args.add(PerTableCryptoIT.getCluster().getAccumuloPropertiesPath());
            args.add("-e");
            new LogReader().execute(args.toArray(new String[0]));
            newOut.flush();
            String stdout = baos.toString();
            Assertions.assertTrue((boolean)stdout.contains(AESCryptoService.class.getName()));
        }
        finally {
            System.setOut(oldOut);
        }
    }
}

