/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="MiniClusterOnly")
public class PermissionsIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(PermissionsIT.class);

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofSeconds(90L);
    }

    @BeforeEach
    public void limitToMini() throws Exception {
        Assumptions.assumeTrue((PermissionsIT.getClusterType() == AccumuloClusterHarness.ClusterType.MINI ? 1 : 0) != 0);
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(PermissionsIT.getClientProps()).build();){
            Set users = c.securityOperations().listLocalUsers();
            ClusterUser user = this.getUser(0);
            if (users.contains(user.getPrincipal())) {
                c.securityOperations().dropLocalUser(user.getPrincipal());
            }
        }
    }

    private void loginAs(ClusterUser user) throws IOException {
        user.getToken();
    }

    @Test
    public void systemPermissionsTest() throws Exception {
        ClusterUser testUser = this.getUser(0);
        ClusterUser rootUser = this.getAdminUser();
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(PermissionsIT.getClientProps()).build();){
            this.verifyHasOnlyTheseSystemPermissions(c, c.whoami(), SystemPermission.values());
            String principal = testUser.getPrincipal();
            AuthenticationToken token = testUser.getToken();
            PasswordToken passwordToken = null;
            if (token instanceof PasswordToken) {
                passwordToken = (PasswordToken)token;
            }
            this.loginAs(rootUser);
            c.securityOperations().createLocalUser(principal, passwordToken);
            this.loginAs(testUser);
            try (AccumuloClient test_user_client = (AccumuloClient)Accumulo.newClient().from(c.properties()).as((CharSequence)principal, token).build();){
                this.loginAs(rootUser);
                this.verifyHasNoSystemPermissions(c, principal, SystemPermission.values());
                for (SystemPermission perm : SystemPermission.values()) {
                    log.debug("Verifying the {} permission", (Object)perm);
                    String tableNamePrefix = this.getUniqueNames(1)[0];
                    Thread.sleep(1000L);
                    this.testMissingSystemPermission(tableNamePrefix, c, rootUser, test_user_client, testUser, perm);
                    this.loginAs(rootUser);
                    c.securityOperations().grantSystemPermission(principal, perm);
                    this.verifyHasOnlyTheseSystemPermissions(c, principal, perm);
                    this.testGrantedSystemPermission(tableNamePrefix, c, rootUser, test_user_client, testUser, perm);
                    this.loginAs(rootUser);
                    c.securityOperations().revokeSystemPermission(principal, perm);
                    this.verifyHasNoSystemPermissions(c, principal, perm);
                }
            }
        }
    }

    static Map<String, String> map(Iterable<Map.Entry<String, String>> i) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> e : i) {
            result.put(e.getKey(), e.getValue());
        }
        return result;
    }

    private void testMissingSystemPermission(String tableNamePrefix, AccumuloClient root_client, ClusterUser rootUser, AccumuloClient test_user_client, ClusterUser testUser, SystemPermission perm) throws Exception {
        String password = "password";
        boolean passwordBased = testUser.getPassword() != null;
        log.debug("Confirming that the lack of the {} permission properly restricts the user", (Object)perm);
        switch (perm) {
            case CREATE_TABLE: {
                String tableName = tableNamePrefix + "__CREATE_TABLE_WITHOUT_PERM_TEST__";
                try {
                    this.loginAs(testUser);
                    test_user_client.tableOperations().create(tableName);
                    throw new IllegalStateException("Should NOT be able to create a table");
                }
                catch (AccumuloSecurityException e) {
                    this.loginAs(rootUser);
                    if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED && !root_client.tableOperations().list().contains(tableName)) break;
                    throw e;
                }
            }
            case DROP_TABLE: {
                String tableName = tableNamePrefix + "__DROP_TABLE_WITHOUT_PERM_TEST__";
                this.loginAs(rootUser);
                root_client.tableOperations().create(tableName);
                try {
                    this.loginAs(testUser);
                    test_user_client.tableOperations().delete(tableName);
                    throw new IllegalStateException("Should NOT be able to delete a table");
                }
                catch (AccumuloSecurityException e) {
                    this.loginAs(rootUser);
                    if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED && root_client.tableOperations().list().contains(tableName)) break;
                    throw e;
                }
            }
            case ALTER_TABLE: {
                String tableName = tableNamePrefix + "__ALTER_TABLE_WITHOUT_PERM_TEST__";
                this.loginAs(rootUser);
                root_client.tableOperations().create(tableName);
                try {
                    this.loginAs(testUser);
                    test_user_client.tableOperations().setProperty(tableName, Property.TABLE_BLOOM_ERRORRATE.getKey(), "003.14159%");
                    throw new IllegalStateException("Should NOT be able to set a table property");
                }
                catch (AccumuloSecurityException e) {
                    this.loginAs(rootUser);
                    if (e.getSecurityErrorCode() != SecurityErrorCode.PERMISSION_DENIED || ((String)root_client.tableOperations().getConfiguration(tableName).get(Property.TABLE_BLOOM_ERRORRATE.getKey())).equals("003.14159%")) {
                        throw e;
                    }
                    try {
                        this.loginAs(testUser);
                        test_user_client.tableOperations().modifyProperties(tableName, properties -> properties.put(Property.TABLE_BLOOM_ERRORRATE.getKey(), "003.14159%"));
                        throw new IllegalStateException("Should NOT be able to set a table property");
                    }
                    catch (AccumuloSecurityException e2) {
                        this.loginAs(rootUser);
                        if (e2.getSecurityErrorCode() != SecurityErrorCode.PERMISSION_DENIED || ((String)root_client.tableOperations().getConfiguration(tableName).get(Property.TABLE_BLOOM_ERRORRATE.getKey())).equals("003.14159%")) {
                            throw e2;
                        }
                        this.loginAs(rootUser);
                        root_client.tableOperations().setProperty(tableName, Property.TABLE_BLOOM_ERRORRATE.getKey(), "003.14159%");
                        root_client.tableOperations().modifyProperties(tableName, properties -> properties.put(Property.TABLE_BLOOM_SIZE.getKey(), "2048576"));
                        try {
                            this.loginAs(testUser);
                            test_user_client.tableOperations().removeProperty(tableName, Property.TABLE_BLOOM_ERRORRATE.getKey());
                            throw new IllegalStateException("Should NOT be able to remove a table property");
                        }
                        catch (AccumuloSecurityException e3) {
                            this.loginAs(rootUser);
                            if (e3.getSecurityErrorCode() != SecurityErrorCode.PERMISSION_DENIED || !((String)root_client.tableOperations().getConfiguration(tableName).get(Property.TABLE_BLOOM_ERRORRATE.getKey())).equals("003.14159%")) {
                                throw e3;
                            }
                            String table2 = tableName + "2";
                            try {
                                this.loginAs(testUser);
                                test_user_client.tableOperations().rename(tableName, table2);
                                throw new IllegalStateException("Should NOT be able to rename a table");
                            }
                            catch (AccumuloSecurityException e4) {
                                this.loginAs(rootUser);
                                if (e4.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED && root_client.tableOperations().list().contains(tableName) && !root_client.tableOperations().list().contains(table2)) break;
                                throw e4;
                            }
                        }
                    }
                }
            }
            case CREATE_USER: {
                String user = "__CREATE_USER_WITHOUT_PERM_TEST__";
                try {
                    this.loginAs(testUser);
                    test_user_client.securityOperations().createLocalUser(user, passwordBased ? new PasswordToken((CharSequence)password) : null);
                    throw new IllegalStateException("Should NOT be able to create a user");
                }
                catch (AccumuloSecurityException e) {
                    AuthenticationToken userToken = testUser.getToken();
                    this.loginAs(rootUser);
                    if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED && (!(userToken instanceof PasswordToken) || !root_client.securityOperations().authenticateUser(user, userToken))) break;
                    throw e;
                }
            }
            case DROP_USER: {
                String user = "__DROP_USER_WITHOUT_PERM_TEST__";
                this.loginAs(rootUser);
                root_client.securityOperations().createLocalUser(user, passwordBased ? new PasswordToken((CharSequence)password) : null);
                try {
                    this.loginAs(testUser);
                    test_user_client.securityOperations().dropLocalUser(user);
                    throw new IllegalStateException("Should NOT be able to delete a user");
                }
                catch (AccumuloSecurityException e) {
                    this.loginAs(rootUser);
                    if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED && root_client.securityOperations().listLocalUsers().contains(user)) break;
                    log.info("Failed to authenticate as {}", (Object)user);
                    throw e;
                }
            }
            case ALTER_USER: {
                String user = "__ALTER_USER_WITHOUT_PERM_TEST__";
                this.loginAs(rootUser);
                root_client.securityOperations().createLocalUser(user, passwordBased ? new PasswordToken((CharSequence)password) : null);
                try {
                    this.loginAs(testUser);
                    test_user_client.securityOperations().changeUserAuthorizations(user, new Authorizations(new String[]{"A", "B"}));
                    throw new IllegalStateException("Should NOT be able to alter a user");
                }
                catch (AccumuloSecurityException e) {
                    this.loginAs(rootUser);
                    if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED && root_client.securityOperations().getUserAuthorizations(user).isEmpty()) break;
                    throw e;
                }
            }
            case SYSTEM: {
                try {
                    this.loginAs(testUser);
                    test_user_client.instanceOperations().setProperty(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX.getKey(), "10000");
                    throw new IllegalStateException("Should NOT be able to set System Property");
                }
                catch (AccumuloSecurityException e) {
                    this.loginAs(rootUser);
                    if (e.getSecurityErrorCode() != SecurityErrorCode.PERMISSION_DENIED || ((String)root_client.instanceOperations().getSystemConfiguration().get(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX.getKey())).equals("10000")) {
                        throw e;
                    }
                    this.loginAs(rootUser);
                    root_client.instanceOperations().setProperty(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX.getKey(), "10000");
                    try {
                        this.loginAs(testUser);
                        test_user_client.instanceOperations().removeProperty(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX.getKey());
                        throw new IllegalStateException("Should NOT be able to remove System Property");
                    }
                    catch (AccumuloSecurityException e5) {
                        this.loginAs(rootUser);
                        if (e5.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED && ((String)root_client.instanceOperations().getSystemConfiguration().get(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX.getKey())).equals("10000")) break;
                        throw e5;
                    }
                }
            }
            case CREATE_NAMESPACE: {
                String namespace = "__CREATE_NAMESPACE_WITHOUT_PERM_TEST__";
                try {
                    this.loginAs(testUser);
                    test_user_client.namespaceOperations().create(namespace);
                    throw new IllegalStateException("Should NOT be able to create a namespace");
                }
                catch (AccumuloSecurityException e) {
                    this.loginAs(rootUser);
                    if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED && !root_client.namespaceOperations().list().contains(namespace)) break;
                    throw e;
                }
            }
            case DROP_NAMESPACE: {
                String namespace = "__DROP_NAMESPACE_WITHOUT_PERM_TEST__";
                this.loginAs(rootUser);
                root_client.namespaceOperations().create(namespace);
                try {
                    this.loginAs(testUser);
                    test_user_client.namespaceOperations().delete(namespace);
                    throw new IllegalStateException("Should NOT be able to delete a namespace");
                }
                catch (AccumuloSecurityException e) {
                    this.loginAs(rootUser);
                    if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED && root_client.namespaceOperations().list().contains(namespace)) break;
                    throw e;
                }
            }
            case ALTER_NAMESPACE: {
                String namespace = "__ALTER_NAMESPACE_WITHOUT_PERM_TEST__";
                this.loginAs(rootUser);
                root_client.namespaceOperations().create(namespace);
                try {
                    this.loginAs(testUser);
                    test_user_client.namespaceOperations().setProperty(namespace, Property.TABLE_BLOOM_ERRORRATE.getKey(), "003.14159%");
                    throw new IllegalStateException("Should NOT be able to set a namespace property");
                }
                catch (AccumuloSecurityException e) {
                    this.loginAs(rootUser);
                    if (e.getSecurityErrorCode() != SecurityErrorCode.PERMISSION_DENIED || ((String)root_client.namespaceOperations().getConfiguration(namespace).get(Property.TABLE_BLOOM_ERRORRATE.getKey())).equals("003.14159%")) {
                        throw e;
                    }
                    try {
                        this.loginAs(testUser);
                        test_user_client.namespaceOperations().modifyProperties(namespace, properties -> properties.put(Property.TABLE_BLOOM_ERRORRATE.getKey(), "003.14159%"));
                        throw new IllegalStateException("Should NOT be able to set a namespace property");
                    }
                    catch (AccumuloSecurityException e6) {
                        this.loginAs(rootUser);
                        if (e6.getSecurityErrorCode() != SecurityErrorCode.PERMISSION_DENIED || ((String)root_client.namespaceOperations().getConfiguration(namespace).get(Property.TABLE_BLOOM_ERRORRATE.getKey())).equals("003.14159%")) {
                            throw e6;
                        }
                        this.loginAs(rootUser);
                        root_client.namespaceOperations().setProperty(namespace, Property.TABLE_BLOOM_ERRORRATE.getKey(), "003.14159%");
                        root_client.namespaceOperations().modifyProperties(namespace, properties -> properties.put(Property.TABLE_BLOOM_SIZE.getKey(), "2048576"));
                        try {
                            this.loginAs(testUser);
                            test_user_client.namespaceOperations().removeProperty(namespace, Property.TABLE_BLOOM_ERRORRATE.getKey());
                            throw new IllegalStateException("Should NOT be able to remove a namespace property");
                        }
                        catch (AccumuloSecurityException e7) {
                            this.loginAs(rootUser);
                            if (e7.getSecurityErrorCode() != SecurityErrorCode.PERMISSION_DENIED || !((String)root_client.namespaceOperations().getConfiguration(namespace).get(Property.TABLE_BLOOM_ERRORRATE.getKey())).equals("003.14159%")) {
                                throw e7;
                            }
                            String namespace2 = namespace + "2";
                            try {
                                this.loginAs(testUser);
                                test_user_client.namespaceOperations().rename(namespace, namespace2);
                                throw new IllegalStateException("Should NOT be able to rename a namespace");
                            }
                            catch (AccumuloSecurityException e8) {
                                this.loginAs(rootUser);
                                if (e8.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED && root_client.namespaceOperations().list().contains(namespace) && !root_client.namespaceOperations().list().contains(namespace2)) break;
                                throw e8;
                            }
                        }
                    }
                }
            }
            case OBTAIN_DELEGATION_TOKEN: {
                if (!PermissionsIT.saslEnabled()) break;
                break;
            }
            case GRANT: {
                this.loginAs(testUser);
                try {
                    test_user_client.securityOperations().grantSystemPermission(testUser.getPrincipal(), SystemPermission.GRANT);
                    throw new IllegalStateException("Should NOT be able to grant System.GRANT to yourself");
                }
                catch (AccumuloSecurityException e) {
                    this.loginAs(rootUser);
                    Assertions.assertFalse((boolean)root_client.securityOperations().hasSystemPermission(testUser.getPrincipal(), SystemPermission.GRANT));
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("Unrecognized System Permission: " + perm);
            }
        }
    }

    private void testGrantedSystemPermission(String tableNamePrefix, AccumuloClient root_client, ClusterUser rootUser, AccumuloClient test_user_client, ClusterUser testUser, SystemPermission perm) throws Exception {
        String password = "password";
        boolean passwordBased = testUser.getPassword() != null;
        log.debug("Confirming that the presence of the {} permission properly permits the user", (Object)perm);
        switch (perm) {
            case CREATE_TABLE: {
                String tableName = tableNamePrefix + "__CREATE_TABLE_WITH_PERM_TEST__";
                this.loginAs(testUser);
                test_user_client.tableOperations().create(tableName);
                this.loginAs(rootUser);
                if (root_client.tableOperations().list().contains(tableName)) break;
                throw new IllegalStateException("Should be able to create a table");
            }
            case DROP_TABLE: {
                String tableName = tableNamePrefix + "__DROP_TABLE_WITH_PERM_TEST__";
                this.loginAs(rootUser);
                root_client.tableOperations().create(tableName);
                this.loginAs(testUser);
                test_user_client.tableOperations().delete(tableName);
                this.loginAs(rootUser);
                if (!root_client.tableOperations().list().contains(tableName)) break;
                throw new IllegalStateException("Should be able to delete a table");
            }
            case ALTER_TABLE: {
                String tableName = tableNamePrefix + "__ALTER_TABLE_WITH_PERM_TEST__";
                String table2 = tableName + "2";
                this.loginAs(rootUser);
                root_client.tableOperations().create(tableName);
                this.testArbitraryProperty(root_client, tableName, true);
                this.loginAs(testUser);
                test_user_client.tableOperations().setProperty(tableName, Property.TABLE_BLOOM_ERRORRATE.getKey(), "003.14159%");
                this.loginAs(rootUser);
                Map properties = root_client.tableOperations().getConfiguration(tableName);
                if (!((String)properties.get(Property.TABLE_BLOOM_ERRORRATE.getKey())).equals("003.14159%")) {
                    throw new IllegalStateException("Should be able to set a table property");
                }
                this.loginAs(testUser);
                test_user_client.tableOperations().removeProperty(tableName, Property.TABLE_BLOOM_ERRORRATE.getKey());
                this.loginAs(rootUser);
                properties = root_client.tableOperations().getConfiguration(tableName);
                if (((String)properties.get(Property.TABLE_BLOOM_ERRORRATE.getKey())).equals("003.14159%")) {
                    throw new IllegalStateException("Should be able to remove a table property");
                }
                this.loginAs(testUser);
                test_user_client.tableOperations().rename(tableName, table2);
                this.loginAs(rootUser);
                if (!root_client.tableOperations().list().contains(tableName) && root_client.tableOperations().list().contains(table2)) break;
                throw new IllegalStateException("Should be able to rename a table");
            }
            case CREATE_USER: {
                String user = "__CREATE_USER_WITH_PERM_TEST__";
                this.loginAs(testUser);
                test_user_client.securityOperations().createLocalUser(user, passwordBased ? new PasswordToken((CharSequence)password) : null);
                this.loginAs(rootUser);
                if (!passwordBased || root_client.securityOperations().authenticateUser(user, (AuthenticationToken)new PasswordToken((CharSequence)password))) break;
                throw new IllegalStateException("Should be able to create a user");
            }
            case DROP_USER: {
                String user = "__DROP_USER_WITH_PERM_TEST__";
                this.loginAs(rootUser);
                root_client.securityOperations().createLocalUser(user, passwordBased ? new PasswordToken((CharSequence)password) : null);
                this.loginAs(testUser);
                test_user_client.securityOperations().dropLocalUser(user);
                this.loginAs(rootUser);
                if (!passwordBased || !root_client.securityOperations().authenticateUser(user, (AuthenticationToken)new PasswordToken((CharSequence)password))) break;
                throw new IllegalStateException("Should be able to delete a user");
            }
            case ALTER_USER: {
                String user = "__ALTER_USER_WITH_PERM_TEST__";
                this.loginAs(rootUser);
                root_client.securityOperations().createLocalUser(user, passwordBased ? new PasswordToken((CharSequence)password) : null);
                this.loginAs(testUser);
                test_user_client.securityOperations().changeUserAuthorizations(user, new Authorizations(new String[]{"A", "B"}));
                this.loginAs(rootUser);
                if (!root_client.securityOperations().getUserAuthorizations(user).isEmpty()) break;
                throw new IllegalStateException("Should be able to alter a user");
            }
            case SYSTEM: {
                this.loginAs(testUser);
                test_user_client.instanceOperations().setProperty(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX.getKey(), "10000");
                this.loginAs(rootUser);
                if (!((String)root_client.instanceOperations().getSystemConfiguration().get(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX.getKey())).equals("10000")) {
                    throw new IllegalStateException("Should be able to set system property");
                }
                this.loginAs(testUser);
                test_user_client.instanceOperations().removeProperty(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX.getKey());
                this.loginAs(rootUser);
                if (!((String)root_client.instanceOperations().getSystemConfiguration().get(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX.getKey())).equals("10000")) break;
                throw new IllegalStateException("Should be able remove systemproperty");
            }
            case CREATE_NAMESPACE: {
                String namespace = "__CREATE_NAMESPACE_WITH_PERM_TEST__";
                this.loginAs(testUser);
                test_user_client.namespaceOperations().create(namespace);
                this.loginAs(rootUser);
                if (root_client.namespaceOperations().list().contains(namespace)) break;
                throw new IllegalStateException("Should be able to create a namespace");
            }
            case DROP_NAMESPACE: {
                String namespace = "__DROP_NAMESPACE_WITH_PERM_TEST__";
                this.loginAs(rootUser);
                root_client.namespaceOperations().create(namespace);
                this.loginAs(testUser);
                test_user_client.namespaceOperations().delete(namespace);
                this.loginAs(rootUser);
                if (!root_client.namespaceOperations().list().contains(namespace)) break;
                throw new IllegalStateException("Should be able to delete a namespace");
            }
            case ALTER_NAMESPACE: {
                String namespace = "__ALTER_NAMESPACE_WITH_PERM_TEST__";
                String namespace2 = namespace + "2";
                this.loginAs(rootUser);
                root_client.namespaceOperations().create(namespace);
                this.loginAs(testUser);
                test_user_client.namespaceOperations().setProperty(namespace, Property.TABLE_BLOOM_ERRORRATE.getKey(), "003.14159%");
                this.loginAs(rootUser);
                Map propies = root_client.namespaceOperations().getConfiguration(namespace);
                if (!((String)propies.get(Property.TABLE_BLOOM_ERRORRATE.getKey())).equals("003.14159%")) {
                    throw new IllegalStateException("Should be able to set a table property");
                }
                this.loginAs(testUser);
                test_user_client.namespaceOperations().removeProperty(namespace, Property.TABLE_BLOOM_ERRORRATE.getKey());
                this.loginAs(rootUser);
                propies = root_client.namespaceOperations().getConfiguration(namespace);
                if (((String)propies.get(Property.TABLE_BLOOM_ERRORRATE.getKey())).equals("003.14159%")) {
                    throw new IllegalStateException("Should be able to remove a table property");
                }
                this.loginAs(testUser);
                test_user_client.namespaceOperations().rename(namespace, namespace2);
                this.loginAs(rootUser);
                if (!root_client.namespaceOperations().list().contains(namespace) && root_client.namespaceOperations().list().contains(namespace2)) break;
                throw new IllegalStateException("Should be able to rename a table");
            }
            case OBTAIN_DELEGATION_TOKEN: {
                if (!PermissionsIT.saslEnabled()) break;
                break;
            }
            case GRANT: {
                this.loginAs(rootUser);
                root_client.securityOperations().grantSystemPermission(testUser.getPrincipal(), SystemPermission.GRANT);
                this.loginAs(testUser);
                test_user_client.securityOperations().grantSystemPermission(testUser.getPrincipal(), SystemPermission.CREATE_TABLE);
                this.loginAs(rootUser);
                Assertions.assertTrue((boolean)root_client.securityOperations().hasSystemPermission(testUser.getPrincipal(), SystemPermission.CREATE_TABLE), (String)"Test user should have CREATE_TABLE");
                Assertions.assertTrue((boolean)root_client.securityOperations().hasSystemPermission(testUser.getPrincipal(), SystemPermission.GRANT), (String)"Test user should have GRANT");
                root_client.securityOperations().revokeSystemPermission(testUser.getPrincipal(), SystemPermission.CREATE_TABLE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized System Permission: " + perm);
            }
        }
    }

    private void verifyHasOnlyTheseSystemPermissions(AccumuloClient root_client, String user, SystemPermission ... perms) throws AccumuloException, AccumuloSecurityException {
        List<SystemPermission> permList = Arrays.asList(perms);
        for (SystemPermission p : SystemPermission.values()) {
            if (permList.contains(p)) {
                if (root_client.securityOperations().hasSystemPermission(user, p)) continue;
                throw new IllegalStateException(user + " SHOULD have system permission " + p);
            }
            if (!root_client.securityOperations().hasSystemPermission(user, p)) continue;
            throw new IllegalStateException(user + " SHOULD NOT have system permission " + p);
        }
    }

    private void verifyHasNoSystemPermissions(AccumuloClient root_client, String user, SystemPermission ... perms) throws AccumuloException, AccumuloSecurityException {
        for (SystemPermission p : perms) {
            if (!root_client.securityOperations().hasSystemPermission(user, p)) continue;
            throw new IllegalStateException(user + " SHOULD NOT have system permission " + p);
        }
    }

    @Test
    public void tablePermissionTest() throws Exception {
        ClusterUser testUser = this.getUser(0);
        ClusterUser rootUser = this.getAdminUser();
        String principal = testUser.getPrincipal();
        AuthenticationToken token = testUser.getToken();
        PasswordToken passwordToken = null;
        if (token instanceof PasswordToken) {
            passwordToken = (PasswordToken)token;
        }
        this.loginAs(rootUser);
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(PermissionsIT.getClientProps()).build();){
            c.securityOperations().createLocalUser(principal, passwordToken);
            this.loginAs(testUser);
            try (AccumuloClient test_user_client = (AccumuloClient)Accumulo.newClient().from(c.properties()).as((CharSequence)principal, token).build();){
                this.loginAs(rootUser);
                this.verifyHasOnlyTheseTablePermissions(c, c.whoami(), MetadataTable.NAME, TablePermission.READ, TablePermission.ALTER_TABLE);
                String tableName = this.getUniqueNames(1)[0] + "__TABLE_PERMISSION_TEST__";
                for (TablePermission perm : TablePermission.values()) {
                    if (perm == TablePermission.ALTER_TABLE) continue;
                    log.debug("Verifying the {} permission", (Object)perm);
                    this.createTestTable(c, principal, tableName);
                    this.loginAs(testUser);
                    this.testMissingTablePermission(test_user_client, perm, tableName);
                    this.loginAs(rootUser);
                    c.securityOperations().grantTablePermission(principal, tableName, perm);
                    this.verifyHasOnlyTheseTablePermissions(c, principal, tableName, perm, TablePermission.ALTER_TABLE);
                    this.loginAs(testUser);
                    this.testGrantedTablePermission(test_user_client, perm, tableName);
                    this.loginAs(rootUser);
                    this.createTestTable(c, principal, tableName);
                    c.securityOperations().revokeTablePermission(principal, tableName, perm);
                    this.verifyHasOnlyAlterTablePermission(c, principal, tableName, perm);
                }
            }
        }
    }

    private void createTestTable(AccumuloClient c, String testUser, String tableName) throws Exception {
        if (!c.tableOperations().exists(tableName)) {
            c.tableOperations().create(tableName);
            try (BatchWriter writer = c.createBatchWriter(tableName);){
                Mutation m = new Mutation(new Text("row"));
                m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"val");
                writer.addMutation(m);
            }
            this.verifyHasOnlyTheseTablePermissions(c, c.whoami(), tableName, TablePermission.values());
            this.verifyHasOnlyAlterTablePermission(c, testUser, tableName, TablePermission.values());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void testMissingTablePermission(AccumuloClient test_user_client, TablePermission perm, String tableName) throws Exception {
        log.debug("Confirming that the lack of the {} permission properly restricts the user", (Object)perm);
        switch (perm) {
            case READ: {
                try (Scanner scanner = test_user_client.createScanner(tableName, Authorizations.EMPTY);){
                    int i = 0;
                    for (Map.Entry entry : scanner) {
                        i += 1 + ((Key)entry.getKey()).getRowData().length();
                    }
                    if (i == 0) return;
                    throw new IllegalStateException("Should NOT be able to read from the table");
                }
                catch (RuntimeException e) {
                    AccumuloSecurityException se = (AccumuloSecurityException)e.getCause();
                    if (se.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED) return;
                    throw se;
                }
            }
            case WRITE: {
                try {
                    try (BatchWriter bw = test_user_client.createBatchWriter(tableName);){
                        Mutation m = new Mutation(new Text("row"));
                        m.put((CharSequence)"a", (CharSequence)"b", (CharSequence)"c");
                        bw.addMutation(m);
                        throw new IllegalStateException("Should NOT be able to write to a table");
                    }
                    catch (MutationsRejectedException e1) {
                        if (e1.getSecurityErrorCodes().isEmpty()) throw new IllegalStateException("Should NOT be able to write to a table");
                        throw new AccumuloSecurityException(test_user_client.whoami(), org.apache.accumulo.core.clientImpl.thrift.SecurityErrorCode.PERMISSION_DENIED, (Throwable)e1);
                    }
                }
                catch (AccumuloSecurityException e) {
                    if (e.getSecurityErrorCode() != SecurityErrorCode.PERMISSION_DENIED) {
                        throw e;
                    }
                    test_user_client.tableOperations().flush(tableName, new Text("myrow"), new Text("myrow~"), false);
                    return;
                }
            }
            case BULK_IMPORT: {
                return;
            }
            case ALTER_TABLE: {
                HashMap<String, Set<Text>> groups = new HashMap<String, Set<Text>>();
                groups.put("tgroup", Set.of(new Text("t1"), new Text("t2")));
                try {
                    test_user_client.tableOperations().setLocalityGroups(tableName, groups);
                    throw new IllegalStateException("User should not be able to set locality groups");
                }
                catch (AccumuloSecurityException e) {
                    if (e.getSecurityErrorCode() != SecurityErrorCode.PERMISSION_DENIED) {
                        throw e;
                    }
                    try {
                        test_user_client.tableOperations().flush(tableName, new Text("myrow"), new Text("myrow~"), false);
                        throw new IllegalStateException("Should NOT be able to flush a table");
                    }
                    catch (AccumuloSecurityException e2) {
                        if (e2.getSecurityErrorCode() != SecurityErrorCode.PERMISSION_DENIED) {
                            throw e2;
                        }
                        this.testArbitraryProperty(test_user_client, tableName, false);
                        return;
                    }
                }
            }
            case DROP_TABLE: {
                try {
                    test_user_client.tableOperations().delete(tableName);
                    throw new IllegalStateException("User should not be able delete the table");
                }
                catch (AccumuloSecurityException e) {
                    if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED) return;
                    throw e;
                }
            }
            case GRANT: {
                try {
                    test_user_client.securityOperations().grantTablePermission(PermissionsIT.getAdminPrincipal(), tableName, TablePermission.GRANT);
                    throw new IllegalStateException("User should not be able grant permissions");
                }
                catch (AccumuloSecurityException e) {
                    if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED) return;
                    throw e;
                }
            }
            case GET_SUMMARIES: {
                try {
                    test_user_client.tableOperations().summaries(tableName).retrieve();
                    throw new IllegalStateException("User should not be able to get table summaries");
                }
                catch (AccumuloSecurityException e) {
                    if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED) return;
                    throw e;
                }
            }
            default: {
                throw new IllegalArgumentException("Unrecognized table Permission: " + perm);
            }
        }
    }

    private void testGrantedTablePermission(AccumuloClient test_user_client, TablePermission perm, String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        log.debug("Confirming that the presence of the {} permission properly permits the user", (Object)perm);
        switch (perm) {
            case READ: {
                try (Scanner scanner = test_user_client.createScanner(tableName, Authorizations.EMPTY);){
                    for (Map.Entry keyValueEntry : scanner) {
                        Assertions.assertNotNull((Object)keyValueEntry);
                    }
                    break;
                }
            }
            case WRITE: {
                test_user_client.tableOperations().flush(tableName, new Text("myrow"), new Text("myrow~"), false);
                try (BatchWriter bw = test_user_client.createBatchWriter(tableName);){
                    Mutation m = new Mutation(new Text("row"));
                    m.put((CharSequence)"a", (CharSequence)"b", (CharSequence)"c");
                    bw.addMutation(m);
                    break;
                }
            }
            case BULK_IMPORT: {
                break;
            }
            case ALTER_TABLE: {
                test_user_client.tableOperations().flush(tableName, new Text("myrow"), new Text("myrow~"), false);
                this.testArbitraryProperty(test_user_client, tableName, true);
                break;
            }
            case DROP_TABLE: {
                test_user_client.tableOperations().delete(tableName);
                break;
            }
            case GRANT: {
                test_user_client.securityOperations().grantTablePermission(PermissionsIT.getAdminPrincipal(), tableName, TablePermission.GRANT);
                break;
            }
            case GET_SUMMARIES: {
                List summaries = test_user_client.tableOperations().summaries(tableName).retrieve();
                Assertions.assertTrue((boolean)summaries.isEmpty());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized table Permission: " + perm);
            }
        }
    }

    private void verifyHasOnlyTheseTablePermissions(AccumuloClient root_client, String user, String table, TablePermission ... perms) throws AccumuloException, AccumuloSecurityException {
        List<TablePermission> permList = Arrays.asList(perms);
        for (TablePermission p : TablePermission.values()) {
            if (permList.contains(p)) {
                if (root_client.securityOperations().hasTablePermission(user, table, p)) continue;
                throw new IllegalStateException(user + " SHOULD have table permission " + p + " for table " + table);
            }
            if (!root_client.securityOperations().hasTablePermission(user, table, p)) continue;
            throw new IllegalStateException(user + " SHOULD NOT have table permission " + p + " for table " + table);
        }
    }

    private void verifyHasOnlyAlterTablePermission(AccumuloClient root_client, String user, String table, TablePermission ... perms) throws AccumuloException, AccumuloSecurityException {
        for (TablePermission p : perms) {
            if (p == TablePermission.ALTER_TABLE) {
                if (root_client.securityOperations().hasTablePermission(user, table, p)) continue;
                root_client.securityOperations().grantTablePermission(user, table, p);
                continue;
            }
            if (!root_client.securityOperations().hasTablePermission(user, table, p)) continue;
            throw new IllegalStateException(user + " SHOULD NOT have table permission " + p + " for table " + table);
        }
    }

    private void testArbitraryProperty(AccumuloClient c, String tableName, boolean havePerm) throws AccumuloException, TableNotFoundException {
        block3: {
            String propertyName = "table.custom.description";
            String description1 = "Description";
            Assertions.assertTrue((boolean)Property.isValidPropertyKey((String)propertyName));
            try {
                c.tableOperations().setProperty(tableName, propertyName, description1);
                long count = c.tableOperations().getConfiguration(tableName).entrySet().stream().filter(e -> ((String)e.getKey()).equals(propertyName) && ((String)e.getValue()).equals(description1)).count();
                Assertions.assertEquals((long)count, (long)1L);
                String description2 = "set second";
                c.tableOperations().setProperty(tableName, propertyName, description2);
                count = c.tableOperations().getConfiguration(tableName).entrySet().stream().filter(e -> ((String)e.getKey()).equals(propertyName) && ((String)e.getValue()).equals(description2)).count();
                Assertions.assertEquals((long)count, (long)1L);
                c.tableOperations().removeProperty(tableName, propertyName);
                count = c.tableOperations().getConfiguration(tableName).entrySet().stream().filter(e -> ((String)e.getKey()).equals(propertyName)).count();
                Assertions.assertEquals((long)count, (long)0L);
                if (!havePerm) {
                    throw new IllegalStateException("User should not been able to alter property.");
                }
            }
            catch (AccumuloSecurityException se) {
                if (!havePerm) break block3;
                throw new IllegalStateException("User should have been able to alter property");
            }
        }
    }
}

