/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.junit.jupiter.api.Test;

public class RenameIT
extends AccumuloClusterHarness {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(2L);
    }

    @Test
    public void renameTest() throws Exception {
        String[] tableNames = this.getUniqueNames(2);
        String name1 = tableNames[0];
        String name2 = tableNames[1];
        VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(cluster.getClientProperties(), name1);
        params.createTable = true;
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(RenameIT.getClientProps()).build();){
            TestIngest.ingest(c, params);
            c.tableOperations().rename(name1, name2);
            TestIngest.ingest(c, params);
            params.tableName = name2;
            VerifyIngest.verifyIngest(c, params);
            c.tableOperations().delete(name1);
            c.tableOperations().rename(name2, name1);
            params.tableName = name1;
            VerifyIngest.verifyIngest(c, params);
            FunctionalTestUtils.assertNoDanglingFateLocks(RenameIT.getCluster());
        }
    }
}

