/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.cluster.ClusterControl;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(RestartIT.class);
    private ExecutorService svc;

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setClientProperty(ClientProperty.INSTANCE_ZOOKEEPERS_TIMEOUT, "15s");
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setProperty(Property.GC_CYCLE_DELAY, "1s");
        cfg.setProperty(Property.GC_CYCLE_START, "1s");
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @BeforeEach
    public void setup() {
        this.svc = Executors.newFixedThreadPool(1);
    }

    @AfterEach
    public void teardown() throws Exception {
        if (this.svc == null) {
            return;
        }
        if (!this.svc.isShutdown()) {
            this.svc.shutdown();
        }
        while (!this.svc.awaitTermination(10L, TimeUnit.SECONDS)) {
            log.info("Waiting for threadpool to terminate");
        }
    }

    @Test
    public void restartManager() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(RestartIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            ClusterControl control = RestartIT.getCluster().getClusterControl();
            VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(RestartIT.getClientProps(), tableName, 10000);
            Future<Integer> ret = this.svc.submit(() -> {
                try {
                    return control.exec(TestIngest.class, new String[]{"-c", cluster.getClientPropsPath(), "--rows", "" + params.rows, "--table", tableName});
                }
                catch (IOException e) {
                    log.error("Error running TestIngest", (Throwable)e);
                    return -1;
                }
            });
            control.stopAllServers(ServerType.MANAGER);
            control.startAllServers(ServerType.MANAGER);
            Assertions.assertEquals((int)0, (int)ret.get());
            VerifyIngest.verifyIngest(c, params);
        }
    }

    @Test
    public void restartManagerRecovery() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(RestartIT.getClientProps()).build();){
            byte[] managerLockData;
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(RestartIT.getClientProps(), tableName, 10000);
            TestIngest.ingest(c, params);
            ClusterControl control = RestartIT.getCluster().getClusterControl();
            control.stopAllServers(ServerType.MANAGER);
            control.stopAllServers(ServerType.TABLET_SERVER);
            control.stopAllServers(ServerType.GARBAGE_COLLECTOR);
            control.stopAllServers(ServerType.MONITOR);
            ZooCache zcache = cluster.getServerContext().getZooCache();
            ServiceLock.ServiceLockPath zLockPath = ServiceLock.path((String)(ZooUtil.getRoot((InstanceId)c.instanceOperations().getInstanceId()) + "/managers/lock"));
            do {
                if ((managerLockData = ServiceLock.getLockData((ZooCache)zcache, (ServiceLock.ServiceLockPath)zLockPath, null)) == null) continue;
                log.info("Manager lock is still held");
                Thread.sleep(1000L);
            } while (managerLockData != null);
            cluster.start();
            UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.MILLISECONDS);
            control.stopAllServers(ServerType.MANAGER);
            managerLockData = new byte[]{};
            do {
                if ((managerLockData = ServiceLock.getLockData((ZooCache)zcache, (ServiceLock.ServiceLockPath)zLockPath, null)) == null) continue;
                log.info("Manager lock is still held");
                Thread.sleep(1000L);
            } while (managerLockData != null);
            cluster.start();
            VerifyIngest.verifyIngest(c, params);
        }
    }

    @Test
    public void restartManagerSplit() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(RestartIT.getClientProps()).build();){
            byte[] managerLockData;
            String tableName = this.getUniqueNames(1)[0];
            ClusterControl control = RestartIT.getCluster().getClusterControl();
            c.tableOperations().create(tableName);
            c.tableOperations().setProperty(tableName, Property.TABLE_SPLIT_THRESHOLD.getKey(), "5K");
            VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(RestartIT.getClientProps(), tableName, 10000);
            Future<Integer> ret = this.svc.submit(() -> {
                try {
                    return control.exec(TestIngest.class, new String[]{"-c", cluster.getClientPropsPath(), "--rows", "" + params.rows, "--table", tableName});
                }
                catch (Exception e) {
                    log.error("Error running TestIngest", (Throwable)e);
                    return -1;
                }
            });
            control.stopAllServers(ServerType.MANAGER);
            ZooCache zcache = cluster.getServerContext().getZooCache();
            ServiceLock.ServiceLockPath zLockPath = ServiceLock.path((String)(ZooUtil.getRoot((InstanceId)c.instanceOperations().getInstanceId()) + "/managers/lock"));
            do {
                if ((managerLockData = ServiceLock.getLockData((ZooCache)zcache, (ServiceLock.ServiceLockPath)zLockPath, null)) == null) continue;
                log.info("Manager lock is still held");
                Thread.sleep(1000L);
            } while (managerLockData != null);
            cluster.start();
            Assertions.assertEquals((int)0, (int)ret.get());
            VerifyIngest.verifyIngest(c, params);
        }
    }

    @Test
    public void killedTabletServer() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(RestartIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(RestartIT.getClientProps(), tableName, 10000);
            TestIngest.ingest(c, params);
            VerifyIngest.verifyIngest(c, params);
            cluster.getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
            cluster.start();
            VerifyIngest.verifyIngest(c, params);
        }
    }

    @Test
    public void killedTabletServer2() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(RestartIT.getClientProps()).build();){
            String[] names = this.getUniqueNames(2);
            String tableName = names[0];
            ClusterControl control = RestartIT.getCluster().getClusterControl();
            c.tableOperations().create(tableName);
            control.stopAllServers(ServerType.TABLET_SERVER);
            cluster.start();
            c.tableOperations().create(names[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void killedTabletServerDuringShutdown() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(RestartIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            TestIngest.IngestParams params = new TestIngest.IngestParams(RestartIT.getClientProps(), tableName, 10000);
            TestIngest.ingest(c, params);
            try {
                RestartIT.getCluster().getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
                RestartIT.getCluster().getClusterControl().adminStopAll();
            }
            finally {
                RestartIT.getCluster().stop();
                RestartIT.getCluster().start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shutdownDuringCompactingSplitting() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(RestartIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(RestartIT.getClientProps(), tableName, 10000);
            c.tableOperations().create(tableName);
            c.tableOperations().setProperty(tableName, Property.TABLE_SPLIT_THRESHOLD.getKey(), "10K");
            String splitThreshold = null;
            for (Map.Entry entry : c.tableOperations().getProperties(tableName)) {
                if (!((String)entry.getKey()).equals(Property.TABLE_SPLIT_THRESHOLD.getKey())) continue;
                splitThreshold = (String)entry.getValue();
                break;
            }
            Assertions.assertNotNull(splitThreshold);
            try {
                c.tableOperations().setProperty(MetadataTable.NAME, Property.TABLE_SPLIT_THRESHOLD.getKey(), "20K");
                TestIngest.ingest(c, params);
                c.tableOperations().flush(tableName, null, null, false);
                VerifyIngest.verifyIngest(c, params);
                RestartIT.getCluster().stop();
            }
            finally {
                if (RestartIT.getClusterType() == AccumuloClusterHarness.ClusterType.STANDALONE) {
                    RestartIT.getCluster().start();
                    c.tableOperations().setProperty(MetadataTable.NAME, Property.TABLE_SPLIT_THRESHOLD.getKey(), splitThreshold);
                }
            }
        }
    }
}

