/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterators;
import java.time.Duration;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.user.RowDeletingIterator;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RowDeleteIT
extends AccumuloClusterHarness {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        Map siteConfig = cfg.getSiteConfig();
        siteConfig.put(Property.TSERV_MAJC_DELAY.getKey(), "50ms");
        cfg.setSiteConfig(siteConfig);
    }

    @Test
    public void run() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(RowDeleteIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            NewTableConfiguration ntc = new NewTableConfiguration();
            IteratorSetting setting = new IteratorSetting(30, RowDeletingIterator.class);
            ntc.attachIterator(setting, EnumSet.of(IteratorUtil.IteratorScope.majc));
            ntc.setLocalityGroups(Map.of("lg1", Set.of(new Text("foo"))));
            ntc.setProperties(Map.of(Property.TABLE_MAJC_RATIO.getKey(), "100"));
            c.tableOperations().create(tableName, ntc);
            try (BatchWriter bw = c.createBatchWriter(tableName);
                 Scanner scanner = c.createScanner(tableName, Authorizations.EMPTY);){
                bw.addMutation(FunctionalTestUtils.nm("r1", "foo", "cf1", "v1"));
                bw.addMutation(FunctionalTestUtils.nm("r1", "bar", "cf1", "v2"));
                bw.flush();
                c.tableOperations().flush(tableName, null, null, true);
                FunctionalTestUtils.checkRFiles(c, tableName, 1, 1, 1, 1);
                int count = Iterators.size((Iterator)scanner.iterator());
                Assertions.assertEquals((int)2, (int)count, (String)("count == " + count));
                bw.addMutation(FunctionalTestUtils.nm("r1", "", "", RowDeletingIterator.DELETE_ROW_VALUE));
                bw.flush();
                c.tableOperations().flush(tableName, null, null, true);
                FunctionalTestUtils.checkRFiles(c, tableName, 1, 1, 2, 2);
                count = Iterators.size((Iterator)scanner.iterator());
                Assertions.assertEquals((int)3, (int)count, (String)("count == " + count));
                c.tableOperations().compact(tableName, null, null, false, true);
                FunctionalTestUtils.checkRFiles(c, tableName, 1, 1, 0, 0);
                Assertions.assertTrue((boolean)scanner.stream().findAny().isEmpty());
            }
        }
    }
}

