/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanSessionTimeOutIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(ScanSessionTimeOutIT.class);
    private String sessionIdle = null;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        Map siteConfig = cfg.getSiteConfig();
        siteConfig.put(Property.TSERV_SESSION_MAXIDLE.getKey(), this.getMaxIdleTimeString());
        cfg.setSiteConfig(siteConfig);
    }

    @BeforeEach
    public void reduceSessionIdle() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ScanSessionTimeOutIT.getClientProps()).build();){
            InstanceOperations ops = client.instanceOperations();
            this.sessionIdle = (String)ops.getSystemConfiguration().get(Property.TSERV_SESSION_MAXIDLE.getKey());
            ops.setProperty(Property.TSERV_SESSION_MAXIDLE.getKey(), this.getMaxIdleTimeString());
            log.info("Waiting for existing session idle time to expire");
            Thread.sleep(ConfigurationTypeHelper.getTimeInMillis((String)this.sessionIdle));
            log.info("Finished waiting");
        }
    }

    protected String getMaxIdleTimeString() {
        return "3";
    }

    @AfterEach
    public void resetSessionIdle() throws Exception {
        if (this.sessionIdle != null) {
            try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(ScanSessionTimeOutIT.getClientProps()).build();){
                client.instanceOperations().setProperty(Property.TSERV_SESSION_MAXIDLE.getKey(), this.sessionIdle);
            }
        }
    }

    @Test
    public void run() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(ScanSessionTimeOutIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                for (int i = 0; i < 100000; ++i) {
                    Mutation m = new Mutation(new Text(String.format("%08d", i)));
                    for (int j = 0; j < 3; ++j) {
                        m.put((CharSequence)"cf1", (CharSequence)("cq" + j), (CharSequence)(i + "_" + j));
                    }
                    bw.addMutation(m);
                }
            }
            try (Scanner scanner = c.createScanner(tableName, new Authorizations());){
                scanner.setBatchSize(1000);
                Iterator iter = scanner.iterator();
                this.verify(iter, 0, 200);
                UtilWaitThread.sleepUninterruptibly((long)9L, (TimeUnit)TimeUnit.SECONDS);
                this.verify(iter, 200, 100000);
            }
        }
    }

    protected void verify(Iterator<Map.Entry<Key, Value>> iter, int start, int stop) throws Exception {
        for (int i = start; i < stop; ++i) {
            Text er = new Text(String.format("%08d", i));
            for (int j = 0; j < 3; ++j) {
                Map.Entry<Key, Value> entry = iter.next();
                if (!entry.getKey().getRow().equals((Object)er)) {
                    throw new Exception("row " + entry.getKey().getRow() + " != " + er);
                }
                if (!entry.getKey().getColumnFamily().equals((Object)new Text("cf1"))) {
                    throw new Exception("cf " + entry.getKey().getColumnFamily() + " != cf1");
                }
                if (!entry.getKey().getColumnQualifier().equals((Object)new Text("cq" + j))) {
                    throw new Exception("cq " + entry.getKey().getColumnQualifier() + " != cq" + j);
                }
                if (entry.getValue().toString().equals(i + "_" + j)) continue;
                throw new Exception("value " + entry.getValue() + " != " + i + "_" + j);
            }
        }
    }
}

