/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ScannerContextIT
extends AccumuloClusterHarness {
    private static final String CONTEXT = ScannerContextIT.class.getSimpleName();
    private static final Property VFS_CONTEXT_CLASSPATH_PROPERTY = Property.VFS_CONTEXT_CLASSPATH_PROPERTY;
    private static final String CONTEXT_PROPERTY = VFS_CONTEXT_CLASSPATH_PROPERTY + CONTEXT;
    private static final String CONTEXT_DIR = "file://" + System.getProperty("user.dir") + "/target";
    private static final String CONTEXT_CLASSPATH = CONTEXT_DIR + "/Test.jar";
    private static int ITERATIONS = 10;
    private static final long WAIT = 7000L;
    private FileSystem fs;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(2L);
    }

    @BeforeEach
    public void checkCluster() throws Exception {
        Assumptions.assumeTrue((ScannerContextIT.getClusterType() == AccumuloClusterHarness.ClusterType.MINI ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)MiniAccumuloClusterImpl.class.isInstance(ScannerContextIT.getCluster()));
        this.fs = FileSystem.get((Configuration)cluster.getServerContext().getHadoopConf());
    }

    private Path copyTestIteratorsJarToTmp() throws IOException {
        Path baseDir = new Path(System.getProperty("user.dir"));
        Path targetDir = new Path(baseDir, "target");
        Path jarPath = new Path(targetDir, "TestJar-Iterators.jar");
        Path dstPath = new Path(CONTEXT_DIR + "/Test.jar");
        this.fs.copyFromLocalFile(jarPath, dstPath);
        UtilWaitThread.sleep((long)7000L);
        return dstPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        Path dstPath = this.copyTestIteratorsJarToTmp();
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(ScannerContextIT.getClientProps()).build();){
            c.instanceOperations().setProperty(CONTEXT_PROPERTY, CONTEXT_CLASSPATH);
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                for (int i = 0; i < ITERATIONS; ++i) {
                    Mutation m = new Mutation((CharSequence)("row" + i));
                    m.put((CharSequence)"cf", (CharSequence)"col1", (CharSequence)"Test");
                    bw.addMutation(m);
                }
            }
            this.scanCheck(c, tableName, null, null, "Test");
            this.batchCheck(c, tableName, null, null, "Test");
            IteratorSetting cfg = new IteratorSetting(21, "reverse", "org.apache.accumulo.test.functional.ValueReversingIterator");
            Assertions.assertThrows(Exception.class, () -> this.scanCheck(c, tableName, cfg, null, "tseT"), (String)"This should have failed because context was not set");
            Assertions.assertThrows(Exception.class, () -> this.batchCheck(c, tableName, cfg, null, "tseT"), (String)"This should have failed because context was not set");
            this.scanCheck(c, tableName, cfg, CONTEXT, "tseT");
            this.batchCheck(c, tableName, cfg, CONTEXT, "tseT");
        }
        finally {
            this.fs.delete(dstPath, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanContextOverridesTableContext() throws Exception {
        Path dstPath = this.copyTestIteratorsJarToTmp();
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(ScannerContextIT.getClientProps()).build();){
            String tableContext = "FOO";
            String tableContextProperty = VFS_CONTEXT_CLASSPATH_PROPERTY + tableContext;
            String tableContextDir = "file://" + System.getProperty("user.dir") + "/target";
            String tableContextClasspath = tableContextDir + "/TestFoo.jar";
            c.instanceOperations().setProperty(tableContextProperty, tableContextClasspath);
            c.instanceOperations().setProperty(CONTEXT_PROPERTY, CONTEXT_CLASSPATH);
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            c.tableOperations().setProperty(tableName, Property.TABLE_CLASSLOADER_CONTEXT.getKey(), tableContext);
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                for (int i = 0; i < ITERATIONS; ++i) {
                    Mutation m = new Mutation((CharSequence)("row" + i));
                    m.put((CharSequence)"cf", (CharSequence)"col1", (CharSequence)"Test");
                    bw.addMutation(m);
                }
            }
            this.scanCheck(c, tableName, null, null, "Test");
            this.batchCheck(c, tableName, null, null, "Test");
            IteratorSetting cfg = new IteratorSetting(21, "reverse", "org.apache.accumulo.test.functional.ValueReversingIterator");
            Assertions.assertThrows(Exception.class, () -> this.scanCheck(c, tableName, cfg, null, "tseT"), (String)"This should have failed because context was not set");
            Assertions.assertThrows(Exception.class, () -> this.batchCheck(c, tableName, cfg, null, "tseT"), (String)"This should have failed because context was not set");
            this.scanCheck(c, tableName, cfg, CONTEXT, "tseT");
            this.batchCheck(c, tableName, cfg, CONTEXT, "tseT");
        }
        finally {
            this.fs.delete(dstPath, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOneScannerDoesntInterfereWithAnother() throws Exception {
        Path dstPath = this.copyTestIteratorsJarToTmp();
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(ScannerContextIT.getClientProps()).build();){
            c.instanceOperations().setProperty(CONTEXT_PROPERTY, CONTEXT_CLASSPATH);
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                for (int i = 0; i < ITERATIONS; ++i) {
                    Mutation m = new Mutation((CharSequence)("row" + i));
                    m.put((CharSequence)"cf", (CharSequence)"col1", (CharSequence)"Test");
                    bw.addMutation(m);
                }
            }
            try (Scanner one = c.createScanner(tableName, Authorizations.EMPTY);
                 Scanner two = c.createScanner(tableName, Authorizations.EMPTY);){
                IteratorSetting cfg = new IteratorSetting(21, "reverse", "org.apache.accumulo.test.functional.ValueReversingIterator");
                one.addScanIterator(cfg);
                one.setClassLoaderContext(CONTEXT);
                Iterator iterator = one.iterator();
                for (int i = 0; i < ITERATIONS; ++i) {
                    Assertions.assertTrue((boolean)iterator.hasNext());
                    Map.Entry next = (Map.Entry)iterator.next();
                    Assertions.assertEquals((Object)"tseT", (Object)((Value)next.getValue()).toString());
                }
                Iterator iterator2 = two.iterator();
                for (int i = 0; i < ITERATIONS; ++i) {
                    Assertions.assertTrue((boolean)iterator2.hasNext());
                    Map.Entry next = (Map.Entry)iterator2.next();
                    Assertions.assertEquals((Object)"Test", (Object)((Value)next.getValue()).toString());
                }
            }
        }
        finally {
            this.fs.delete(dstPath, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClearContext() throws Exception {
        Path dstPath = this.copyTestIteratorsJarToTmp();
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(ScannerContextIT.getClientProps()).build();){
            c.instanceOperations().setProperty(CONTEXT_PROPERTY, CONTEXT_CLASSPATH);
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                for (int i = 0; i < ITERATIONS; ++i) {
                    Mutation m = new Mutation((CharSequence)("row" + i));
                    m.put((CharSequence)"cf", (CharSequence)"col1", (CharSequence)"Test");
                    bw.addMutation(m);
                }
            }
            try (Scanner one = c.createScanner(tableName, Authorizations.EMPTY);){
                Map.Entry next;
                int i;
                IteratorSetting cfg = new IteratorSetting(21, "reverse", "org.apache.accumulo.test.functional.ValueReversingIterator");
                one.addScanIterator(cfg);
                one.setClassLoaderContext(CONTEXT);
                Iterator iterator = one.iterator();
                for (i = 0; i < ITERATIONS; ++i) {
                    Assertions.assertTrue((boolean)iterator.hasNext());
                    next = (Map.Entry)iterator.next();
                    Assertions.assertEquals((Object)"tseT", (Object)((Value)next.getValue()).toString());
                }
                one.removeScanIterator("reverse");
                one.clearClassLoaderContext();
                iterator = one.iterator();
                for (i = 0; i < ITERATIONS; ++i) {
                    Assertions.assertTrue((boolean)iterator.hasNext());
                    next = (Map.Entry)iterator.next();
                    Assertions.assertEquals((Object)"Test", (Object)((Value)next.getValue()).toString());
                }
            }
        }
        finally {
            this.fs.delete(dstPath, true);
        }
    }

    private void scanCheck(AccumuloClient c, String tableName, IteratorSetting cfg, String context, String expected) throws Exception {
        try (Scanner bs = c.createScanner(tableName, Authorizations.EMPTY);){
            if (context != null) {
                bs.setClassLoaderContext(context);
            }
            if (cfg != null) {
                bs.addScanIterator(cfg);
            }
            Iterator iterator = bs.iterator();
            for (int i = 0; i < ITERATIONS; ++i) {
                Assertions.assertTrue((boolean)iterator.hasNext());
                Map.Entry next = (Map.Entry)iterator.next();
                Assertions.assertEquals((Object)expected, (Object)((Value)next.getValue()).toString());
            }
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
    }

    private void batchCheck(AccumuloClient c, String tableName, IteratorSetting cfg, String context, String expected) throws Exception {
        try (BatchScanner bs = c.createBatchScanner(tableName);){
            bs.setRanges(Collections.singleton(new Range()));
            if (context != null) {
                bs.setClassLoaderContext(context);
            }
            if (cfg != null) {
                bs.addScanIterator(cfg);
            }
            Iterator iterator = bs.iterator();
            for (int i = 0; i < ITERATIONS; ++i) {
                Assertions.assertTrue((boolean)iterator.hasNext());
                Map.Entry next = (Map.Entry)iterator.next();
                Assertions.assertEquals((Object)expected, (Object)((Value)next.getValue()).toString());
            }
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
    }
}

