/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.Iterator;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.functional.SlowIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ScannerIT
extends AccumuloClusterHarness {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    @Test
    public void testScannerReadaheadConfiguration() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(ScannerIT.getClientProps()).build();){
            Iterator iterator;
            IteratorSetting cfg;
            c.tableOperations().create(table);
            try (BatchWriter bw = c.createBatchWriter(table);){
                Mutation m = new Mutation((CharSequence)"a");
                for (int i = 0; i < 10; ++i) {
                    m.put((CharSequence)Integer.toString(i), (CharSequence)"", (CharSequence)"");
                }
                bw.addMutation(m);
            }
            long nanosWithWait = 0L;
            try (Scanner s = c.createScanner(table, new Authorizations());){
                cfg = new IteratorSetting(100, SlowIterator.class);
                SlowIterator.setSeekSleepTime(cfg, 100L);
                s.addScanIterator(cfg);
                s.setReadaheadThreshold(Long.MAX_VALUE);
                s.setBatchSize(1);
                s.setRange(new Range());
                iterator = s.iterator();
                long startTime = System.nanoTime();
                while (iterator.hasNext()) {
                    nanosWithWait += System.nanoTime() - startTime;
                    UtilWaitThread.sleep((long)100L);
                    iterator.next();
                    startTime = System.nanoTime();
                }
                nanosWithWait += System.nanoTime() - startTime;
            }
            long nanosWithNoWait = 0L;
            try (Scanner s = c.createScanner(table, new Authorizations());){
                s.addScanIterator(cfg);
                s.setRange(new Range());
                s.setBatchSize(1);
                s.setReadaheadThreshold(0L);
                iterator = s.iterator();
                long startTime = System.nanoTime();
                while (iterator.hasNext()) {
                    nanosWithNoWait += System.nanoTime() - startTime;
                    UtilWaitThread.sleep((long)100L);
                    iterator.next();
                    startTime = System.nanoTime();
                }
                Assertions.assertTrue(((nanosWithNoWait += System.nanoTime() - startTime) < nanosWithWait ? 1 : 0) != 0, (String)("Expected less time to be taken with immediate readahead (" + nanosWithNoWait + ") than without immediate readahead (" + nanosWithWait + ")"));
            }
        }
    }
}

