/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Combiner;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.functional.BadCombiner;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ServerSideErrorIT
extends AccumuloClusterHarness {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(2L);
    }

    @Test
    public void run() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(ServerSideErrorIT.getClientProps()).build();){
            Iterator iterator;
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName);
            IteratorSetting is = new IteratorSetting(5, "Bad Aggregator", BadCombiner.class);
            Combiner.setColumns((IteratorSetting)is, Collections.singletonList(new IteratorSetting.Column("acf")));
            c.tableOperations().attachIterator(tableName, is);
            try (BatchWriter bw = c.createBatchWriter(tableName);){
                Mutation m = new Mutation(new Text("r1"));
                m.put((CharSequence)"acf", (CharSequence)"foo", new Value(new byte[]{49}));
                bw.addMutation(m);
            }
            try (Scanner scanner = c.createScanner(tableName, Authorizations.EMPTY);){
                iterator = scanner.iterator();
                Assertions.assertThrows(RuntimeException.class, iterator::hasNext);
            }
            try (BatchScanner bs = c.createBatchScanner(tableName, Authorizations.EMPTY, 2);){
                bs.setRanges(Collections.singleton(new Range()));
                iterator = bs.iterator();
                Assertions.assertThrows(RuntimeException.class, iterator::hasNext);
            }
            TableOperations to = c.tableOperations();
            Iterable tableProps = to.getProperties(tableName);
            to.modifyProperties(tableName, properties -> {
                for (Map.Entry e : tableProps) {
                    properties.remove(e.getKey());
                }
            });
            UtilWaitThread.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
            try (Scanner scanner = c.createScanner(tableName, Authorizations.EMPTY);){
                scanner.forEach((k, v) -> {});
                scanner.addScanIterator(new IteratorSetting(100, "bogus", "com.bogus.iterator"));
                Iterator iterator2 = scanner.iterator();
                Assertions.assertThrows(RuntimeException.class, iterator2::hasNext);
            }
        }
    }
}

