/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.accumulo.server.util.Admin;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.TestRandomDeletes;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ShutdownIT
extends ConfigurableMacBase {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(2L);
    }

    @Test
    public void shutdownDuringIngest() throws Exception {
        Process ingest = this.cluster.exec(TestIngest.class, new String[]{"-c", this.cluster.getClientPropsPath(), "--createTable"}).getProcess();
        UtilWaitThread.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        Assertions.assertEquals((int)0, (int)this.cluster.exec(Admin.class, new String[]{"stopAll"}).getProcess().waitFor());
        ingest.destroy();
    }

    @Test
    public void shutdownDuringQuery() throws Exception {
        Assertions.assertEquals((int)0, (int)this.cluster.exec(TestIngest.class, new String[]{"-c", this.cluster.getClientPropsPath(), "--createTable"}).getProcess().waitFor());
        Process verify = this.cluster.exec(VerifyIngest.class, new String[]{"-c", this.cluster.getClientPropsPath()}).getProcess();
        UtilWaitThread.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        Assertions.assertEquals((int)0, (int)this.cluster.exec(Admin.class, new String[]{"stopAll"}).getProcess().waitFor());
        verify.destroy();
    }

    @Test
    public void shutdownDuringDelete() throws Exception {
        Assertions.assertEquals((int)0, (int)this.cluster.exec(TestIngest.class, new String[]{"-c", this.cluster.getClientPropsPath(), "--createTable"}).getProcess().waitFor());
        Process deleter = this.cluster.exec(TestRandomDeletes.class, new String[]{"-c", this.cluster.getClientPropsPath()}).getProcess();
        UtilWaitThread.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        Assertions.assertEquals((int)0, (int)this.cluster.exec(Admin.class, new String[]{"stopAll"}).getProcess().waitFor());
        deleter.destroy();
    }

    @Test
    public void shutdownDuringDeleteTable() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            for (int i = 0; i < 10; ++i) {
                c.tableOperations().create("table" + i);
            }
            AtomicReference ref = new AtomicReference();
            Thread async = new Thread(() -> {
                try {
                    for (int i = 0; i < 10; ++i) {
                        c.tableOperations().delete("table" + i);
                    }
                }
                catch (Exception ex) {
                    ref.set(ex);
                }
            });
            async.start();
            UtilWaitThread.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            Assertions.assertEquals((int)0, (int)this.cluster.exec(Admin.class, new String[]{"stopAll"}).getProcess().waitFor());
            if (ref.get() != null) {
                throw (Exception)ref.get();
            }
        }
    }

    @Test
    public void stopDuringStart() throws Exception {
        Assertions.assertEquals((int)0, (int)this.cluster.exec(Admin.class, new String[]{"stopAll"}).getProcess().waitFor());
    }

    @Test
    public void adminStop() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            ShutdownIT.runAdminStopTest(c, this.cluster);
        }
    }

    static void runAdminStopTest(AccumuloClient c, MiniAccumuloClusterImpl cluster) throws InterruptedException, IOException {
        int x = cluster.exec(TestIngest.class, new String[]{"-c", cluster.getClientPropsPath(), "--createTable"}).getProcess().waitFor();
        Assertions.assertEquals((int)0, (int)x);
        List tabletServers = c.instanceOperations().getTabletServers();
        Assertions.assertEquals((int)2, (int)tabletServers.size());
        String doomed = (String)tabletServers.get(0);
        log.info("Stopping " + doomed);
        Assertions.assertEquals((int)0, (int)cluster.exec(Admin.class, new String[]{"stop", doomed}).getProcess().waitFor());
        tabletServers = c.instanceOperations().getTabletServers();
        Assertions.assertEquals((int)1, (int)tabletServers.size());
        Assertions.assertNotEquals(tabletServers.get(0), (Object)doomed);
    }
}

