/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Credentials;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.manager.thrift.ManagerMonitorInfo;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.minicluster.MemoryUnit;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SimpleBalancerFairnessIT
extends ConfigurableMacBase {
    private static final int NUM_SPLITS = 50;

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.TSERV_MAXMEM, "1K");
        cfg.setProperty(Property.TSERV_MAJC_DELAY, "50ms");
        cfg.setMemory(ServerType.TABLET_SERVER, cfg.getMemory(ServerType.TABLET_SERVER) * 3L, MemoryUnit.BYTE);
    }

    @Test
    public void simpleBalancerFairness() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            c.tableOperations().create("test_ingest");
            c.tableOperations().setProperty("test_ingest", Property.TABLE_SPLIT_THRESHOLD.getKey(), "1K");
            c.tableOperations().create("unused");
            TreeSet<Text> splits = TestIngest.getSplitPoints(0L, 10000000L, 50L);
            log.info("Creating {} splits", (Object)splits.size());
            c.tableOperations().addSplits("unused", splits);
            List tservers = c.instanceOperations().getTabletServers();
            TestIngest.IngestParams params = new TestIngest.IngestParams(this.getClientProperties());
            params.rows = 5000;
            TestIngest.ingest(c, params);
            c.tableOperations().flush("test_ingest", null, null, false);
            UtilWaitThread.sleepUninterruptibly((long)45L, (TimeUnit)TimeUnit.SECONDS);
            Credentials creds = new Credentials("root", (AuthenticationToken)new PasswordToken((CharSequence)"testRootPassword1"));
            int unassignedTablets = 1;
            ManagerMonitorInfo stats = null;
            ClientContext context = (ClientContext)c;
            for (int i = 0; unassignedTablets > 0 && i < 20; ++i) {
                stats = (ManagerMonitorInfo)ThriftClientTypes.MANAGER.execute(context, client -> client.getManagerStats(TraceUtil.traceInfo(), creds.toThrift(c.instanceOperations().getInstanceId())));
                unassignedTablets = stats.getUnassignedTablets();
                if (unassignedTablets <= 0) continue;
                log.info("Found {} unassigned tablets, sleeping 3 seconds for tablet assignment", (Object)unassignedTablets);
                Thread.sleep(3000L);
            }
            Assertions.assertEquals((int)0, (int)unassignedTablets, (String)"Unassigned tablets were not assigned within 60 seconds");
            ArrayList<Integer> counts = new ArrayList<Integer>();
            for (TabletServerStatus server : stats.tServerInfo) {
                int count = 0;
                for (TableInfo table : server.tableMap.values()) {
                    count += table.onlineTablets;
                }
                counts.add(count);
            }
            Assertions.assertTrue((counts.size() > 1 ? 1 : 0) != 0, (String)"Expected to have at least two TabletServers");
            for (int i = 1; i < counts.size(); ++i) {
                int diff = Math.abs((Integer)counts.get(0) - (Integer)counts.get(i));
                Assertions.assertTrue((diff <= tservers.size() ? 1 : 0) != 0, (String)("Expected difference in tablets to be less than or equal to " + counts.size() + " but was " + diff + ". Counts " + counts));
            }
        }
    }
}

