/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.rfile.RFile;
import org.apache.accumulo.core.client.rfile.RFileWriter;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.util.CheckForMetadataProblems;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.accumulo.test.functional.DeleteIT;
import org.apache.accumulo.test.functional.ReadWriteIT;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(SplitIT.class);
    private String tservMaxMem;
    private String tservMajcDelay;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(4L);
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.TSERV_MAXMEM, "5K");
        cfg.setProperty(Property.TSERV_MAJC_DELAY, "100ms");
    }

    @BeforeEach
    public void alterConfig() throws Exception {
        Assumptions.assumeTrue((SplitIT.getClusterType() == AccumuloClusterHarness.ClusterType.MINI ? 1 : 0) != 0);
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(SplitIT.getClientProps()).build();){
            InstanceOperations iops = client.instanceOperations();
            Map config = iops.getSystemConfiguration();
            this.tservMaxMem = (String)config.get(Property.TSERV_MAXMEM.getKey());
            this.tservMajcDelay = (String)config.get(Property.TSERV_MAJC_DELAY.getKey());
            if (!this.tservMajcDelay.equals("100ms")) {
                iops.setProperty(Property.TSERV_MAJC_DELAY.getKey(), "100ms");
            }
            boolean restarted = false;
            if (!this.tservMaxMem.equals("5K")) {
                iops.setProperty(Property.TSERV_MAXMEM.getKey(), "5K");
                SplitIT.getCluster().getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
                SplitIT.getCluster().getClusterControl().startAllServers(ServerType.TABLET_SERVER);
                restarted = true;
            }
            if (!restarted) {
                long millis = ConfigurationTypeHelper.getTimeInMillis((String)this.tservMajcDelay);
                log.info("Waiting for majc delay period: {}ms", (Object)millis);
                Thread.sleep(millis);
                log.info("Finished waiting for majc delay period");
            }
        }
    }

    @AfterEach
    public void resetConfig() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(SplitIT.getClientProps()).build();){
            if (this.tservMaxMem != null) {
                log.info("Resetting {}={}", (Object)Property.TSERV_MAXMEM.getKey(), (Object)this.tservMaxMem);
                client.instanceOperations().setProperty(Property.TSERV_MAXMEM.getKey(), this.tservMaxMem);
                this.tservMaxMem = null;
                SplitIT.getCluster().getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
                SplitIT.getCluster().getClusterControl().startAllServers(ServerType.TABLET_SERVER);
            }
            if (this.tservMajcDelay != null) {
                log.info("Resetting {}={}", (Object)Property.TSERV_MAJC_DELAY.getKey(), (Object)this.tservMajcDelay);
                client.instanceOperations().setProperty(Property.TSERV_MAJC_DELAY.getKey(), this.tservMajcDelay);
                this.tservMajcDelay = null;
            }
        }
    }

    @Test
    public void tabletShouldSplit() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(SplitIT.getClientProps()).build();){
            String table = this.getUniqueNames(1)[0];
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(Property.TABLE_SPLIT_THRESHOLD.getKey(), "256K");
            props.put(Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE.getKey(), "1K");
            c.tableOperations().create(table, new NewTableConfiguration().setProperties(props));
            VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(SplitIT.getClientProps(), table, 100000);
            TestIngest.ingest(c, params);
            VerifyIngest.verifyIngest(c, params);
            while (c.tableOperations().listSplits(table).size() < 10) {
                UtilWaitThread.sleepUninterruptibly((long)15L, (TimeUnit)TimeUnit.SECONDS);
            }
            TableId id = TableId.of((String)((String)c.tableOperations().tableIdMap().get(table)));
            try (Scanner s = c.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                KeyExtent extent = new KeyExtent(id, null, null);
                s.setRange(extent.toMetaRange());
                MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch((ScannerBase)s);
                int count = 0;
                int shortened = 0;
                for (Map.Entry entry : s) {
                    extent = KeyExtent.fromMetaPrevRow((Map.Entry)entry);
                    if (extent.endRow() != null && extent.endRow().toString().length() < 14) {
                        ++shortened;
                    }
                    ++count;
                }
                Assertions.assertTrue((shortened > 0 ? 1 : 0) != 0, (String)("Shortened should be greater than zero: " + shortened));
                Assertions.assertTrue((count > 10 ? 1 : 0) != 0, (String)("Count should be cgreater than 10: " + count));
            }
            Assertions.assertEquals((int)0, (int)SplitIT.getCluster().getClusterControl().exec(CheckForMetadataProblems.class, new String[]{"-c", cluster.getClientPropsPath()}));
        }
    }

    @Test
    public void interleaveSplit() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(SplitIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(Property.TABLE_SPLIT_THRESHOLD.getKey(), "10K");
            props.put(Property.TABLE_FILE_COMPRESSION_TYPE.getKey(), "none");
            c.tableOperations().create(tableName, new NewTableConfiguration().setProperties(props));
            UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
            ReadWriteIT.interleaveTest(c, tableName);
            UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
            int numSplits = c.tableOperations().listSplits(tableName).size();
            while (numSplits <= 20) {
                log.info("Waiting for splits to happen");
                Thread.sleep(2000L);
                numSplits = c.tableOperations().listSplits(tableName).size();
            }
            Assertions.assertTrue((numSplits > 20 ? 1 : 0) != 0, (String)("Expected at least 20 splits, saw " + numSplits));
        }
    }

    @Test
    public void deleteSplit() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(SplitIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName, new NewTableConfiguration().setProperties(Collections.singletonMap(Property.TABLE_SPLIT_THRESHOLD.getKey(), "10K")));
            DeleteIT.deleteTest(c, SplitIT.getCluster(), tableName);
            c.tableOperations().flush(tableName, null, null, true);
            for (int i = 0; i < 5; ++i) {
                UtilWaitThread.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
                if (c.tableOperations().listSplits(tableName).size() > 20) break;
            }
            Assertions.assertTrue((c.tableOperations().listSplits(tableName).size() > 20 ? 1 : 0) != 0);
        }
    }

    private String getDir() throws Exception {
        String rootPath = SplitIT.getCluster().getTemporaryPath().toString();
        String dir = rootPath + "/" + this.getUniqueNames(1)[0];
        SplitIT.getCluster().getFileSystem().delete(new Path(dir), true);
        return dir;
    }

    @Test
    @SuppressFBWarnings(value={"PREDICTABLE_RANDOM", "DMI_RANDOM_USED_ONLY_ONCE"}, justification="predictable random with specific seed is intended for this test")
    public void bulkImportThatCantSplitHangsCompaction() throws Exception {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(SplitIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            c.tableOperations().create(tableName, new NewTableConfiguration().setProperties(Collections.singletonMap(Property.TABLE_SPLIT_THRESHOLD.getKey(), "10K")));
            Random random = new Random();
            byte[] val = new byte[100];
            String dir = this.getDir();
            String file = dir + "/f1.rf";
            try (RFileWriter writer = RFile.newWriter().to(file).withFileSystem(SplitIT.getFileSystem()).build();){
                writer.startDefaultLocalityGroup();
                for (int i = 0; i < 1000; ++i) {
                    random.nextBytes(val);
                    writer.append(new Key((CharSequence)"r1", (CharSequence)"f1", (CharSequence)String.format("%09d", i)), new Value((CharSequence)Base64.getEncoder().encodeToString(val)));
                }
            }
            c.tableOperations().importDirectory(dir).to(tableName).load();
            Assertions.assertEquals((int)0, (int)c.tableOperations().listSplits(tableName).size());
            Thread.sleep(1000L);
            c.tableOperations().compact(tableName, new CompactionConfig().setWait(true));
            Assertions.assertTrue((c.createScanner(tableName).stream().mapToLong(entry -> ((Value)entry.getValue()).getSize()).sum() > 100000L ? 1 : 0) != 0);
            Assertions.assertEquals((long)1000L, (long)c.createScanner(tableName).stream().count());
        }
    }
}

