/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.ScannerImpl;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.metadata.schema.MetadataTime;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.ColumnFQ;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.manager.state.Assignment;
import org.apache.accumulo.server.util.ManagerMetadataUtil;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitRecoveryIT
extends ConfigurableMacBase {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(1L);
    }

    private KeyExtent nke(String table, String endRow, String prevEndRow) {
        return new KeyExtent(TableId.of((String)table), endRow == null ? null : new Text(endRow), prevEndRow == null ? null : new Text(prevEndRow));
    }

    private void run(ServerContext c) throws Exception {
        ServiceLock.ServiceLockPath zPath = ServiceLock.path((String)(c.getZooKeeperRoot() + "/testLock"));
        ZooReaderWriter zoo = c.getZooReaderWriter();
        zoo.putPersistentData(zPath.toString(), new byte[0], ZooUtil.NodeExistsPolicy.OVERWRITE);
        ServiceLock zl = new ServiceLock(zoo.getZooKeeper(), zPath, UUID.randomUUID());
        boolean gotLock = zl.tryLock(new ServiceLock.LockWatcher(){

            @SuppressFBWarnings(value={"DM_EXIT"}, justification="System.exit() is a bad idea here, but okay for now, since it's a test")
            public void lostLock(ServiceLock.LockLossReason reason) {
                System.exit(-1);
            }

            @SuppressFBWarnings(value={"DM_EXIT"}, justification="System.exit() is a bad idea here, but okay for now, since it's a test")
            public void unableToMonitorLockNode(Exception e) {
                System.exit(-1);
            }
        }, "foo".getBytes(StandardCharsets.UTF_8));
        if (!gotLock) {
            System.err.println("Failed to get lock " + zPath);
        }
        this.runSplitRecoveryTest(c, 0, "sp", 0, zl, this.nke("foo0", null, null));
        this.runSplitRecoveryTest(c, 1, "sp", 0, zl, this.nke("foo1", null, null));
        this.runSplitRecoveryTest(c, 0, "k", 0, zl, this.nke("foo2", "m", null), this.nke("foo2", null, "m"));
        this.runSplitRecoveryTest(c, 1, "k", 0, zl, this.nke("foo3", "m", null), this.nke("foo3", null, "m"));
        this.runSplitRecoveryTest(c, 0, "o", 1, zl, this.nke("foo4", "m", null), this.nke("foo4", null, "m"));
        this.runSplitRecoveryTest(c, 1, "o", 1, zl, this.nke("foo5", "m", null), this.nke("foo5", null, "m"));
        this.runSplitRecoveryTest(c, 0, "o", 1, zl, this.nke("foo6", "m", null), this.nke("foo6", "r", "m"), this.nke("foo6", null, "r"));
        this.runSplitRecoveryTest(c, 1, "o", 1, zl, this.nke("foo7", "m", null), this.nke("foo7", "r", "m"), this.nke("foo7", null, "r"));
        this.runSplitRecoveryTest(c, 0, "g", 0, zl, this.nke("foo8", "m", null), this.nke("foo8", "r", "m"), this.nke("foo8", null, "r"));
        this.runSplitRecoveryTest(c, 1, "g", 0, zl, this.nke("foo9", "m", null), this.nke("foo9", "r", "m"), this.nke("foo9", null, "r"));
        this.runSplitRecoveryTest(c, 0, "w", 2, zl, this.nke("fooa", "m", null), this.nke("fooa", "r", "m"), this.nke("fooa", null, "r"));
        this.runSplitRecoveryTest(c, 1, "w", 2, zl, this.nke("foob", "m", null), this.nke("foob", "r", "m"), this.nke("foob", null, "r"));
    }

    private void runSplitRecoveryTest(ServerContext context, int failPoint, String mr, int extentToSplit, ServiceLock zl, KeyExtent ... extents) throws Exception {
        Text midRow = new Text(mr);
        TreeMap splitMapFiles = null;
        for (int i = 0; i < extents.length; ++i) {
            KeyExtent extent = extents[i];
            String dirName = "dir_" + i;
            String tdir = (String)context.getTablesDirs().iterator().next() + "/" + extent.tableId() + "/" + dirName;
            MetadataTableUtil.addTablet((KeyExtent)extent, (String)dirName, (ServerContext)context, (TimeType)TimeType.LOGICAL, (ServiceLock)zl);
            TreeMap<TabletFile, DataFileValue> mapFiles = new TreeMap<TabletFile, DataFileValue>();
            mapFiles.put(new TabletFile(new Path(tdir + "/rf_000_000")), new DataFileValue((long)(1000017 + i), (long)(10000 + i)));
            int tid = 0;
            TransactionWatcher.ZooArbitrator.start((ServerContext)context, (String)"bulkTx", (long)tid);
            TreeMap storedFiles = new TreeMap(MetadataTableUtil.updateTabletDataFile((long)tid, (KeyExtent)extent, mapFiles, (MetadataTime)new MetadataTime(0L, TimeType.LOGICAL), (ServerContext)context, (ServiceLock)zl));
            if (i != extentToSplit) continue;
            splitMapFiles = storedFiles;
        }
        KeyExtent extent = extents[extentToSplit];
        KeyExtent high = new KeyExtent(extent.tableId(), extent.endRow(), midRow);
        KeyExtent low = new KeyExtent(extent.tableId(), midRow, extent.prevEndRow());
        this.splitPartiallyAndRecover(context, extent, high, low, 0.4, splitMapFiles, midRow, "localhost:1234", failPoint, zl);
    }

    private static Map<Long, List<TabletFile>> getBulkFilesLoaded(ServerContext context, KeyExtent extent) {
        HashMap<Long, List<TabletFile>> bulkFiles = new HashMap<Long, List<TabletFile>>();
        context.getAmple().readTablet(extent, new TabletMetadata.ColumnType[0]).getLoaded().forEach((path, txid) -> bulkFiles.computeIfAbsent((Long)txid, k -> new ArrayList()).add(path));
        return bulkFiles;
    }

    private void splitPartiallyAndRecover(ServerContext context, KeyExtent extent, KeyExtent high, KeyExtent low, double splitRatio, SortedMap<StoredTabletFile, DataFileValue> mapFiles, Text midRow, String location, int steps, ServiceLock zl) throws Exception {
        TreeMap<StoredTabletFile, DataFileValue> lowDatafileSizes = new TreeMap<StoredTabletFile, DataFileValue>();
        TreeMap<StoredTabletFile, DataFileValue> highDatafileSizes = new TreeMap<StoredTabletFile, DataFileValue>();
        ArrayList highDatafilesToRemove = new ArrayList();
        MetadataTableUtil.splitDatafiles((Text)midRow, (double)splitRatio, new HashMap(), mapFiles, lowDatafileSizes, highDatafileSizes, highDatafilesToRemove);
        MetadataTableUtil.splitTablet((KeyExtent)high, (Text)extent.prevEndRow(), (double)splitRatio, (ServerContext)context, (ServiceLock)zl, Set.of());
        TServerInstance instance = new TServerInstance(location, zl.getSessionId());
        Assignment assignment = new Assignment(high, instance, null);
        Ample.TabletMutator tabletMutator = context.getAmple().mutateTablet(extent);
        tabletMutator.putLocation(TabletMetadata.Location.future((TServerInstance)assignment.server));
        tabletMutator.mutate();
        if (steps >= 1) {
            Map<Long, List<TabletFile>> bulkFiles = SplitRecoveryIT.getBulkFilesLoaded(context, high);
            ManagerMetadataUtil.addNewTablet((ServerContext)context, (KeyExtent)low, (String)"lowDir", (TServerInstance)instance, lowDatafileSizes, bulkFiles, (MetadataTime)new MetadataTime(0L, TimeType.LOGICAL), (long)-1L, (long)-1L, (ServiceLock)zl);
        }
        if (steps >= 2) {
            MetadataTableUtil.finishSplit((KeyExtent)high, highDatafileSizes, highDatafilesToRemove, (ServerContext)context, (ServiceLock)zl);
        }
        TabletMetadata meta = context.getAmple().readTablet(high, new TabletMetadata.ColumnType[0]);
        KeyExtent fixedExtent = ManagerMetadataUtil.fixSplit((ServerContext)context, (TabletMetadata)meta, (ServiceLock)zl);
        if (steps < 2) {
            Assertions.assertEquals((double)splitRatio, (double)meta.getSplitRatio(), (double)0.0);
        }
        if (steps >= 1) {
            Assertions.assertEquals((Object)high, (Object)fixedExtent);
            this.ensureTabletHasNoUnexpectedMetadataEntries(context, low, lowDatafileSizes);
            this.ensureTabletHasNoUnexpectedMetadataEntries(context, high, highDatafileSizes);
            Map<Long, List<TabletFile>> lowBulkFiles = SplitRecoveryIT.getBulkFilesLoaded(context, low);
            Map<Long, List<TabletFile>> highBulkFiles = SplitRecoveryIT.getBulkFilesLoaded(context, high);
            if (!lowBulkFiles.equals(highBulkFiles)) {
                throw new Exception(" " + lowBulkFiles + " != " + highBulkFiles + " " + low + " " + high);
            }
            if (lowBulkFiles.isEmpty()) {
                throw new Exception(" no bulk files " + low);
            }
        } else {
            Assertions.assertEquals((Object)extent, (Object)fixedExtent);
            this.ensureTabletHasNoUnexpectedMetadataEntries(context, extent, mapFiles);
        }
    }

    private void ensureTabletHasNoUnexpectedMetadataEntries(ServerContext context, KeyExtent extent, SortedMap<StoredTabletFile, DataFileValue> expectedMapFiles) throws Exception {
        try (ScannerImpl scanner = new ScannerImpl((ClientContext)context, MetadataTable.ID, Authorizations.EMPTY);){
            scanner.setRange(extent.toMetaRange());
            HashSet<ColumnFQ> expectedColumns = new HashSet<ColumnFQ>();
            expectedColumns.add(MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN);
            expectedColumns.add(MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN);
            expectedColumns.add(MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN);
            expectedColumns.add(MetadataSchema.TabletsSection.ServerColumnFamily.LOCK_COLUMN);
            HashSet<Text> expectedColumnFamilies = new HashSet<Text>();
            expectedColumnFamilies.add(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            expectedColumnFamilies.add(MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME);
            expectedColumnFamilies.add(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
            expectedColumnFamilies.add(MetadataSchema.TabletsSection.LastLocationColumnFamily.NAME);
            expectedColumnFamilies.add(MetadataSchema.TabletsSection.BulkFileColumnFamily.NAME);
            Iterator iter = scanner.iterator();
            boolean sawPer = false;
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                Key key = (Key)entry.getKey();
                if (!key.getRow().equals((Object)extent.toMetaRow())) {
                    throw new Exception("Tablet " + extent + " contained unexpected " + MetadataTable.NAME + " entry " + key);
                }
                if (MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.hasColumns(key)) {
                    sawPer = true;
                    if (!KeyExtent.fromMetaPrevRow((Map.Entry)entry).equals((Object)extent)) {
                        throw new Exception("Unexpected prev end row " + entry);
                    }
                }
                if (expectedColumnFamilies.contains(key.getColumnFamily()) || expectedColumns.remove(new ColumnFQ(key))) continue;
                throw new Exception("Tablet " + extent + " contained unexpected " + MetadataTable.NAME + " entry " + key);
            }
            if (expectedColumns.size() > 1 || expectedColumns.size() == 1) {
                throw new Exception("Not all expected columns seen " + extent + " " + expectedColumns);
            }
            Assertions.assertTrue((boolean)sawPer);
            SortedMap fixedMapFiles = (SortedMap)MetadataTableUtil.getFileAndLogEntries((ServerContext)context, (KeyExtent)extent).getSecond();
            this.verifySame(expectedMapFiles, fixedMapFiles);
        }
    }

    private void verifySame(SortedMap<StoredTabletFile, DataFileValue> datafileSizes, SortedMap<StoredTabletFile, DataFileValue> fixedDatafileSizes) throws Exception {
        if (!datafileSizes.keySet().containsAll(fixedDatafileSizes.keySet()) || !fixedDatafileSizes.keySet().containsAll(datafileSizes.keySet())) {
            throw new Exception("Key sets not the same " + datafileSizes.keySet() + " !=  " + fixedDatafileSizes.keySet());
        }
        for (Map.Entry<StoredTabletFile, DataFileValue> entry : datafileSizes.entrySet()) {
            DataFileValue otherDfv;
            DataFileValue dfv = entry.getValue();
            if (dfv.equals((Object)(otherDfv = (DataFileValue)fixedDatafileSizes.get(entry.getKey())))) continue;
            throw new Exception(entry.getKey() + " dfv not equal  " + dfv + "  " + otherDfv);
        }
    }

    public static void main(String[] args) throws Exception {
        new SplitRecoveryIT().run(new ServerContext(SiteConfiguration.auto()));
    }

    @Test
    public void test() throws Exception {
        Assertions.assertEquals((int)0, (int)this.exec(SplitRecoveryIT.class, new String[0]).waitFor());
    }
}

