/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.BinaryIT;
import org.apache.accumulo.test.functional.BulkIT;
import org.apache.accumulo.test.functional.ConcurrencyIT;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.functional.ShutdownIT;
import org.apache.accumulo.test.mapreduce.MapReduceIT;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class SslIT
extends ConfigurableMacBase {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(6L);
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        super.configure(cfg, hadoopCoreSite);
        SslIT.configureForSsl(cfg, SslIT.getSslDir(SslIT.createTestDir(this.getClass().getName() + "_" + this.testName())));
    }

    @Test
    @Timeout(value=4L, unit=TimeUnit.MINUTES)
    public void binary() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            String tableName = this.getUniqueNames(1)[0];
            client.tableOperations().create(tableName);
            BinaryIT.runTest(client, tableName);
        }
    }

    @Test
    @Timeout(value=2L, unit=TimeUnit.MINUTES)
    public void concurrency() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            ConcurrencyIT.runTest(client, this.getUniqueNames(1)[0]);
        }
    }

    @Test
    @Timeout(value=3L, unit=TimeUnit.MINUTES)
    public void adminStop() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            ShutdownIT.runAdminStopTest(client, this.getCluster());
        }
    }

    @Test
    @Timeout(value=4L, unit=TimeUnit.MINUTES)
    public void bulk() throws Exception {
        Properties props = this.getClientProperties();
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(props).build();){
            BulkIT.runTest(client, this.cluster.getFileSystem(), new Path(this.getCluster().getConfig().getDir().getAbsolutePath(), "tmp"), this.getUniqueNames(1)[0], this.getClass().getName(), this.testName(), true);
        }
    }

    @Test
    @Timeout(value=1L, unit=TimeUnit.MINUTES)
    public void mapReduce() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(this.getClientProperties()).build();){
            MapReduceIT.runTest(client, this.getCluster());
        }
    }
}

