/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.CompactionStrategyConfig;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.admin.PluginConfig;
import org.apache.accumulo.core.client.admin.SummaryRetriever;
import org.apache.accumulo.core.client.admin.compaction.CompactionSelector;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.client.summary.CounterSummary;
import org.apache.accumulo.core.client.summary.Summarizer;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.client.summary.Summary;
import org.apache.accumulo.core.client.summary.summarizers.FamilySummarizer;
import org.apache.accumulo.core.client.summary.summarizers.VisibilitySummarizer;
import org.apache.accumulo.core.clientImpl.AccumuloServerException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Filter;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.test.functional.BasicSummarizer;
import org.apache.accumulo.tserver.compaction.CompactionPlan;
import org.apache.accumulo.tserver.compaction.CompactionStrategy;
import org.apache.accumulo.tserver.compaction.MajorCompactionRequest;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class SummaryIT
extends SharedMiniClusterBase {
    @BeforeAll
    public static void setup() throws Exception {
        SharedMiniClusterBase.startMiniCluster();
    }

    @AfterAll
    public static void teardown() {
        SharedMiniClusterBase.stopMiniCluster();
    }

    private LongSummaryStatistics getTimestampStats(String table, AccumuloClient c) throws TableNotFoundException {
        try (Scanner scanner = c.createScanner(table, Authorizations.EMPTY);){
            LongSummaryStatistics longSummaryStatistics = scanner.stream().mapToLong(e -> ((Key)e.getKey()).getTimestamp()).summaryStatistics();
            return longSummaryStatistics;
        }
    }

    private LongSummaryStatistics getTimestampStats(String table, AccumuloClient c, String startRow, String endRow) throws TableNotFoundException {
        try (Scanner scanner = c.createScanner(table, Authorizations.EMPTY);){
            scanner.setRange(new Range((CharSequence)startRow, false, (CharSequence)endRow, true));
            LongSummaryStatistics longSummaryStatistics = scanner.stream().mapToLong(e -> ((Key)e.getKey()).getTimestamp()).summaryStatistics();
            return longSummaryStatistics;
        }
    }

    private void checkSummaries(Collection<Summary> summaries, SummarizerConfiguration sc, int total, int missing, int extra, Object ... kvs) {
        Summary summary = this.getOnlyElement(summaries);
        Assertions.assertEquals((long)total, (long)summary.getFileStatistics().getTotal(), (String)"total wrong");
        Assertions.assertEquals((long)missing, (long)summary.getFileStatistics().getMissing(), (String)"missing wrong");
        Assertions.assertEquals((long)extra, (long)summary.getFileStatistics().getExtra(), (String)"extra wrong");
        Assertions.assertEquals((long)0L, (long)summary.getFileStatistics().getDeleted(), (String)"deleted wrong");
        Assertions.assertEquals((Object)sc, (Object)summary.getSummarizerConfiguration());
        HashMap<String, Long> expected = new HashMap<String, Long>();
        for (int i = 0; i < kvs.length; i += 2) {
            expected.put((String)kvs[i], (Long)kvs[i + 1]);
        }
        Assertions.assertEquals(expected, (Object)summary.getStatistics());
    }

    private void addSplits(String table, AccumuloClient c, String ... splits) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        c.tableOperations().addSplits(table, (SortedSet)Stream.of(splits).map(Text::new).collect(Collectors.toCollection(TreeSet::new)));
    }

    @Test
    public void basicSummaryTest() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(SummaryIT.getClientProps()).build();){
            NewTableConfiguration ntc = new NewTableConfiguration();
            SummarizerConfiguration sc1 = SummarizerConfiguration.builder((String)BasicSummarizer.class.getName()).build();
            ntc.enableSummarization(new SummarizerConfiguration[]{sc1});
            c.tableOperations().create(table, ntc);
            BatchWriter bw = this.writeData(table, c);
            List summaries = c.tableOperations().summaries(table).flush(false).retrieve();
            Assertions.assertEquals((int)0, (int)summaries.size());
            LongSummaryStatistics stats = this.getTimestampStats(table, c);
            summaries = c.tableOperations().summaries(table).flush(true).retrieve();
            this.checkSummaries(summaries, sc1, 1, 0, 0, "total", 100000L, "minTimestamp", stats.getMin(), "maxTimestamp", stats.getMax(), "deletes", 0L);
            Mutation m = new Mutation((CharSequence)String.format("r%09x", 999));
            m.put((CharSequence)"f1", (CharSequence)"q1", (CharSequence)"999-0");
            m.putDelete((CharSequence)"f1", (CharSequence)"q2");
            bw.addMutation(m);
            bw.flush();
            c.tableOperations().flush(table, null, null, true);
            stats = this.getTimestampStats(table, c);
            summaries = c.tableOperations().summaries(table).retrieve();
            this.checkSummaries(summaries, sc1, 2, 0, 0, "total", 100002L, "minTimestamp", stats.getMin(), "maxTimestamp", stats.getMax(), "deletes", 1L);
            bw.close();
            c.tableOperations().compact(table, new CompactionConfig().setWait(true));
            summaries = c.tableOperations().summaries(table).retrieve();
            this.checkSummaries(summaries, sc1, 1, 0, 0, "total", 100000L, "minTimestamp", stats.getMin(), "maxTimestamp", stats.getMax(), "deletes", 0L);
            String sp1 = String.format("r%09x", 50000);
            this.addSplits(table, c, sp1);
            summaries = c.tableOperations().summaries(table).retrieve();
            this.checkSummaries(summaries, sc1, 1, 0, 0, "total", 100000L, "minTimestamp", stats.getMin(), "maxTimestamp", stats.getMax(), "deletes", 0L);
            c.tableOperations().compact(table, new CompactionConfig().setStartRow(new Text(sp1)).setWait(true));
            summaries = c.tableOperations().summaries(table).retrieve();
            this.checkSummaries(summaries, sc1, 2, 0, 1, "total", 113999L, "minTimestamp", stats.getMin(), "maxTimestamp", stats.getMax(), "deletes", 0L);
            stats = this.getTimestampStats(table, c, sp1, null);
            summaries = c.tableOperations().summaries(table).startRow((CharSequence)sp1).retrieve();
            this.checkSummaries(summaries, sc1, 1, 0, 0, "total", 49999L, "minTimestamp", stats.getMin(), "maxTimestamp", stats.getMax(), "deletes", 0L);
            c.tableOperations().compact(table, new CompactionConfig());
            summaries = c.tableOperations().summaries(table).retrieve();
            stats = this.getTimestampStats(table, c);
            this.checkSummaries(summaries, sc1, 2, 0, 0, "total", 100000L, "minTimestamp", stats.getMin(), "maxTimestamp", stats.getMax(), "deletes", 0L);
            summaries = c.tableOperations().summaries(table).startRow((CharSequence)String.format("r%09x", 75000)).endRow((CharSequence)String.format("r%09x", 80000)).retrieve();
            Summary summary = (Summary)this.getOnlyElement(summaries);
            Assertions.assertEquals((long)1L, (long)summary.getFileStatistics().getTotal());
            Assertions.assertEquals((long)1L, (long)summary.getFileStatistics().getExtra());
            long total = (Long)summary.getStatistics().get("total");
            Assertions.assertTrue((total > 0L && total <= 10000L ? 1 : 0) != 0, (String)("Total " + total + " out of expected range"));
            c.tableOperations().removeSummarizers(table, sc -> sc.getClassName().contains("foo"));
            List summarizers = c.tableOperations().listSummarizers(table);
            Assertions.assertEquals((int)1, (int)summarizers.size());
            Assertions.assertTrue((boolean)summarizers.contains(sc1));
            c.tableOperations().removeSummarizers(table, sc -> sc.getClassName().equals(BasicSummarizer.class.getName()));
            summarizers = c.tableOperations().listSummarizers(table);
            Assertions.assertEquals((int)0, (int)summarizers.size());
            c.tableOperations().compact(table, new CompactionConfig().setWait(true));
            summaries = c.tableOperations().summaries(table).retrieve();
            Assertions.assertEquals((int)0, (int)summaries.size());
            c.tableOperations().addSummarizers(table, new SummarizerConfiguration[]{sc1});
            c.tableOperations().compact(table, new CompactionConfig().setWait(true));
            summaries = c.tableOperations().summaries(table).retrieve();
            this.checkSummaries(summaries, sc1, 2, 0, 0, "total", 100000L, "minTimestamp", stats.getMin(), "maxTimestamp", stats.getMax(), "deletes", 0L);
        }
    }

    private BatchWriter writeData(String table, AccumuloClient c) throws TableNotFoundException, MutationsRejectedException {
        BatchWriter bw = c.createBatchWriter(table);
        for (int i = 0; i < 100000; ++i) {
            Mutation m = new Mutation((CharSequence)String.format("r%09x", i));
            m.put((CharSequence)"f1", (CharSequence)"q1", (CharSequence)("" + i));
            bw.addMutation(m);
        }
        bw.flush();
        return bw;
    }

    private static void checkSummary(Collection<Summary> summaries, SummarizerConfiguration sc, Object ... stats) {
        HashMap<String, Long> expected = new HashMap<String, Long>();
        for (int i = 0; i < stats.length; i += 2) {
            expected.put((String)stats[i], (Long)stats[i + 1]);
        }
        for (Summary summary : summaries) {
            if (!summary.getSummarizerConfiguration().equals((Object)sc)) continue;
            Assertions.assertEquals(expected, (Object)summary.getStatistics());
            return;
        }
        Assertions.fail((String)("Did not find summary with config : " + sc));
    }

    @Test
    public void selectionTest() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(SummaryIT.getClientProps()).build();){
            NewTableConfiguration ntc = new NewTableConfiguration();
            SummarizerConfiguration sc1 = SummarizerConfiguration.builder(BasicSummarizer.class).build();
            SummarizerConfiguration sc2 = SummarizerConfiguration.builder(KeySizeSummarizer.class).addOption("maxLen", "512").build();
            ntc.enableSummarization(new SummarizerConfiguration[]{sc1, sc2});
            c.tableOperations().create(table, ntc);
            BatchWriter bw = this.writeData(table, c);
            bw.close();
            c.tableOperations().flush(table, null, null, true);
            LongSummaryStatistics stats = this.getTimestampStats(table, c);
            List summaries = c.tableOperations().summaries(table).withConfiguration(new SummarizerConfiguration[]{sc2}).retrieve();
            Assertions.assertEquals((int)1, (int)summaries.size());
            SummaryIT.checkSummary(summaries, sc2, "len=14", 100000L);
            summaries = c.tableOperations().summaries(table).withConfiguration(new SummarizerConfiguration[]{sc1}).retrieve();
            Assertions.assertEquals((int)1, (int)summaries.size());
            SummaryIT.checkSummary(summaries, sc1, "total", 100000L, "minTimestamp", stats.getMin(), "maxTimestamp", stats.getMax(), "deletes", 0L);
            SummarizerConfiguration sc3 = SummarizerConfiguration.builder((String)KeySizeSummarizer.class.getName()).addOption("maxLen", "256").build();
            summaries = c.tableOperations().summaries(table).withConfiguration(new SummarizerConfiguration[]{sc3}).retrieve();
            Assertions.assertEquals((int)0, (int)summaries.size());
            summaries = c.tableOperations().summaries(table).withConfiguration(new SummarizerConfiguration[]{sc1, sc2}).retrieve();
            Assertions.assertEquals((int)2, (int)summaries.size());
            SummaryIT.checkSummary(summaries, sc1, "total", 100000L, "minTimestamp", stats.getMin(), "maxTimestamp", stats.getMax(), "deletes", 0L);
            SummaryIT.checkSummary(summaries, sc2, "len=14", 100000L);
            summaries = c.tableOperations().summaries(table).retrieve();
            Assertions.assertEquals((int)2, (int)summaries.size());
            SummaryIT.checkSummary(summaries, sc1, "total", 100000L, "minTimestamp", stats.getMin(), "maxTimestamp", stats.getMax(), "deletes", 0L);
            SummaryIT.checkSummary(summaries, sc2, "len=14", 100000L);
            summaries = c.tableOperations().summaries(table).withMatchingConfiguration(".*BasicSummarizer \\{\\}.*").retrieve();
            Assertions.assertEquals((int)1, (int)summaries.size());
            SummaryIT.checkSummary(summaries, sc1, "total", 100000L, "minTimestamp", stats.getMin(), "maxTimestamp", stats.getMax(), "deletes", 0L);
            summaries = c.tableOperations().summaries(table).withMatchingConfiguration(".*KeySizeSummarizer \\{maxLen=512\\}.*").retrieve();
            Assertions.assertEquals((int)1, (int)summaries.size());
            SummaryIT.checkSummary(summaries, sc2, "len=14", 100000L);
            summaries = c.tableOperations().summaries(table).withMatchingConfiguration(".*KeySizeSummarizer \\{maxLen=256\\}.*").retrieve();
            Assertions.assertEquals((int)0, (int)summaries.size());
            summaries = c.tableOperations().summaries(table).withMatchingConfiguration(".*BasicSummarizer \\{\\}.*").withConfiguration(new SummarizerConfiguration[]{sc2}).retrieve();
            Assertions.assertEquals((int)2, (int)summaries.size());
            SummaryIT.checkSummary(summaries, sc1, "total", 100000L, "minTimestamp", stats.getMin(), "maxTimestamp", stats.getMax(), "deletes", 0L);
            SummaryIT.checkSummary(summaries, sc2, "len=14", 100000L);
            Assertions.assertThrows(PatternSyntaxException.class, () -> c.tableOperations().summaries(table).withMatchingConfiguration(".*KeySizeSummarizer {maxLen=256}.*").retrieve(), (String)"Bad regex should have caused exception");
        }
    }

    @Test
    public void compactionSelectorTest() throws Exception {
        PluginConfig csc = new PluginConfig(FooSelector.class.getName());
        CompactionConfig compactConfig = new CompactionConfig().setSelector(csc);
        this.compactionTest(compactConfig);
    }

    @Test
    public void compactionStrategyTest() throws Exception {
        CompactionStrategyConfig csc = new CompactionStrategyConfig(FooCS.class.getName());
        CompactionConfig compactConfig = new CompactionConfig().setCompactionStrategy(csc);
        this.compactionTest(compactConfig);
    }

    private void compactionTest(CompactionConfig compactConfig) throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(SummaryIT.getClientProps()).build();){
            Map counts;
            NewTableConfiguration ntc = new NewTableConfiguration();
            SummarizerConfiguration sc1 = SummarizerConfiguration.builder((String)FooCounter.class.getName()).build();
            ntc.enableSummarization(new SummarizerConfiguration[]{sc1});
            c.tableOperations().create(table, ntc);
            try (BatchWriter bw = c.createBatchWriter(table);){
                this.write(bw, "bar1", "f1", "q1", "v1");
                this.write(bw, "bar2", "f1", "q1", "v2");
                this.write(bw, "foo1", "f1", "q1", "v3");
            }
            List<IteratorSetting> iterators = Collections.singletonList(new IteratorSetting(100, FooFilter.class));
            compactConfig = compactConfig.setFlush(true).setIterators(iterators).setWait(true);
            c.tableOperations().compact(table, compactConfig);
            try (Scanner scanner = c.createScanner(table, Authorizations.EMPTY);){
                counts = scanner.stream().map(e -> ((Key)e.getKey()).getRowData().toString()).map(r -> r.replaceAll("[0-9]+", "")).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
                Assertions.assertEquals((long)1L, (long)counts.getOrDefault("foo", 0L));
                Assertions.assertEquals((long)2L, (long)counts.getOrDefault("bar", 0L));
                Assertions.assertEquals((int)2, (int)counts.size());
            }
            try (BatchWriter bw = c.createBatchWriter(table);){
                this.write(bw, "foo2", "f1", "q1", "v4");
                this.write(bw, "foo3", "f1", "q1", "v5");
                this.write(bw, "foo4", "f1", "q1", "v6");
            }
            c.tableOperations().compact(table, compactConfig);
            scanner = c.createScanner(table, Authorizations.EMPTY);
            try {
                counts = scanner.stream().map(e -> ((Key)e.getKey()).getRowData().toString()).map(r -> r.replaceAll("[0-9]+", "")).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
                Assertions.assertEquals((long)0L, (long)counts.getOrDefault("foo", 0L));
                Assertions.assertEquals((long)2L, (long)counts.getOrDefault("bar", 0L));
                Assertions.assertEquals((int)1, (int)counts.size());
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
    }

    @Test
    public void testBuggySummarizer() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(SummaryIT.getClientProps()).build();){
            SummarizerConfiguration sc1 = SummarizerConfiguration.builder(BuggySummarizer.class).build();
            TreeSet<Text> split = new TreeSet<Text>(Collections.singleton(new Text("g")));
            NewTableConfiguration ntc = new NewTableConfiguration().enableSummarization(new SummarizerConfiguration[]{sc1}).withSplits(split);
            c.tableOperations().create(table, ntc);
            try (BatchWriter bw = c.createBatchWriter(table);){
                this.write(bw, "bar1", "f1", "q1", "v1");
                this.write(bw, "bar2", "f1", "q1", "v2");
                this.write(bw, "foo1", "f1", "q1", "v3");
            }
            c.tableOperations().flush(table, null, null, true);
            Assertions.assertThrows(AccumuloServerException.class, () -> c.tableOperations().summaries(table).retrieve(), (String)"Expected server side failure and did not see it");
        }
    }

    @Test
    public void testPermissions() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(SummaryIT.getClientProps()).build();){
            NewTableConfiguration ntc = new NewTableConfiguration();
            SummarizerConfiguration sc1 = SummarizerConfiguration.builder(FooCounter.class).build();
            ntc.enableSummarization(new SummarizerConfiguration[]{sc1});
            c.tableOperations().create(table, ntc);
            try (BatchWriter bw = c.createBatchWriter(table);){
                this.write(bw, "bar1", "f1", "q1", "v1");
                this.write(bw, "bar2", "f1", "q1", "v2");
                this.write(bw, "foo1", "f1", "q1", "v3");
            }
            c.tableOperations().flush(table, null, null, true);
            PasswordToken passTok = new PasswordToken((CharSequence)"letmesee");
            c.securityOperations().createLocalUser("user1", passTok);
            try (AccumuloClient c2 = (AccumuloClient)Accumulo.newClient().from(c.properties()).as((CharSequence)"user1", (AuthenticationToken)passTok).build();){
                AccumuloSecurityException e = (AccumuloSecurityException)Assertions.assertThrows(AccumuloSecurityException.class, () -> c2.tableOperations().summaries(table).retrieve(), (String)"Expected operation to fail because user does not have permission to get summaries");
                Assertions.assertEquals((Object)SecurityErrorCode.PERMISSION_DENIED, (Object)e.getSecurityErrorCode());
                c.securityOperations().grantTablePermission("user1", table, TablePermission.GET_SUMMARIES);
                for (int tries = 0; tries < 10; ++tries) {
                    try {
                        Summary summary = (Summary)c2.tableOperations().summaries(table).retrieve().get(0);
                        Assertions.assertEquals((int)2, (int)summary.getStatistics().size());
                        Assertions.assertEquals((long)2L, (long)summary.getStatistics().getOrDefault("bars", 0L));
                        Assertions.assertEquals((long)1L, (long)summary.getStatistics().getOrDefault("foos", 0L));
                        break;
                    }
                    catch (AccumuloSecurityException ase) {
                        UtilWaitThread.sleep((long)500L);
                        continue;
                    }
                }
            }
        }
    }

    @Test
    public void tooLargeTest() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(SummaryIT.getClientProps()).build();){
            NewTableConfiguration ntc = new NewTableConfiguration();
            SummarizerConfiguration sc1 = SummarizerConfiguration.builder(BigSummarizer.class).build();
            ntc.enableSummarization(new SummarizerConfiguration[]{sc1});
            c.tableOperations().create(table, ntc);
            try (BatchWriter bw = c.createBatchWriter(table);){
                this.write(bw, "a_large", "f1", "q1", "v1");
                this.write(bw, "v_small", "f1", "q1", "v2");
            }
            c.tableOperations().flush(table, null, null, true);
            Summary summary = (Summary)c.tableOperations().summaries(table).retrieve().get(0);
            Assertions.assertEquals((long)1L, (long)summary.getFileStatistics().getLarge());
            Assertions.assertEquals((long)0L, (long)summary.getFileStatistics().getMissing());
            Assertions.assertEquals((long)0L, (long)summary.getFileStatistics().getExtra());
            Assertions.assertEquals((long)0L, (long)summary.getFileStatistics().getDeleted());
            Assertions.assertEquals((long)1L, (long)summary.getFileStatistics().getInaccurate());
            Assertions.assertEquals((long)1L, (long)summary.getFileStatistics().getTotal());
            Assertions.assertEquals(Collections.emptyMap(), (Object)summary.getStatistics());
            c.tableOperations().addSplits(table, new TreeSet<Text>(Collections.singleton(new Text("m"))));
            c.tableOperations().compact(table, new CompactionConfig().setWait(true));
            summary = (Summary)c.tableOperations().summaries(table).retrieve().get(0);
            Assertions.assertEquals((long)1L, (long)summary.getFileStatistics().getLarge());
            Assertions.assertEquals((long)0L, (long)summary.getFileStatistics().getMissing());
            Assertions.assertEquals((long)0L, (long)summary.getFileStatistics().getExtra());
            Assertions.assertEquals((long)0L, (long)summary.getFileStatistics().getDeleted());
            Assertions.assertEquals((long)1L, (long)summary.getFileStatistics().getInaccurate());
            Assertions.assertEquals((long)2L, (long)summary.getFileStatistics().getTotal());
            HashMap<String, Long> expected = new HashMap<String, Long>();
            for (int i = 0; i < 10; ++i) {
                expected.put(String.format("%09x", i), (long)i * 19L);
            }
            Assertions.assertEquals(expected, (Object)summary.getStatistics());
        }
    }

    private void write(BatchWriter bw, String row, String family, String qualifier, String value) throws MutationsRejectedException {
        Mutation m1 = new Mutation((CharSequence)row);
        m1.put((CharSequence)family, (CharSequence)qualifier, (CharSequence)value);
        bw.addMutation(m1);
    }

    private void write(BatchWriter bw, Map<Key, Value> expected, String row, String family, String qualifier, long ts, String value) throws MutationsRejectedException {
        Mutation m1 = new Mutation((CharSequence)row);
        m1.put((CharSequence)family, (CharSequence)qualifier, ts, (CharSequence)value);
        bw.addMutation(m1);
        expected.put(Key.builder().row((CharSequence)row).family((CharSequence)family).qualifier((CharSequence)qualifier).timestamp(ts).build(), new Value((CharSequence)value));
    }

    private Map<String, Long> nm(Object ... entries) {
        IntPredicate evenIndex = i -> i % 2 == 0;
        return IntStream.range(0, entries.length).filter(evenIndex).boxed().collect(Collectors.toUnmodifiableMap(i -> (String)entries[i], i -> (Long)entries[i + 1]));
    }

    @Test
    public void testLocalityGroups() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(SummaryIT.getClientProps()).build();){
            NewTableConfiguration ntc = new NewTableConfiguration();
            SummarizerConfiguration sc1 = SummarizerConfiguration.builder(FamilySummarizer.class).build();
            SummarizerConfiguration sc2 = SummarizerConfiguration.builder(BasicSummarizer.class).build();
            ntc.enableSummarization(new SummarizerConfiguration[]{sc1, sc2});
            HashMap<String, Set<Text>> lgroups = new HashMap<String, Set<Text>>();
            lgroups.put("lg1", Set.of(new Text("chocolate"), new Text("coffee")));
            lgroups.put("lg2", Set.of(new Text(" broccoli "), new Text("cabbage")));
            lgroups.put("lg3", Set.of(new Text(" apple "), new Text("orange")));
            ntc.setLocalityGroups(lgroups);
            c.tableOperations().create(table, ntc);
            HashMap<Key, Value> expected = new HashMap<Key, Value>();
            try (BatchWriter bw = c.createBatchWriter(table);){
                this.write(bw, expected, "order:001", "chocolate", "dark", 3L, "99kg");
                this.write(bw, expected, "order:001", "chocolate", "light", 4L, "94kg");
                this.write(bw, expected, "order:001", "coffee", "dark", 5L, "33kg");
                this.write(bw, expected, "order:001", "broccoli", "crowns", 6L, "2kg");
                this.write(bw, expected, "order:001", "cheddar", "canadian", 7L, "40kg");
                this.write(bw, expected, "order:653", "chocolate", "dark", 3L, "3kg");
                this.write(bw, expected, "order:653", "chocolate", "light", 4L, "4kg");
                this.write(bw, expected, "order:653", "coffee", "dark", 5L, "2kg");
                this.write(bw, expected, "order:653", "broccoli", "crowns", 6L, "105kg");
                this.write(bw, expected, "order:653", "cabbage", "heads", 7L, "199kg");
                this.write(bw, expected, "order:653", "cheddar", "canadian", 8L, "43kg");
            }
            List summaries = c.tableOperations().summaries(table).flush(true).retrieve();
            Assertions.assertEquals((long)2L, (long)summaries.stream().map(Summary::getSummarizerConfiguration).distinct().count());
            for (Summary summary : summaries) {
                Map<String, Long> expectedStats;
                if (summary.getSummarizerConfiguration().equals((Object)sc1)) {
                    expectedStats = this.nm("c:chocolate", 4L, "c:coffee", 2L, "c:broccoli", 2L, "c:cheddar", 2L, "c:cabbage", 1L, "tooLong", 0L, "tooMany", 0L, "seen", 11L, "emitted", 11L, "deletesIgnored", 0L);
                    Assertions.assertEquals(expectedStats, (Object)summary.getStatistics());
                    Assertions.assertEquals((long)0L, (long)summary.getFileStatistics().getInaccurate());
                    Assertions.assertEquals((long)1L, (long)summary.getFileStatistics().getTotal());
                    continue;
                }
                if (summary.getSummarizerConfiguration().equals((Object)sc2)) {
                    expectedStats = this.nm("deletes", 0L, "total", 11L, "minTimestamp", 3L, "maxTimestamp", 8L);
                    Assertions.assertEquals(expectedStats, (Object)summary.getStatistics());
                    Assertions.assertEquals((long)0L, (long)summary.getFileStatistics().getInaccurate());
                    Assertions.assertEquals((long)1L, (long)summary.getFileStatistics().getTotal());
                    continue;
                }
                Assertions.fail((String)("unexpected summary config " + summary.getSummarizerConfiguration()));
            }
            HashMap actual = new HashMap();
            c.createScanner(table, Authorizations.EMPTY).forEach(e -> actual.put((Key)e.getKey(), (Value)e.getValue()));
            Assertions.assertEquals(expected, actual);
        }
    }

    @Test
    public void testExceptions() throws Exception {
        String testTableName = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(SummaryIT.getClientProps()).build();){
            SummaryRetriever summaryRetriever = c.tableOperations().summaries(testTableName);
            Assertions.assertThrows(TableNotFoundException.class, () -> ((SummaryRetriever)summaryRetriever).retrieve());
            SummarizerConfiguration summarizerConf = SummarizerConfiguration.builder(VisibilitySummarizer.class).build();
            Assertions.assertThrows(TableNotFoundException.class, () -> c.tableOperations().addSummarizers(testTableName, new SummarizerConfiguration[]{summarizerConf}));
            Assertions.assertThrows(TableNotFoundException.class, () -> c.tableOperations().listSummarizers(testTableName));
            Assertions.assertThrows(TableNotFoundException.class, () -> c.tableOperations().removeSummarizers(testTableName, sc -> true));
            SummarizerConfiguration sc1 = SummarizerConfiguration.builder(FamilySummarizer.class).setPropertyId("p1").build();
            SummarizerConfiguration sc2 = SummarizerConfiguration.builder(VisibilitySummarizer.class).setPropertyId("p1").build();
            c.tableOperations().create(testTableName);
            c.tableOperations().addSummarizers(testTableName, new SummarizerConfiguration[]{sc1});
            c.tableOperations().addSummarizers(testTableName, new SummarizerConfiguration[]{sc1});
            Assertions.assertThrows(IllegalArgumentException.class, () -> c.tableOperations().addSummarizers(testTableName, new SummarizerConfiguration[]{sc2}), (String)"adding second summarizer with same id should fail");
            c.tableOperations().removeSummarizers(testTableName, sc -> true);
            Assertions.assertEquals((int)0, (int)c.tableOperations().listSummarizers(testTableName).size());
            Assertions.assertThrows(IllegalArgumentException.class, () -> c.tableOperations().addSummarizers(testTableName, new SummarizerConfiguration[]{sc1, sc2}), (String)"adding two summarizers at the same time with same id should fail");
            Assertions.assertEquals((int)0, (int)c.tableOperations().listSummarizers(testTableName).size());
            c.tableOperations().offline(testTableName, true);
            Assertions.assertThrows(TableOfflineException.class, () -> c.tableOperations().summaries(testTableName).retrieve());
        }
    }

    @Test
    public void testManyFiles() throws Exception {
        String table = this.getUniqueNames(1)[0];
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(SummaryIT.getClientProps()).build();){
            int q = 0;
            TreeSet<Text> partitionKeys = new TreeSet<Text>();
            for (int split = 100000; split < 1000000; split += 100000) {
                partitionKeys.add(new Text(String.format("%06d", split)));
            }
            NewTableConfiguration ntc = new NewTableConfiguration().enableSummarization(new SummarizerConfiguration[]{SummarizerConfiguration.builder(FamilySummarizer.class).build()}).withSplits(partitionKeys);
            c.tableOperations().create(table, ntc);
            HashMap<String, Long> famCounts = new HashMap<String, Long>();
            for (int t = 0; t < 20; ++t) {
                try (BatchWriter bw = c.createBatchWriter(table);){
                    for (int i = 0; i < 10000; ++i) {
                        String row = String.format("%06d", random.nextInt(1000000));
                        String fam = String.format("%03d", random.nextInt(100));
                        String qual = String.format("%06d", q++);
                        this.write(bw, row, fam, qual, "val");
                        famCounts.merge(fam, 1L, Long::sum);
                    }
                }
                List summaries = c.tableOperations().summaries(table).flush(true).retrieve();
                Assertions.assertEquals((int)1, (int)summaries.size());
                CounterSummary cs = new CounterSummary((Summary)summaries.get(0));
                Assertions.assertEquals(famCounts, (Object)cs.getCounters());
                Summary.FileStatistics fileStats = ((Summary)summaries.get(0)).getFileStatistics();
                Assertions.assertEquals((long)0L, (long)fileStats.getInaccurate());
                Assertions.assertTrue((fileStats.getTotal() >= 10L ? 1 : 0) != 0, (String)("Saw " + fileStats.getTotal() + " files expected >=10"));
            }
        }
    }

    public static class KeySizeSummarizer
    implements Summarizer {
        public Summarizer.Collector collector(final SummarizerConfiguration sc) {
            return new Summarizer.Collector(){
                private int maxLen;
                private long[] lengths;
                private long overMax;
                {
                    this.maxLen = Integer.parseInt(sc.getOptions().getOrDefault("maxLen", "1024"));
                    this.lengths = new long[this.maxLen];
                    this.overMax = 0L;
                }

                public void accept(Key k, Value v) {
                    int size = k.getSize();
                    if (size >= this.maxLen) {
                        ++this.overMax;
                    } else {
                        int n = size;
                        this.lengths[n] = this.lengths[n] + 1L;
                    }
                }

                public void summarize(Summarizer.StatisticConsumer sc2) {
                    if (this.overMax > 0L) {
                        sc2.accept("len>=" + this.maxLen, this.overMax);
                    }
                    for (int i = 0; i < this.lengths.length; ++i) {
                        if (this.lengths[i] <= 0L) continue;
                        sc2.accept("len=" + i, this.lengths[i]);
                    }
                }
            };
        }

        public Summarizer.Combiner combiner(SummarizerConfiguration sc) {
            return (m1, m2) -> m2.forEach((k, v) -> m1.merge(k, v, Long::sum));
        }
    }

    public static class FooSelector
    implements CompactionSelector {
        public void init(CompactionSelector.InitParameters iparams) {
        }

        public CompactionSelector.Selection select(CompactionSelector.SelectionParameters sparams) {
            Collection summaries = sparams.getSummaries(sparams.getAvailableFiles(), conf -> conf.getClassName().contains("FooCounter"));
            if (summaries.size() == 1) {
                Summary summary = (Summary)summaries.iterator().next();
                Long foos = summary.getStatistics().getOrDefault("foos", 0L);
                Long bars = summary.getStatistics().getOrDefault("bars", 0L);
                if (foos > bars) {
                    return new CompactionSelector.Selection(sparams.getAvailableFiles());
                }
            }
            return new CompactionSelector.Selection(Set.of());
        }
    }

    public static class FooCS
    extends CompactionStrategy {
        private boolean compact = false;

        public boolean shouldCompact(MajorCompactionRequest request) {
            return true;
        }

        public void gatherInformation(MajorCompactionRequest request) {
            List summaries = request.getSummaries(request.getFiles().keySet(), conf -> conf.getClassName().contains("FooCounter"));
            if (summaries.size() == 1) {
                Summary summary = (Summary)summaries.get(0);
                Long foos = summary.getStatistics().getOrDefault("foos", 0L);
                Long bars = summary.getStatistics().getOrDefault("bars", 0L);
                this.compact = foos > bars;
            }
        }

        public CompactionPlan getCompactionPlan(MajorCompactionRequest request) {
            if (this.compact) {
                CompactionPlan cp = new CompactionPlan();
                cp.inputFiles.addAll(request.getFiles().keySet());
                return cp;
            }
            return null;
        }
    }

    public static class FooCounter
    implements Summarizer {
        public Summarizer.Collector collector(SummarizerConfiguration sc) {
            return new Summarizer.Collector(){
                long foos = 0L;
                long bars = 0L;

                public void accept(Key k, Value v) {
                    String row = k.getRowData().toString();
                    if (row.contains("foo")) {
                        ++this.foos;
                    } else if (row.contains("bar")) {
                        ++this.bars;
                    }
                }

                public void summarize(Summarizer.StatisticConsumer sc) {
                    sc.accept("foos", this.foos);
                    sc.accept("bars", this.bars);
                }
            };
        }

        public Summarizer.Combiner combiner(SummarizerConfiguration sc) {
            return (m1, m2) -> m2.forEach((k, v) -> m1.merge(k, v, Long::sum));
        }
    }

    public static class FooFilter
    extends Filter {
        public boolean accept(Key k, Value v) {
            return !k.getRowData().toString().contains("foo");
        }
    }

    public static class BuggySummarizer
    extends FooCounter {
        @Override
        public Summarizer.Combiner combiner(SummarizerConfiguration sc) {
            return (m1, m2) -> {
                throw new NullPointerException();
            };
        }
    }

    public static class BigSummarizer
    implements Summarizer {
        public Summarizer.Collector collector(SummarizerConfiguration sc) {
            return new Summarizer.Collector(){
                private int num = 10;

                public void accept(Key k, Value v) {
                    if (k.getRowData().toString().contains("large")) {
                        this.num = 100000;
                    }
                }

                public void summarize(Summarizer.StatisticConsumer sc) {
                    for (int i = 0; i < this.num; ++i) {
                        sc.accept(String.format("%09x", i), (long)(i * 19));
                    }
                }
            };
        }

        public Summarizer.Combiner combiner(SummarizerConfiguration sc) {
            return (m1, m2) -> m2.forEach((k, v) -> m1.merge(k, v, Long::sum));
        }
    }
}

