/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.FileNotFoundException;
import java.time.Duration;
import org.apache.accumulo.cluster.AccumuloCluster;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="MiniClusterOnly")
public class TableIT
extends AccumuloClusterHarness {
    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(2L);
    }

    @Test
    public void test() throws Exception {
        Assumptions.assumeTrue((TableIT.getClusterType() == AccumuloClusterHarness.ClusterType.MINI ? 1 : 0) != 0);
        AccumuloCluster cluster = TableIT.getCluster();
        MiniAccumuloClusterImpl mac = (MiniAccumuloClusterImpl)cluster;
        String rootPath = mac.getConfig().getDir().getAbsolutePath();
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(TableIT.getClientProps()).build();){
            TableOperations to = c.tableOperations();
            String tableName = this.getUniqueNames(1)[0];
            to.create(tableName);
            VerifyIngest.VerifyParams params = new VerifyIngest.VerifyParams(TableIT.getClientProps(), tableName);
            TestIngest.ingest(c, params);
            to.flush(tableName, null, null, true);
            VerifyIngest.verifyIngest(c, params);
            TableId id = TableId.of((String)((String)to.tableIdMap().get(tableName)));
            try (Scanner s = c.createScanner(MetadataTable.NAME, Authorizations.EMPTY);){
                s.setRange(new KeyExtent(id, null, null).toMetaRange());
                s.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                Assertions.assertTrue((boolean)s.stream().findAny().isPresent());
                FileSystem fs = TableIT.getCluster().getFileSystem();
                Assertions.assertTrue((fs.listStatus(new Path(rootPath + "/accumulo/tables/" + id)).length > 0 ? 1 : 0) != 0);
                to.delete(tableName);
                Assertions.assertTrue((boolean)s.stream().findAny().isEmpty());
                try {
                    Assertions.assertEquals((int)0, (int)fs.listStatus(new Path(rootPath + "/accumulo/tables/" + id)).length);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                Assertions.assertNull(to.tableIdMap().get(tableName));
                to.create(tableName);
                TestIngest.ingest(c, params);
                VerifyIngest.verifyIngest(c, params);
                to.delete(tableName);
            }
        }
    }
}

