/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TabletIT
extends AccumuloClusterHarness {
    private static final int N = 1000;

    @Override
    protected Duration defaultTimeout() {
        return Duration.ofMinutes(2L);
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        Map siteConfig = cfg.getSiteConfig();
        siteConfig.put(Property.TSERV_MAXMEM.getKey(), "128M");
        cfg.setSiteConfig(siteConfig);
    }

    @Test
    public void createTableTest() throws Exception {
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(TabletIT.getClientProps()).build();){
            String tableName = this.getUniqueNames(1)[0];
            this.createTableTest(client, tableName, false);
            this.createTableTest(client, tableName, true);
        }
    }

    public void createTableTest(AccumuloClient accumuloClient, String tableName, boolean readOnly) throws Exception {
        if (!readOnly) {
            TreeSet<Text> keys = new TreeSet<Text>();
            for (int i = 10; i < 1000; i += 10) {
                keys.add(new Text(String.format("%05d", i)));
            }
            accumuloClient.tableOperations().create(tableName, new NewTableConfiguration().setProperties(Collections.singletonMap(Property.TABLE_SPLIT_THRESHOLD.getKey(), "200")).withSplits(keys));
            try (BatchWriter b = accumuloClient.createBatchWriter(tableName);){
                for (int i = 0; i < 1000; ++i) {
                    Mutation m = new Mutation(new Text(String.format("%05d", i)));
                    m.put((CharSequence)("col" + (i % 3 + 1)), (CharSequence)"qual", (CharSequence)"junk");
                    b.addMutation(m);
                }
            }
        }
        try (Scanner scanner = accumuloClient.createScanner(tableName, Authorizations.EMPTY);){
            int count = 0;
            for (Map.Entry elt : scanner) {
                String expected = String.format("%05d", count);
                Assertions.assertTrue((boolean)((Key)elt.getKey()).getRow().toString().equals(expected));
                ++count;
            }
            Assertions.assertEquals((int)1000, (int)count);
        }
    }
}

